/*
** Copyright 2000-2002 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"dbobj.h"
#include	"afx/afx.h"
#include	"afx/afxtempl.h"
#include	"numlib/numlib.h"
#include	"cmlmarchive.h"

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<sysexits.h>
#include	<iostream>
#include	<fstream>

#include <sys/types.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

static const char rcsid[]="$Id: cmlmdigest.C,v 1.6 2002/02/15 13:31:34 mrsam Exp $";

// --------------------------------------------------------------------------
//
// Send a digest.
//
// --------------------------------------------------------------------------

static int senddigest(CStringList &list)
{
unsigned long nextseqno;
char	buf[NUMBUFSIZE+100];
char	buf2[NUMBUFSIZE+100];
int	rc;
Archive	archive;
CString	filename_str;

	if ( (rc=archive.get_seq_no(nextseqno)) != 0)
		return (rc);

	str_off_t(nextseqno, buf);

	filename_str=archive.filename(nextseqno);

CString	subj;

	{
	ifstream ifs("digestsubj.tmpl");

		if (subj << ifs)
		{
			perror("digestsubj.tmpl");
			return (EX_SOFTWARE);
		}

	int	n=subj.Find('@');

		if (n >= 0)
			subj=subj.Left(n) + buf + subj.Mid(n+1);
	}

int	pipefd[2];

	if (pipe(pipefd) < 0)
	{
		perror("pipe");
		return (EX_TEMPFAIL);
	}

	trapsigs(filename_str);

	int f_fd=open(filename_str, O_RDWR|O_CREAT|O_TRUNC, 0666);

	if (f_fd < 0)
	{
		perror(filename_str);
		return (EX_TEMPFAIL);
	}

	afxopipestream	f(f_fd);

	{
		int h_fd=open("headeradd", O_RDONLY);

		if (h_fd >= 0)
		{
			afxipipestream ifs(h_fd);
			copyio_noseek(ifs, f);
		}
	}

CString	addr=cmdget("ADDRESS");

	f << "From: " << myname() << " <" << addr << ">" << endl
		<< "To: " << addr << endl
		<< subj << endl << flush;

	if (f.bad())
	{
		perror(filename_str);
		f.close();

		clearsigs(EX_SOFTWARE);
		return (EX_SOFTWARE);
	}

pid_t	p;
int	waitstat;

	if ((p=fork()) < 0)
	{
		perror("fork");
		f.close();
		clearsigs(EX_TEMPFAIL);
		return (EX_TEMPFAIL);
	}

	if (p == 0)
	{
		clearsigs(0);
		close(0);
		if (dup(pipefd[0]) < 0)
		{
			perror("dup");
			_exit(EX_TEMPFAIL);
		}
		close(pipefd[0]);
		close(pipefd[1]);
		close(1);
		if (dup(f_fd) < 0)
		{
			perror("dup");
			_exit(EX_TEMPFAIL);
		}
		f.close();
		execl(REFORMIME, "reformime", "-m", (char *)0);
		perror(REFORMIME);
		_exit(EX_TEMPFAIL);
	}

	close(pipefd[0]);

	// Reformime gets filename list on stdin, writes digest out to
	// stdout

	{
	afxopipestream	opipe(pipefd[1]);
	POSITION	pos;
	CString	s;

		for (pos=list.GetHeadPosition(); pos; )
		{
			s=list.GetNext(pos);
			opipe << s << endl;
		}
		opipe.flush();
		if (opipe.bad())
		{
			clearsigs(EX_TEMPFAIL);
			return (EX_TEMPFAIL);
		}
	}
	close(pipefd[1]);

	while (wait(&waitstat) != p)
		;

	rc=EX_TEMPFAIL;
	if (WIFEXITED(waitstat))
		rc=WEXITSTATUS(waitstat);

	clearsigs(rc);
	if (rc)	return (rc);

	f.close();
	ifstream ff(filename_str);

	if (ff.bad())
	{
		perror(filename_str);
		return (-1);
	}

	if ( (rc=archive.save_seq_no()) != 0)
		return (rc);

	if (rename(NEXTSEQNO, SEQNO))
	{
		perror(SEQNO);
		rc=EX_TEMPFAIL;
	}

	strcpy(buf2, "bounce-");
	strcat(buf2, buf);

	post(ff, buf2);

	// Now, remove the messages that were just sent out

	{
	POSITION	pos;
	CString	s;

		for (pos=list.GetHeadPosition(); pos; )
		{
			s=list.GetNext(pos);
			unlink(s);
		}
	}
	return (0);
}

//
//  Build a list of messages to be sent out in digest form.
//
//  Returns 0 to go ahead and send it, non-zero if not enough msgs for the
//  digest.

static int mkdigest(CStringList &list, unsigned n, unsigned h)
{
DIR	*dirp;
struct	dirent *de;
struct	stat	stat_buf;
CString	s;
int	rc= -1;
time_t	age_time;
CString	dummy;

	time (&age_time);

	age_time -= h * 60 * 60;

	dirp=opendir(MODQUEUE);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

	unsigned long nn= atol(de->d_name);

		s= MODQUEUE "/";
		s += de->d_name;

		if (stat(s, &stat_buf))		continue;

		if (n == 0)	rc=0;
		else		--n;

		if (h && stat_buf.st_mtime < age_time)	rc=0;

	POSITION	pos;

		for (pos=list.GetTailPosition(); pos;
			list.GetPrev(pos))
		{
			dummy=list.GetAt(pos);

		unsigned long oo=atol(strrchr(dummy, '/')+1);

			if (oo < nn)	break;
		}

		if (pos)
			list.InsertAfter(pos, s);
		else
			list.AddHead(s);
	}
	if (dirp)	closedir(dirp);
	return (rc);
}

int cmddigest(int argc, char **argv)
{
unsigned n=0, h=0;

	if (argc)
	{
		n=atoi(*argv++);
		--argc;
	}
	if (argc)
	{
		h=atoi(*argv++);
		--argc;
	}

CStringList	msglist;

ExclusiveLock	digest_lock(DIGESTLOCKFILE);

	if (mkdigest(msglist, n, h))	return (0);

	return (senddigest(msglist));
}
