/*****************************************************************
 *
 *   xcin.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include "cpanel.h"
#include "defaults.h"

extern gchar xcin_command[STR_BUFFER_SIZE];
extern gchar xcin_im[STR_BUFFER_SIZE];

GtkWidget *entry[2];

void ok_xcin(GtkWidget *button, gpointer *data)
{
	strcpy(xcin_command,gtk_entry_get_text(GTK_ENTRY(entry[0])));
	strcpy(xcin_im,gtk_entry_get_text(GTK_ENTRY(entry[1])));
}

void def_xcin(GtkWidget *button, gpointer *data)
{
	gtk_entry_set_text(GTK_ENTRY(entry[0]),XCIN_COMMAND);
	gtk_entry_set_text(GTK_ENTRY(entry[1]),XCIN_IM);
}

void help_xcin(GtkWidget *button, gpointer *data)
{
	show_help("xcin_opt",_("Help - xcin Options"),600,300);
}

void xcin(GtkWidget *button, gpointer *data)
{
	gchar *command;

	command = g_strconcat(xcin_command," -x ",xcin_im," &",NULL);
	system(command);
}

void xcin_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0.command 1.im */
	GtkWidget *win;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;

	win = make_opt_win(_("Options - xcin"),button);

	vbox = gtk_vbox_new(FALSE,0);

	hbox = make_opt(_("Command: "),entry,0,xcin_command);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_opt(_("XIM Server Name: "),entry,1,xcin_im);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

        ok_button = gtk_button_new_with_label(_("OK"));
        gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
                        GTK_SIGNAL_FUNC(ok_xcin),NULL);

        cancel_button = gtk_button_new_with_label(_("Cancel"));

        def_button = gtk_button_new_with_label(_("Use Defaults"));
        gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
                        GTK_SIGNAL_FUNC(def_xcin),NULL);

        help_button = gtk_button_new_with_label(_("Help"));
        gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
                        GTK_SIGNAL_FUNC(help_xcin),NULL);

	/* Separator */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);

        /* Make buttons: make_button(ok,canel,def,help,win); */
        hbox = make_button(ok_button,cancel_button,def_button,help_button,
			win,button);
        gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

        /* show window */
        gtk_container_add(GTK_CONTAINER(win),vbox);
        gtk_widget_show_all(win);
}

void xcin_help(GtkWidget *button, gpointer *data) {
	show_help("xcin_README",_("Help - xcin"),700,600);
}
