#
# rpm spec-file for cryptmount
# $Revision: 213 $, $Date: 2008-07-26 07:28:58 +0100 (Sat, 26 Jul 2008) $
# Copyright 2006-2008, Holger Mueller & RW Penney
#
Summary:	Let ordinary users mount an encrypted file system
Name:		cryptmount
Version: 	3.0.1
Release:	1
License:	GPL
URL:		http://cryptmount.sourceforge.net
Group:		Applications/System
Source0:	%{name}-%{version}.tar.gz
BuildRequires:  libgcrypt-devel 
Requires:	libgcrypt device-mapper
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

%description
cryptmount is a utility for the GNU/Linux operating system which allows
an ordinary user to mount an encrypted filing system without requiring
superuser privileges. Filesystems can reside on raw disk partitions or
ordinary files, with cryptmount automatically configuring 
device-mapper and loopback devices before mounting.


%prep
%setup -n %{name}-%{version}
for mkfile in Makefile.am Makefile.in Makefile; do
  if test -f ${mkfile}; then ed -s ${mkfile} - <<EOF
/^install-exec-hook:/
/^	chown root.root/d
/^install-modules:/
/^		chown root.root/d
w
q
EOF
  fi; done


%build
%configure --enable-delegation --enable-fsck
make


%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/etc/init.d %{buildroot}/etc/default %{buildroot}/usr/sbin
make DESTDIR=%{buildroot} install
## directory structure for rc?.d scripts doesn't seem to be standardized:
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc0.d/K10cryptmount
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc3.d/S10cryptmount
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc6.d/K10cryptmount


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README README.OpenSSL RELNOTES ToDo
%attr(4751,root,root) %{_bindir}/%{name}
%attr(755,root,root) %{_sbindir}/cryptmount-setup
%attr(751,root,root) %{_sysconfdir}/cryptmount
%config %{_sysconfdir}/cryptmount/cmtab
%{_libdir}/cryptmount/*
%attr(751,root,root) %{_libdir}/cryptmount
/etc/init.d/*
%attr(0754,root,root) /etc/init.d/cryptmount
%attr(0754,root,root) /etc/init.d/cryptmount-early
/etc/default/*
%config /etc/default/cryptmount
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_mandir}/*/man5/*
%{_mandir}/*/man8/*
%{_datadir}/locale/*/LC_MESSAGES/*


%changelog
* Sun May 11 2008 RW Penney <cryptmount@rwpenney.org.uk> - 3.0
* Sun Dec 09 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.2
* Fri Jul 20 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.1
* Sat Apr 07 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.0
* Sun Oct 15 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.2
* Sun Jul 16 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.1
* Mon May 29 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.0
* Sat Apr 07 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.4
* Sun Mar 05 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.3
* Sun Jan 22 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.2
* Sun Jan 22 2006 Holger Mueller <holger@MAPS.euhm.de> - 0.1-1mr
- RPM spec created
