/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "SignSettingsDlg.hh"
#include "Common.hh"

#include <wx/dir.h>
#include <wx/regex.h>

#ifndef __WXMSW__ // en attendant
#include "pics/folder_mini.xpm"
#endif


BEGIN_EVENT_TABLE (SignSettingsDlg, CryptonitDlg)
 EVT_BUTTON (SSD_TARGETDIR_BTN_ID, SignSettingsDlg::onTarget)
 EVT_CHECKBOX(SSD_DELETE_CB_ID, SignSettingsDlg::onDelete)
 EVT_CHECKBOX(SSD_LEAVE_CB_ID, SignSettingsDlg::onLeave)
  EVT_RADIOBUTTON(SSD_ATTACHED_RADIO_ID, SignSettingsDlg::onAttached)
  EVT_RADIOBUTTON(SSD_DETACHED_RADIO_ID, SignSettingsDlg::onDetached)

END_EVENT_TABLE()

  
  SignSettingsDlg::SignSettingsDlg(wxWindow *parent, 
				   wxWindowID id,
				   Cryptonit::User* user,
				   const wxString &title)
    : CryptonitDlg(parent, id, title)
{ 
		wxString		signingDefaultFolder(std2wx(user->getInfo("Signing Profile Path")));

#ifdef __WXMSW__
		wxRegEx		regExp(_T("/"));
		const wxString	replacement(_T("\\\\"));
  regExp.ReplaceAll(&signingDefaultFolder, replacement); 
#endif
  
  attachedRadio = new wxRadioButton(this,  SSD_ATTACHED_RADIO_ID ,_("Attached"), wxDefaultPosition,wxDefaultSize);
  attachedRadio->SetToolTip( _("Cryptonit will produce a file containing both original file and its signature."));
  
  detachedRadio = new wxRadioButton(this, SSD_DETACHED_RADIO_ID ,_("Detached"),wxDefaultPosition,wxDefaultSize);
  detachedRadio->SetToolTip( _("Cryptonit will produce a file only containing the signature."));

  wxBoxSizer *settingSizer = new wxBoxSizer(wxVERTICAL);
  
  wxStaticText *detachedBox = new wxStaticText(this,-1, _("Signature type"));
  wxBoxSizer *detachedSizer = new wxBoxSizer(wxVERTICAL);
  detachedSizer->Add(detachedBox);
  
  wxStaticBox *frame = new wxStaticBox(this,-1,_("Signature settings"));
  wxStaticBoxSizer *ssSizer = new wxStaticBoxSizer(frame,wxVERTICAL);
  
  
  deleteCB = new wxCheckBox(this, SSD_DELETE_CB_ID, _("Delete signed files"));
  deleteCB->SetToolTip( _("If you check this option, original files will be deleted after signature.") );
  
  leaveCB = new wxCheckBox(this, SSD_LEAVE_CB_ID, _("Leave files at the same place"));
  leaveCB->SetToolTip( _("If you check this option, signed files will be put in the same directory than original ones.") );
  
  // target dir
  wxBoxSizer *targetSizer = new wxBoxSizer(wxHORIZONTAL);
  targetDir = new wxTextCtrl(this,-1, signingDefaultFolder.c_str(),wxDefaultPosition , wxSize(250,20));
  wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
  dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
  dirBtn = new wxBitmapButton(this,SSD_TARGETDIR_BTN_ID,dirIcon);
  targetDir->SetEditable(FALSE);

  targetSizer->Add(targetDir, 1, wxCENTER | wxALIGN_LEFT | wxALL, 5);
  targetSizer->Add(dirBtn,    0, wxCENTER | wxALL, 5);
  
  mainSizer->Add(settingSizer, 1 ,wxEXPAND |wxCENTER |wxALL,3);
  
  attachedRadio->SetValue(user->getInfo("Signing Profile Attached") == "1" ? TRUE : FALSE);
  detachedRadio->SetValue(user->getInfo("Signing Profile Detached") == "1" ? TRUE : FALSE);

  leaveCB->SetValue(user->getInfo("Signing Profile LeaveCB") == "1" ? TRUE : FALSE);
  deleteCB->SetValue(user->getInfo("Signing Profile DeleteCB") == "1" ? TRUE : FALSE);
  

  if (user->getInfo("Signing Profile Detached") == "1") {
#ifdef __WXMSW__ 
    // Gruiiiiiiiiiiiiiik land (only available on windows 32)
    detachedRadio->SetFocus();
#endif
    deleteCB->Enable(FALSE);
  }
  
  if (user->getInfo("Signing Profile LeaveCB") == "1") {
    dirBtn->Enable(FALSE);
    targetDir->Enable(FALSE);
  }
  
  detachedSizer->Add(attachedRadio, 0,wxEXPAND |wxCENTER |wxALL,3);
  detachedSizer->Add(detachedRadio, 0,wxEXPAND |wxCENTER |wxALL,3);

  ssSizer->Add(new wxStaticText( this, -1, _("Target Directory for signed files")), 0, wxALIGN_LEFT | wxTOP | wxLEFT | wxRIGHT , 5); 
  ssSizer->Add(targetSizer, 0, wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM | wxEXPAND, 5 );
  ssSizer->Add(leaveCB,     0, wxALIGN_LEFT | wxLEFT | wxRIGHT, 5 );
  ssSizer->Add(deleteCB,    0, wxALIGN_LEFT | wxALL, 5);

  settingSizer->Add(detachedSizer, 0, wxEXPAND | wxCENTER | wxALL , 3);
  settingSizer->Add(ssSizer, 0, wxEXPAND | wxCENTER | wxALL , 3);
  Center(); 
}


void SignSettingsDlg::onTarget(wxCommandEvent &WXUNUSED(event)){

  wxDirDialog dirChooser(this, _("Choose a target directory for signed files"),wxGetCwd(), wxDD_NEW_DIR_BUTTON);

  if(dirChooser.ShowModal() == wxID_OK) {

    if( wxDir::Exists(dirChooser.GetPath()) )
      targetDir->SetValue(dirChooser.GetPath());
    else {
      wxMessageDialog errorMsg(this, _("The specified directory does not exist."), _("Error"), wxOK | wxICON_ERROR);
      errorMsg.ShowModal();
      return;
    }
  }
}

void SignSettingsDlg::onLeave(wxCommandEvent &WXUNUSED(event)){
   dirBtn->Enable(!leaveCB->GetValue());
  targetDir->Enable(!leaveCB->GetValue());
}

void SignSettingsDlg::onDelete(wxCommandEvent &WXUNUSED(event)){
  attachedRadio->SetValue(TRUE);
  detachedRadio->SetValue(FALSE);
  
}


void SignSettingsDlg::onAttached(wxCommandEvent &WXUNUSED(event)){
  deleteCB->Enable(TRUE);
}


void SignSettingsDlg::onDetached(wxCommandEvent &WXUNUSED(event)){
  deleteCB->Enable(FALSE);
}


bool SignSettingsDlg::getAttached(){
    return attachedRadio->GetValue();
}


bool SignSettingsDlg::getDetached(){
    return detachedRadio->GetValue();
}

bool SignSettingsDlg::getDelete(){
    return deleteCB->GetValue();
}

bool SignSettingsDlg::getLeave(){
    return leaveCB->GetValue();
}


bool SignSettingsDlg::getEncrypted(){
    return false;
}


wxString SignSettingsDlg::getPath(){
    return targetDir->GetValue();
}
