/* $Id: Sound.h,v 1.16 2001/12/05 14:40:17 nan Exp $ */

// Copyright (C) 2000, 2001  $B?@Fn(B $B5H9((B(Kanna Yoshihiro)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _Sound_
#define _Sound_

struct buffer {
  unsigned char const *start;
  unsigned long length;
};

class Sound {
public:
  virtual ~Sound();

  static Sound* TheSound();

  virtual bool Init( long sndMode );
  virtual void Clear();

  //bool Play( char *sndData, long count );
  bool Play( long soundID );

  long GetSoundMode();

  long InitBGM( char *filename );
  long PlayBGM();
  long StopBGM();

  // For BGM
  char *m_bgmSound;

#ifdef HAVE_LIBSDL_MIXER
  Mix_Chunk *m_sound[16];
  Mix_Music *m_opening;
#endif

  long m_soundMode;
private:
  Sound();
  static Sound *m_theSound;
};

#endif // _Sound_
