
/*
 * Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: slk.m,v 1.3 2001/02/04 17:06:20 stes Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <curses.h>
#include <menu.h>
#include <Object.h>
#include <ocstring.h>
#include <ordcltn.h>
#include "slk.h"
#include "cursel.h"
#include "frame.h"
#include "menufram.h"
#include "cmdmenu.h"

int maxbutton(id c)
{
  int i,n;
  int max = 0;
  for(i=0,n=[c size];i<n;i++) {
    int b = [[c at:i] button];
    if (max < b) max = b;
  }
  return max;
}
    
int maxfunkey;
id slktab[MAXFUNKEYS+1];

id k_chg_keys,k_choices,k_save,k_prev_page,k_next_page;
id k_help,k_mark,k_enter,k_prev_frm,k_next_frm,k_cancel,k_cmd_menu;

void dobutton(BOOL alt,int button)
{
  int d;
  id a,slk;
  d = (button + ((alt)?maxfunkey:0));
  if (1 <= d && d < MAXFUNKEYS) { 
    slk = slktab[d];
    if (slk && (a=[slk action])) {
      id c;
      [slk setsiginthandler];
      c = (a)?expandstr(a):nil;
      [activeframe closeshortterm];
      [activeframe setsiginthandler];
      evalcmd(c);
      return;
    } 
  }
  beep();
}

void drawslk(BOOL alt)
{
  int i,d;
  assert(maxfunkey*2 < MAXFUNKEYS+1);
#if HAVE_COLOR
  if (has_colors()) {
    slk_color(colorpairs[CP_SLK]);
  }
#endif
  d = 1 + ((alt)?maxfunkey:0);
  for(i=0;i<maxfunkey;i++) {
    id s = slktab[i+d];
    slk_set(i+1,(s)?[s name]:"",1);
  }
  slk_noutrefresh();
}

@implementation Slk

static id NEWSLK(char *x,char *y)
{
  return [[[Slk new] name:[String str:x]] action:mkdesc(y)];
}

+ initialize
{
  k_help = NEWSLK("HELP","help");
  k_mark = NEWSLK("MARK","mark");
  k_enter = NEWSLK("ENTER","enter");
  k_prev_frm = NEWSLK("PREV-FRM","prev-frm");
  k_next_frm = NEWSLK("NEXT-FRM","next-frm");
  k_cancel = NEWSLK("CANCEL","cancel");
  k_cmd_menu = NEWSLK("CMD-MENU","cmd-menu");
  k_chg_keys = NEWSLK("CHG-KEYS","chg-keys");
  k_choices = NEWSLK("CHOICES","choices");
  k_save = NEWSLK("SAVE","save");
  k_prev_page = NEWSLK("PREVPAGE","prev-page");
  k_next_page = NEWSLK("NEXTPAGE","next-page");
  return self;
}

- action:a
{
  action=a;return self;
}

- action
{
  return action;
}

- name:a
{
  name=a;return self;
}

- (STR)name
{
  return [name str];
}

- (int)button
{
  return button;
}

- button:a
{
  assert([a isKindOf:(id)[String class]]);
  button=atoi([a str]); return self;
}

- interrupt:a
{
  interrupt=a;return self;
}

- oninterrupt:a
{
  oninterrupt=a;return self;
}

- setsiginthandler
{
  [activeframe setsiginthandler];
  if (oninterrupt) u_oninterrupt = oninterrupt;
  if (interrupt) u_interrupt = expandbool(interrupt,NO);
  return self;
}

@end
 
