/* path.h				-*- C++ -*-
   $Id: path.h,v 1.2 1996/10/30 09:37:12 elf Exp $
   
   written by Marc Singer
   27 Oct 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   -----------
   DESCRIPTION
   -----------

   Path manipulation class.  This module encapsulates most of the
   tedious pathname functions for portability and convenience.

*/

#if !defined (__PATH_H__)
#    define   __PATH_H__

/* ----- Includes */

/* ----- Globals */

/* ----- Class */

class LPath {
protected:
  char* m_sz;			// The text of the path
  int m_cchMax;			// Allocated size

public:
  LPath ()			{ init (); }
  LPath (const LPath& path)	{ init (); dup ((const char*) path); }
  LPath (const char* lpsz)		{ init (); dup (lpsz); clean (); }
  LPath (const char* sz, 
	 int cch)		{ init (); dup (sz, cch); clean (); }
  ~LPath ()                     { release (); }
  void init (void);
  void release (void);

  operator const char*() const	{ return (const char*) m_sz; }
  const LPath& operator= (const LPath& path) {
    dup (path); return *this; }
  const LPath& operator+= (const LPath& path) {
    cat (path); return *this; }
  const LPath& operator+= (const char* lpsz) {
    cat (lpsz); clean (); return *this; }

  void alloc (int cchNeed);
  void cat (const char* lpsz);
  void cat (int iVariant);
  void cat_literal (const char* sz);
  void clean (void);
  void dup (const char* sz);
  void dup (const char* sz, int cch);
  void erase (void) {
    if (m_sz) *m_sz = 0; }
  const char* extension (void);
  bool is_relative (void) const;
  inline int length (void);
  bool relative_to (const char*);
  const char* tail (void);
  void trim (void);
};

inline int LPath::length (void) {
  return (m_sz) ? strlen (m_sz) : 0; }

#endif  /* __PATH_H__ */
