/***************************************************************************
                          xpmladen.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qfile.h>
#include "cuyointl.h"
#include "fehler.h"
#include "xpmladen.h"
#include "leveldaten.h"

/* Wird in main.cpp definiert */
extern bool gDebug;


char * gDatAnfang;
char * gDatBei;
char * gDatEnde;


void leerWeg() {
  while (*gDatBei == ' ' || *gDatBei == '\t' || *gDatBei == '\n' || *gDatBei == '\r')
    gDatBei++;
}

void leerUndKommentarWeg() {
  while (1) {
    leerWeg();
    /* Kein Kommentar-Anfang? Dann fertig */
    if (gDatBei[0] != '/' || gDatBei[1] != '*')
      return;
    /* Kommentar weglesen */
    gDatBei += 2;
    while (gDatBei[0] != '*' || gDatBei[1] != '/') {
      if (!gDatBei[0])
        throw Fehler(__String("Endless comment."));
      gDatBei++;
    }
    gDatBei += 2;
  }
}

/** Erwartet, dass ein s kommt (davor ist whitespace erlaubt) */
void erwarte(char * s) {
  char *t = s;
  while (*s) {
    if (*gDatBei != *s)
      throw Fehler(__String(_("\"")) + __String(t) +
                   __String(_("\" expected")));
    gDatBei++;
    s++;
  }
}


/** Das gleiche mit char */
void erwarte(char c) {
  if (*gDatBei != c) {
    __String s;
    s.sprintf(_("'%c' expected; found: '%c' (filepos: %d)"), c, *gDatBei,
              gDatBei - gDatAnfang);
    throw Fehler(s);
  }
  gDatBei++;
}



/** Liest so lange, bis ein c auftaucht. */
void liesBis(char c) {
  while (*gDatBei != c) {
    if (*gDatBei == 0)
      throw Fehler(__String(_("'")) + __String(&c, 2) +
                   __String("' expected"));
    gDatBei++;
  }
  gDatBei++;
}


/** Prft, ob der String s jetzt kommt. Wenn ja, wird
    er weggelesen */
bool kommtString(char * s) {
  char * merk = gDatBei;
  while (*s) {
    if (*gDatBei != *s) {
      gDatBei = merk;
      return false;
    }
    gDatBei++;
    s++;
  }
  return true;
}



int getInt() {
  int ret = 0;
  bool geht = false;
  leerWeg();
  while (*gDatBei >= '0' && *gDatBei <= '9') {
    ret = ret * 10 + *gDatBei - '0';
    gDatBei++;
    geht = true;
  }
  if (!geht)
    throw Fehler(_("Number expected"));
  return ret;
}



int decodeHex1(char a) {
  if (a >= '0' && a <= '9')
    return a - '0';
  if (a >= 'A' && a <= 'F' || a >= 'a' && a <= 'f')
    return ((a - 'A') & 7) + 10;
  throw Fehler(_("Hex number expected"));
}

int getHex() {
  int ret = decodeHex1(*gDatBei++) * 16;
  return ret + decodeHex1(*gDatBei++);
}



/** Falls die eigene Lad-Routine nicht funktioniert, die
    von QT probieren. */
bool fallBackLaden(QImage & im, __String na) {
  if (gDebug)
    fprintf(stderr, _("Using (slow) QT-Routine to load \"%s\"...\n"),
            na.data());
  return im.load(na);
}


bool ladXPM(QImage & im, __String na) {

  gDatAnfang = 0;
  
  /* Das nachfolgende try-catch ist 1. um evtl Speicher freizugeben
     und zweitens um die Fehlermeldung zu verbessern. */
  try {

    QFile dat(na);
    //int c;
    int lae1, lae2;
  
    if (!dat.exists())
      return false;
      
    if (!dat.open(IO_ReadOnly))
      return false;
    
    /* Datei in Buffer lesen */
    lae1 = dat.size();
    gDatAnfang = (char *) malloc(lae1 + 1);

    gDatBei = gDatAnfang;
    gDatEnde = gDatAnfang + lae1;
    lae2 = dat.readBlock(gDatAnfang, lae1);
    if (lae1 != lae2)
      throw Fehler(_("Read Error"));
    *gDatEnde = 0;

    /* XPM-Kommentar-Zeile lesen */
    try {
      leerWeg();
      erwarte("/*");
      leerWeg();
      erwarte("XPM");
      leerWeg();
      erwarte("*/");
    } catch (Fehler f) {
      /* Wenn da nicht XPM steht, ist es vermutlich kein XPM;
         also versuchen, mit QT zu laden */
      return fallBackLaden(im, na);
    }
    /* Alles bis zur ersten { entfernen */
    liesBis('{');

    /* OK, jetzt sind wir im interessanten Bereich. */
    /* "groesse_x groesse_y farbzahl charpp" parsen. */
    leerUndKommentarWeg();
    erwarte('"');

    int groesse_x, groesse_y, farb, charpp;
    groesse_x = getInt();
    groesse_y = getInt();
    farb = getInt();
    charpp = getInt();
    if (charpp != 1)
      return fallBackLaden(im, na);
    leerWeg();
    erwarte('"');

    im.create(groesse_x, groesse_y, 32);
    im.setAlphaBuffer(true);


    /* Farben parsen */

    QRgb farben[256];
    for (int i = 0; i < farb; i++) {
      leerUndKommentarWeg();
      erwarte(',');
      leerUndKommentarWeg();
      erwarte('"');
      
      char index = *gDatBei++;
      leerWeg();
      char typ = *gDatBei++;
      ASSERT(typ == 'c');
      leerWeg();
            
      if (kommtString("None")) {
        // durchsichtig
	farben[index] = 0;
      } else if (kommtString("Background")) {
        // Farbe vom Level-Hintergrund (fr Explosion)
        farben[index] = ld->mHintergrundFarbe.rgb() | 0xff000000;
      } else {
        erwarte('#');
	int f_r = getHex();
	int f_g = getHex();
	int f_b = getHex();
	farben[index] = qRgb(f_r, f_g, f_b) | 0xff000000;
      }
      liesBis('"');
    }

    for (int y = 0; y < groesse_y; y++) {
      leerUndKommentarWeg();
      erwarte(',');
      leerUndKommentarWeg();
      erwarte('"');
      uint * p = (uint*)im.scanLine(y);
      for (int x = 0; x < groesse_x; x++) {
	*p++ = farben[*gDatBei++];
      }
      erwarte('"');
    }

    /* Angeblich drfen jetzt noch Extensionen von xpm kommen. Da kmmern wir
       uns nicht weiter drum. */

    free(gDatAnfang);

  } catch (Fehler f) {
    if (gDatAnfang) free(gDatAnfang);
    __String s;
    s.sprintf(_("Error in xpm-file \"%s\": %s"), na.data(), f.mText.data());
    throw Fehler(s);
  }
  
  
  return true;
}
