/* TableViewController.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002, 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef TableViewController_H
#define TableViewController_H

@class NSObject;
@class NSString;
@class NSNotificationCenter;

@class Playlist;
@class Song;

#ifndef TableViewController_M
extern NSString *TableDoubleClickNotification;
extern NSString *TableSelectionDidChangeNotification;
extern NSString *TableSelectionIsChangingNotification;
#endif

@interface TableViewController : NSObject
{
  Playlist *playlist;
  id _delegate;

  id playlistView;          // table view
  id scrollView;

  BOOL sortedInPlaylist;
  BOOL sortedInDuration;
}

- (id) init;

- (void) setDelegate: (id) anObject;
- (id) delegate;

- (void) selectRow: (int) row;
- (int) getFirstSelectedRow;
- (Song *) getFirstSelectedSong;
- (NSArray *) getSelectedSongs;
- (NSArray *) getSelectedSongsAsFilenames;
- (BOOL) songIsSelected: (Song *) aSong;
/* - (void) deselectAll; */

- (void) updateView;
- (void) setPlaylist: (Playlist *) aPlaylist;

@end

@interface NSObject (TableViewControllerDelegate)

- (void) tableDoubleClick: (NSNotification*) aNotification;
- (void) tableSelection: (NSNotification*) aNotification;

@end

#endif /* InfoDisplayController_H */
