// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2009 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: c85b97b03da3034db4ae95f10f9457affb7fd564 $

#ifndef RULESETS_TASKS_PROPERTY_H
#define RULESETS_TASKS_PROPERTY_H

#include "common/Property.h"

class Task;

/// \brief Class to handle whether or not an entity is solid for collisions.
/// \ingroup PropertyClasses
class TasksProperty : public PropertyBase {
  protected:
    Task ** m_task;
  public:
    /// \brief Constructor
    explicit TasksProperty();

    virtual bool get(Atlas::Message::Element & val) const;
    virtual void set(const Atlas::Message::Element & val);

    virtual void install(Entity *);
    virtual void apply(Entity *);
};

#endif // RULESETS_TASKS_PROPERTY_H
