// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2009 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: 63a96fee14232fa7aefbd468d7c3233a9bfff1aa $

#include <Python.h>

#include "rulesets/Python_API.h"

#include <cassert>

int main()
{
    init_python_api();

    assert(PyRun_SimpleString("from server import Mind") == 0);
    assert(PyRun_SimpleString("Mind()") == -1);
    assert(PyRun_SimpleString("Mind(1)") == -1);
    assert(PyRun_SimpleString("Mind('s')") == -1);
    assert(PyRun_SimpleString("m=Mind('1')") == 0);
    assert(PyRun_SimpleString("print m.as_entity()") == 0);
    assert(PyRun_SimpleString("print m.foo_operation()") == -1);
    assert(PyRun_SimpleString("print m.id") == 0);
    assert(PyRun_SimpleString("print m.type") == -1);
    assert(PyRun_SimpleString("print m.map") == 0);
    assert(PyRun_SimpleString("print m.location") == 0);
    assert(PyRun_SimpleString("print m.time") == 0);
    assert(PyRun_SimpleString("print m.contains") == 0);
    assert(PyRun_SimpleString("print m.foo") == -1);
    assert(PyRun_SimpleString("m.map=1") == -1);
    assert(PyRun_SimpleString("m.foo=1") == 0);
    assert(PyRun_SimpleString("m.foo=1.1") == 0);
    assert(PyRun_SimpleString("m.foo='1'") == 0);
    assert(PyRun_SimpleString("print m.foo") == 0);
    assert(PyRun_SimpleString("m.bar=[1]") == 0);
    assert(PyRun_SimpleString("m.baz={'foo': 1}") == 0);

    shutdown_python_api();
    return 0;
}
