/*
 * $Id: nt.h,v 1.9 2001/01/19 22:34:43 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifndef __NT_H_
#define __NT_H_

#include <gtk/gtk.h>
#include "nt_property.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum _NT_CMDS {
	PACKET_NOP=0,	//nothing to do
	PACKET_ACK,	//just return ACK
	PACKET_ADD,
	PACKET_ASK_SPEED,
	PACKET_ASK_RUN,		// amount of downloads in RUN state
	PACKET_ASK_STOP,	// amount of downloads in FAIL state
	PACKET_ASK_PAUSE,	// amount of paused downloads 
	PACKET_ASK_COMPLETE,	// amount of completed downloads
	PACKET_ASK_READED_BYTES,
	PACKET_SET_SPEED_LIMIT,
	PACKET_SET_SAVE_PATH,
	PACKET_DEL_COMPLETED,
	PACKET_SET_MAX_THREADS,
	PACKET_ICONIFY,
	PACKET_POPUP,
	PACKET_MSG,
	PACKET_ADD_OPEN,
	PACKET_ASK_FULLAMOUNT,	// amount of all downloads
	PACKET_RERUN_FAILED,
	PACKET_EXIT_TIME,
	PACKET_LS,
	PACKET_UNKNOWN
} NT_CMDS;

#define NT_TYPE            (nt_get_type ())
#define NT_(obj)           (GTK_CHECK_CAST ((obj), NT_TYPE, NT))
#define NT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), NT_TYPE, NTClass))
#define IS_NT(obj)         (GTK_CHECK_TYPE ((obj), NT_TYPE))
#define IS_NT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), NT_TYPE))

#define NT_GET_CLASS(obj)  (NT_CLASS (NT_ (obj)->base.klass))
#define NT_GET_TYPE(obj)   (GTK_OBJECT_TYPE (obj))

typedef struct _NT NT;
typedef struct _NTClass NTClass;

struct _NT {
	GtkObject base;

	guint update_id;

	guint update_download_id;
	GList *download_list;

	gchar lock_file[PATH_MAX];
};

struct _NTClass {
	GtkObjectClass base_class;
};

GtkType nt_get_type (void);

GtkObject *nt_new (void);

void nt_open_window  (NT *nt);
void nt_download_uri (NT *nt, gchar *file_name, NT_CMDS cmd);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __NT_H */
