/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: dacs_api.h 2528 2011-09-23 21:54:05Z brachman $
 */

#ifndef _DACS_API_H_
#define _DACS_API_H_

#include "dacs.h"

#ifndef DEFAULT_FEDERATION_DOMAIN
#define DEFAULT_FEDERATION_DOMAIN		"EXAMPLE.COM"
#endif

#ifndef DEFAULT_PORT_NUMBER
#define DEFAULT_PORT_NUMBER			"80"
#endif

#ifndef DEFAULT_HTTPS_PORT_NUMBER
#define DEFAULT_HTTPS_PORT_NUMBER	"443"
#endif

typedef struct Simple_user {
  char *user;
  char *groups;
  char *attrs;
  char *ip_addr;
  char *expires;
} Simple_user;

enum {
  TRANSFORM_MAX_STACK_DEPTH = 100
};

typedef enum {
  D_NONE    = 0,
  D_BEGIN   = 1,
  D_COMMENT = 2,
  D_DEBUG   = 3,
  D_END     = 4,
  D_ERROR   = 5,
  D_EVAL    = 6,
  D_EXPAND  = 7,
  D_FILTER  = 8,
  D_FILTERV = 9,
  D_ID      = 10,
  D_INSERT  = 11,
  D_INSERTV = 12,
  D_SET     = 13
} Transform_directive;

typedef struct Transform_stack {
  Transform_directive directive;	/* Directive for this element */
  char *region;						/* Region name */
  int skipping;						/* Region contents are being discarded */
  int expanding;					/* Region contents are being expanded */
  char *expr;						/* The expr attribute value, if any */
  Ds *diverted;						/* Content for filter input or */
  									/* filter expression or NULL */
  Var_ns *var_context;
  Kwv *saved_attrs;
  struct Transform_stack *prev;		/* Preceding stack element */
} Transform_stack;

typedef struct Transform_config {
  Ds *ds_in;
  Ds *ds_out;
  int linenum;
  int stack_depth;
  int max_stack_depth;
  Transform_stack *stackp;
  char *acls;
  char *docs;
  char *insert_dir;
  char *directive_prefix;
  char *directive_suffix;
  char *annotation;
  char *regex_prefix;
  char *regex_suffix;
  Kwv *global_attrs;
  Acs_environment *env;
} Transform_config;

#ifdef __cplusplus
extern "C" {
#endif

extern int set_federation(Kwv *kwv_conf, Kwv *kwv_dacs,
						  char *name, char *domain);
extern int set_jurisdiction(Kwv *kwv_conf, Kwv *kwv_dacs, char *name);
extern int add_vfs_uri(Kwv *kwv_conf, char *vfs_uri);
extern int parse_ident_string(char *str, Simple_user *suser);
extern int compare_idents(char *ident1, char *ident2, Kwv *kwv_conf);

extern int get_conf(char **host);
extern int set_conf_from_host(Kwv *kwv_conf, Kwv *kwv_dacs, char *host);
extern int get_conf_from_host(char *host, char **hname, char **fname,
							  char **jname, char **fdomain);
extern int check_object_access(char *rules, char *groups, char *idents,
							   char *object, Kwv *kwv_conf, Kwv *kwv_dacs,
							   Acs_result *result, char **constraint);
extern int check_access(char *rules, char *groups, char *idents, char *objects,
						Kwv *kwv_conf, Kwv *kwv_dacs,
						Acs_result *result, char ***constraints);
extern char *make_ident(char *user, char *groups, char *attrs,
						time_t expires_secs, char *ip_addr);
extern char *make_ident_from_credentials(Credentials *cr);
extern char *make_idents_from_credentials(Credentials *credentials);

extern Acs_environment *init_env(char *object, Kwv *kwv_conf, Kwv *kwv_dacs);
extern int set_ident_config(int *argcp, char **argv, Kwv *kwv_dacs,
							Kwv *kwv_conf, char **identsp, char **errmsg);

extern Credentials *make_credentials_from_ident(char *ident,
												Auth_style auth_style,
												Kwv *kwv_conf);
extern Dsvec *make_credentials_from_idents(char *str, Auth_style auth_style,
										   Kwv *kwv_conf);

extern int transform(Transform_config *tc, char *object_name, char *idents,
					 char **errmsg);
extern Ds *transform_simple_file(char *path, Kwv *kwv, char **errmsg);
extern Ds *transform_simple_fp(FILE *fp, Kwv *kwv, char **errmsg);
extern Ds *transform_simple_str(char *input, Kwv *kwv, char **errmsg);
extern Transform_config *transform_init(Transform_config *otc);

#ifdef __cplusplus
}
#endif

#endif
