#ifndef __HPP_ICAPSCAN
#define __HPP_ICAPSCAN

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  written by m4d.
//

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/un.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "VirusEngine.hpp"
#include "OptionContainer.hpp"


using namespace std;



/* maximum length of buffer */
#define BUFLEN 8196
#define MAXLINE 1024
#define CLRF "\r\n"

/* the ICAP RESPMOD header "template" */
#define ICAP_HEADER_S1	"RESPMOD"
#define ICAP_HEADER_S2	"ICAP/1.0\r\nAllow: 204\r\nEncapsulated:"

/* the ICAP encapsulated header "template" */
#define ENC_HEADER_S	"HTTP/1.1 200 OK\r\nContent-Type: application/octet-stream\r\nContent-Length:"



// experimental implementation of the VirusEngine api for icap servers
//
class ICAPEngine:public VirusEngine
{
private:
  string err_str;
  string vname;                 // extra virus name field, in case we manually need to set one
  // (e.g. forked scanning needs this; child->parent data handover)

  int dconnect ();
  void dclose (int _sockfd);
  void parseVirusName (const char *_line);

public:
    ICAPEngine ();
    virtual ~ ICAPEngine ();

  virtual int loadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int reloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }
  virtual int unloadEngine ()
  {                             /* nothing to do here */
    return 0;
  }

  virtual int scanFile (const char *_fname);

  virtual const char *getVirusName ()
  {
    return vname.c_str ();
  }
  virtual const char *getErrString ()
  {
    return err_str.c_str ();
  }

  virtual void setVirusName (const char *_vname)
  {
    vname = _vname;
  }
  virtual void setErrString (const char *_err_str)
  {
    err_str = _err_str;
  }
};

#endif
