//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Nerijus Baliunas
//  adapted by mad@madness.at
//

#include "KAV.hpp"

extern OptionContainer o;


KAVEngine::KAVEngine ()
{
}

KAVEngine::~KAVEngine ()
{
}


int
KAVEngine::scanFile (const char *filename)
{
  int isinfected = 0;

  kav_ctx ctx = kav_new ();
  kav_set_timeout (ctx, o.virus_scanner_timeout);

  if (kav_check_file (ctx, filename) == -1)
    {
      int kav_error;
      kav_error = kav_get_error (ctx);

#ifdef DGDEBUG
      cout << kav_strerror (kav_error) << " (" << kav_error << ")";
      if (errno != 0)
        cout << ": (" << strerror (errno) << ")\n";
      else
        cout << "\n";
#endif
      setErrString (kav_strerror (kav_error));
      isinfected = AV_FAIL;
    }
  else
    {
      isinfected = kav_result_get_status (ctx);
      virname = kav_result_get_report (ctx);

      if (isinfected == KAV_STATUS_CLEAN || isinfected == KAV_STATUS_CORRUPTED_FOUND)
        isinfected = AV_CLEAN;
      else
        isinfected = AV_VIRUS;
    }
  return isinfected;
}
