%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\begin{code}
module TheCommands ( command_control_list ) where

import DarcsCommands ( CommandControl(Command_data,Group_name) )
import Init ( initialize )
import Add ( add )
import Remove ( remove )
import WhatsNew ( whatsnew )
import Record ( record )
import Unrecord ( unrecord, unpull, obliterate )
import Check ( check )
import Revert ( revert )
import Get ( get )
import Pull ( pull )
import Dist ( dist )
import Mv ( mv )
import Replace ( replace )
import Tag ( tag )
import Push ( push )
import Send ( send )
import Apply ( apply )
import DiffCommand
import SetPref ( setpref )
import Changes ( changes )
import Unrevert ( unrevert )
import TrackDown ( trackdown )
import Optimize ( optimize )
import Rollback ( rollback )
import AmendRecord ( amendrecord )
import Annotate ( annotate )
import Query ( query )
import Repair ( repair )
import Resolve ( resolve )
import Put ( put )

command_control_list :: [CommandControl]
command_control_list = [Group_name "Changing and querying the working copy:",
                Command_data add,
                Command_data remove,
                Command_data mv,
                Command_data replace,
                Command_data revert,
                Command_data unrevert,
                Command_data whatsnew,
                Group_name "Copying changes between the working copy and the repository:",
                Command_data record,
                Command_data unrecord,
                Command_data amendrecord,
                Command_data resolve,
                Group_name "Direct modification of the repository:",
                Command_data tag,
                Command_data setpref,
                Command_data rollback,
                Group_name "Querying the repository:",
                Command_data diff_command,
                Command_data changes,
                Command_data annotate,
                Command_data dist,
                Command_data trackdown,
                Command_data query,
                Group_name "Copying patches between repositories with working copy update:",
                Command_data pull,
                Command_data unpull,
                Command_data obliterate,
                Command_data push,
                Command_data send,
                Command_data apply,
                Command_data get,
                Command_data put,
                Group_name "Administrating repositories:",
                Command_data initialize,
                Command_data optimize,
                Command_data check,
                Command_data repair]

\end{code}
