## darcs.spec is autogenerated from darcs.spec.in in the darcs
## distribution edit darcs.spec.in if you want to make long term
## changes


Name:           darcs
Version:        2.0.2
Release:        1%{?dist}
Summary:        David's advanced revision control system

Group:          Development/Tools
License:        GPLv2+
URL:            http://www.darcs.net/
Source0:        http://www.darcs.net/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  ghc, %{_sbindir}/sendmail, curl-devel, ncurses-devel, zlib-devel
# for make check
BuildRequires:  which
# need chcon
Requires(post): coreutils

# http://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=246051
ExcludeArch:    ppc64 

%description
Darcs is a revision control system, along the lines of CVS
or arch. That means that it keeps track of various revisions
and branches of your project, allows for changes to
propagate from one branch to another. Darcs is intended to
be an ``advanced'' revision control system. Darcs has two
particularly distinctive features which differ from other
revision control systems: 1) each copy of the source is a
fully functional branch, and 2) underlying darcs is a
consistent and powerful theory of patches.


%package server
Summary: David's advanced revision control system Server
Group: Development/Tools
Requires: webserver

%description server
Darcs is a revision control system, along the lines of CVS
or arch. That means that it keeps track of various revisions
and branches of your project, allows for changes to
propagate from one branch to another. Darcs is intended to
be an ``advanced'' revision control system. Darcs has two
particularly distinctive features which differ from other
revision control systems: 1) each copy of the source is a
fully functional branch, and 2) underlying darcs is a
consistent and powerful theory of patches.

This package contains the darcs cgi server program.


%prep
%setup -q -n %{name}-%{version}
# skip test currently failing in buildsystem
mv tests/send.sh{,-disabled}


%build
%configure --libexecdir=%{_localstatedir}/www
make all

%check
make check


%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT installbin installserver

cp tools/darcs_completion bash_completion
rm -r %buildroot%{_sysconfdir}/bash_completion.d


%clean
rm -rf $RPM_BUILD_ROOT


%post
semanage fcontext -a -t unconfined_execmem_exec_t %{_bindir}/darcs >/dev/null 2>&1 || :
restorecon -v %{_bindir}/darcs


%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog doc/manual bash_completion tools/zsh_completion_*
%{_bindir}/darcs
%{_mandir}/man1/*


%files server
%defattr(-,root,root,-)
%{_localstatedir}/www/cgi-bin
%config(noreplace) %{_sysconfdir}/darcs
%{_datadir}/darcs


%changelog
* Mon Jun 16 2008  Michael De La Rue <gneqbgqnepfqbgarg.yeuhc@spamgourmet.com> - 2.0.0-1
- update to version 2.0.0
- remove build of index.html which is already built

* Fri Sep 21 2007 Jens Petersen <petersen@redhat.com> - 1.0.9-6
- fix the "|| :" quoting in the post install script (#295351)

* Thu Sep 20 2007 Jens Petersen <petersen@redhat.com> - 1.0.9-5
- set selinux file-context for %{_bindir}/darcs
  (reported by Jim Radford, #295351)

* Fri Aug 10 2007 Jens Petersen <petersen@redhat.com> - 1.0.9-4
- specify license is GPL 2 or later

* Wed Jun 27 2007 Jeremy Hinegardner <jeremy@hinegardner.org> - 1.0.9-3
- clean rpmlint warnings/errors 
  - move PreReq to Requires(post)
  - move make check to 'check' section
  - mark config files as such

* Wed Jun 27 2007 Jeremy Hinegardner <jeremy@hinegardner.org> - 1.0.9-2
- added ExcludeArch: ppc64

* Wed Jun 27 2007 Jeremy Hinegardner <jeremy@hinegardner.org> - 1.0.9-1
- update to 1.0.9

* Mon Feb 19 2007 Jens Petersen <petersen@redhat.com> - 1.0.9-0.1.rc2
- update to 1.0.9rc2 which builds with ghc66

* Fri Feb  2 2007 Jens Petersen <petersen@redhat.com> - 1.0.8-5
- rebuild for ncurses replacing termcap (#226754)

* Wed Nov  1 2006 Jens Petersen <petersen@redhat.com> - 1.0.8-4
- rebuild for new libcurl

* Thu Sep 28 2006 Jens Petersen <petersen@redhat.com> - 1.0.8-3
- rebuild for FC6
- enable make check

* Fri Jun 23 2006 Jens Petersen <petersen@redhat.com> - 1.0.8-2
- set unconfined_execmem_exec_t context to allow running under selinux targeted
  policy (#195820)

* Wed Jun 21 2006 Jens Petersen <petersen@redhat.com> - 1.0.8-1
- update to 1.0.8

* Sun May 14 2006 Jens Petersen <petersen@redhat.com> - 1.0.7-1
- update to 1.0.7
- fix typo of propagate in description (#189651)
- disable "make check" for now since it blows up in buildsystem

* Thu Mar  2 2006 Jens Petersen <petersen@redhat.com> - 1.0.6-1
- update to 1.0.6
  - darcs-createrepo is gone

* Thu Dec  8 2005 Jens Petersen <petersen@redhat.com> - 1.0.5-1
- 1.0.5 bugfix release

* Mon Nov 14 2005 Jens Petersen <petersen@redhat.com> - 1.0.4-1
- 1.0.4 release
  - skip tests/send.sh for now since it is failing in buildsystem

* Tue Jul  5 2005 Jens Petersen <petersen@redhat.com>
- drop superfluous doc buildrequires (Karanbir Singh, #162436)

* Fri Jul  1 2005 Jens Petersen <petersen@redhat.com> - 1.0.3-2
- fix buildrequires
  - add sendmail, curl-devel, ncurses-devel, zlib-devel, and
    tetex-latex, tetex-dvips, latex2html for doc generation

* Tue May 31 2005 Jens Petersen <petersen@redhat.com> - 1.0.3-1
- initial import into Fedora Extras
- 1.0.3 release
- include bash completion file in doc dir

* Sun May  8 2005 Jens Petersen <petersen@haskell.org> - 1.0.3-0.rc1.1
- 1.0.3rc1
  - build with ghc-6.4

* Wed Feb  8 2005 Jens Petersen <petersen@haskell.org> - 1.0.2-1
- update to 1.0.2

* Thu Jul 15 2004 Jens Petersen <petersen@haskell.org> - 0.9.22-1
- 0.9.22
- darcs-0.9.21-css-symlinks.patch no longer needed

* Thu Jun 24 2004 Jens Petersen <petersen@haskell.org> - 0.9.21-1
- update to 0.9.21
- replace darcs-0.9.13-mk-include.patch with darcs-0.9.21-css-symlinks.patch

* Wed Nov  5 2003 Jens Petersen <petersen@haskell.org>
- Initial packaging.
