/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedIntVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected int[] m_map0;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int n) {
        this.m_blocksize = n;
        this.m_map0 = new int[n];
        this.m_map = new int[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedIntVector(int n, int n2) {
        this(n);
    }

    public void addElement(int n) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = n;
        } else {
            int[] nArray;
            int n2 = this.m_firstFree / this.m_blocksize;
            int n3 = this.m_firstFree % this.m_blocksize;
            if (n2 >= this.m_map.length) {
                int n4 = n2 + this.m_numblocks;
                int[][] nArray2 = new int[n4][];
                System.arraycopy(this.m_map, 0, nArray2, 0, this.m_map.length);
                this.m_map = nArray2;
            }
            if ((nArray = this.m_map[n2]) == null) {
                this.m_map[n2] = new int[this.m_blocksize];
                nArray = this.m_map[n2];
            }
            nArray[n3] = n;
            ++this.m_firstFree;
        }
    }

    private void addElements(int n) {
        int n2 = this.m_firstFree + n;
        if (n2 > this.m_blocksize) {
            int n3 = this.m_firstFree % this.m_blocksize;
            int n4 = (this.m_firstFree + n) % this.m_blocksize;
            int n5 = n3 + 1;
            while (n5 <= n4) {
                this.m_map[n5] = new int[this.m_blocksize];
                ++n5;
            }
        }
        this.m_firstFree = n2;
    }

    private void addElements(int n, int n2) {
        if (this.m_firstFree + n2 < this.m_blocksize) {
            int n3 = 0;
            while (n3 < n2) {
                this.m_map0[this.m_firstFree++] = n;
                ++n3;
            }
        } else {
            int n4 = this.m_firstFree / this.m_blocksize;
            int n5 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n2;
            while (n2 > 0) {
                int[] nArray;
                if (n4 >= this.m_map.length) {
                    int n6 = n4 + this.m_numblocks;
                    int[][] nArray2 = new int[n6][];
                    System.arraycopy(this.m_map, 0, nArray2, 0, this.m_map.length);
                    this.m_map = nArray2;
                }
                if ((nArray = this.m_map[n4]) == null) {
                    this.m_map[n4] = new int[this.m_blocksize];
                    nArray = this.m_map[n4];
                }
                int n7 = this.m_blocksize - n5 < n2 ? this.m_blocksize - n5 : n2;
                n2 -= n7;
                while (n7-- > 0) {
                    nArray[n5++] = n;
                }
                ++n4;
                n5 = 0;
            }
        }
    }

    private boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public int elementAt(int n) {
        if (n < this.m_blocksize) {
            return this.m_map0[n];
        }
        return this.m_map[n / this.m_blocksize][n % this.m_blocksize];
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3;
        int[] nArray;
        if (n2 >= this.m_firstFree) {
            return -1;
        }
        int n4 = n2 / this.m_blocksize;
        int n5 = n2 % this.m_blocksize;
        int n6 = this.m_firstFree / this.m_blocksize;
        while (n4 < n6) {
            nArray = this.m_map[n4];
            if (nArray != null) {
                n3 = n5;
                while (n3 < this.m_blocksize) {
                    if (nArray[n3] == n) {
                        return n3 + n4 * this.m_blocksize;
                    }
                    ++n3;
                }
            }
            n5 = 0;
            ++n4;
        }
        n3 = this.m_firstFree % this.m_blocksize;
        nArray = this.m_map[n6];
        int n7 = n5;
        while (n7 < n3) {
            if (nArray[n7] == n) {
                return n7 + n6 * this.m_blocksize;
            }
            ++n7;
        }
        return -1;
    }

    private void insertElementAt(int n, int n2) {
        if (n2 == this.m_firstFree) {
            this.addElement(n);
        } else if (n2 > this.m_firstFree) {
            int[] nArray;
            int n3 = n2 / this.m_blocksize;
            if (n3 >= this.m_map.length) {
                int n4 = n3 + this.m_numblocks;
                int[][] nArray2 = new int[n4][];
                System.arraycopy(this.m_map, 0, nArray2, 0, this.m_map.length);
                this.m_map = nArray2;
            }
            if ((nArray = this.m_map[n3]) == null) {
                this.m_map[n3] = new int[this.m_blocksize];
                nArray = this.m_map[n3];
            }
            int n5 = n2 % this.m_blocksize;
            nArray[n5] = n;
            this.m_firstFree = n5 + 1;
        } else {
            int n6 = n2 / this.m_blocksize;
            int n7 = this.m_firstFree / this.m_blocksize;
            ++this.m_firstFree;
            int n8 = n2 % this.m_blocksize;
            while (n6 <= n7) {
                int n9;
                int n10 = this.m_blocksize - n8 - 1;
                int[] nArray = this.m_map[n6];
                if (nArray == null) {
                    n9 = 0;
                    this.m_map[n6] = new int[this.m_blocksize];
                    nArray = this.m_map[n6];
                } else {
                    n9 = nArray[this.m_blocksize - 1];
                    System.arraycopy(nArray, n8, nArray, n8 + 1, n10);
                }
                nArray[n8] = n;
                n = n9;
                n8 = 0;
                ++n6;
            }
        }
    }

    private int lastIndexOf(int n) {
        int n2 = this.m_firstFree % this.m_blocksize;
        int n3 = this.m_firstFree / this.m_blocksize;
        while (n3 >= 0) {
            int[] nArray = this.m_map[n3];
            if (nArray != null) {
                int n4 = n2;
                while (n4 >= 0) {
                    if (nArray[n4] == n) {
                        return n4 + n3 * this.m_blocksize;
                    }
                    --n4;
                }
            }
            n2 = 0;
            --n3;
        }
        return -1;
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(int n) {
        int n2 = this.indexOf(n, 0);
        if (n2 < 0) {
            return false;
        }
        this.removeElementAt(n2);
        return true;
    }

    private void removeElementAt(int n) {
        if (n < this.m_firstFree) {
            int n2 = n / this.m_blocksize;
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = n % this.m_blocksize;
            while (n2 <= n3) {
                int n5 = this.m_blocksize - n4 - 1;
                int[] nArray = this.m_map[n2];
                if (nArray == null) {
                    this.m_map[n2] = new int[this.m_blocksize];
                    nArray = this.m_map[n2];
                } else {
                    System.arraycopy(nArray, n4 + 1, nArray, n4, n5);
                }
                if (n2 < n3) {
                    int[] nArray2 = this.m_map[n2 + 1];
                    if (nArray2 != null) {
                        nArray[this.m_blocksize - 1] = nArray2 != null ? nArray2[0] : 0;
                    }
                } else {
                    nArray[this.m_blocksize - 1] = 0;
                }
                n4 = 0;
                ++n2;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int n, int n2) {
        if (n2 < this.m_blocksize) {
            this.m_map0[n2] = n;
        } else {
            int[] nArray;
            int n3 = n2 / this.m_blocksize;
            int n4 = n2 % this.m_blocksize;
            if (n3 >= this.m_map.length) {
                int n5 = n3 + this.m_numblocks;
                int[][] nArray2 = new int[n5][];
                System.arraycopy(this.m_map, 0, nArray2, 0, this.m_map.length);
                this.m_map = nArray2;
            }
            if ((nArray = this.m_map[n3]) == null) {
                this.m_map[n3] = new int[this.m_blocksize];
                nArray = this.m_map[n3];
            }
            nArray[n4] = n;
        }
        if (n2 >= this.m_firstFree) {
            this.m_firstFree = n2 + 1;
        }
    }

    private void setSize(int n) {
        if (this.m_firstFree < n) {
            this.m_firstFree = n;
        }
    }

    public int size() {
        return this.m_firstFree;
    }
}

