<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
 <xsl:variable name="IconDir">../../../../Icons</xsl:variable>
  <xsl:include href="DashboardConfig.xsl"/>
  <!--
	Set the output method to html.  This style sheet outputs both html
	and possibly base64 files.  The html output method is incorrect for
	the base64 files but it does not seem to impact the conversions.
	If the output method is xml, then a standard xml header is created and
	we cannot decode the base64 file. 
	-->	
  <xsl:output method="html"/> 

  <!-- Index the file so that we can check whether two tests have the same name
    -->
  <xsl:key name="TestNames" match="/Site/Testing/TestList/Test" use="."/>
  <xsl:variable name="TestNames" select="/Site/Testing/TestList/Test[count(.|key('TestNames', .)[1]) = 1]"/>
  <xsl:variable name="NumberOfUniqueTests" select="count($TestNames)"/>
  <xsl:variable name="NumberOfTests" select="count(/Site/Testing/TestList/Test)"/>

  <xsl:template match="/">
    
    <xsl:call-template name="Summary"/>
    <xsl:call-template name="TestByStatus"/>
    <xsl:call-template name="TestByTime"/>
    <xsl:call-template name="TestByName"/>

    <xsl:for-each select="//Testing/Test">
      <xsl:call-template name="Test"/>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="TestByStatus">

    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Test Log <xsl:value-of select="/Site/@Name"/> -- <xsl:value-of select="/Site/@BuildName"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>
    <h2>Testing started on <xsl:value-of select="Site/Testing/StartDateTime"/></h2>
    <p>
      <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
    </p>
    <p>
      <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
    </p>
    <br/>
    <h3>
      <xsl:value-of select="count(Site/Testing/Test[@Status='passed'])"/> passed, 
      <xsl:value-of select="count(Site/Testing/Test[@Status='failed'])"/> failed,
      <xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/> not run 
      <xsl:if test="$NumberOfTests != $NumberOfUniqueTests">, <xsl:value-of select="$NumberOfTests - $NumberOfUniqueTests"/> duplicate tests</xsl:if>
    </h3>
    <br/>
    <table cellspacing="0">
      <tr>
        <th>Name (<a href="TestByName.html">sort by</a>)</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Status <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Time (<a href="TestByTime.html">sort by</a>)<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th>Detail</th>
      </tr>
      <xsl:for-each select="Site/Testing/Test">
        <xsl:sort select="@Status='notrun'" order="descending"/>
        <xsl:sort select="@Status='failed'" order="descending"/>
        <xsl:sort select="@Status='passed' and count(key('TestNames', FullName))!=1" order="descending"/>
        <xsl:sort select="@Status='passed' and count(key('TestNames', FullName))=1" order="descending"/>
        <xsl:sort select="Name" order="ascending"/>

        <xsl:call-template name="TestRow"/>

      </xsl:for-each>
    </table>
    
    <xsl:call-template name="DashboardFooter">
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="TestByTime">
    <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/TestByTime.html' )"/>
    <xsl:result-document href="{$uri}">

    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Test Log <xsl:value-of select="/Site/@Name"/> -- <xsl:value-of select="/Site/@BuildName"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>
    <h2>Testing started on <xsl:value-of select="Site/Testing/StartDateTime"/></h2>
    <p>
      <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
    </p>
    <p>
      <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
    </p>
    <br/>
    <h3>
      <xsl:value-of select="count(Site/Testing/Test[@Status='passed'])"/> passed, 
      <xsl:value-of select="count(Site/Testing/Test[@Status='failed'])"/> failed,
      <xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/> not run
      <xsl:if test="$NumberOfTests != $NumberOfUniqueTests">, <xsl:value-of select="$NumberOfTests - $NumberOfUniqueTests"/> duplicate tests</xsl:if>
    </h3>
    <br/>
    <table cellspacing="0">
      <tr>
        <th>Name (<a href="TestByName.html">sort by</a>)</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Status (<a href="Test.html">sort by</a>)<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Time <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th>Detail</th>
      </tr>
      <xsl:for-each select="Site/Testing/Test">
        <xsl:sort select="Results/NamedMeasurement[@name='Execution Time']/Value" order="descending" data-type="{'number'}"/>
        <xsl:sort select="Name" order="ascending"/>

        <xsl:call-template name="TestRow"/>

      </xsl:for-each>
    </table>
    
    <xsl:call-template name="DashboardFooter">
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

    </xsl:result-document>
  </xsl:template>

  <xsl:template name="TestByName">
    <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/TestByName.html' )"/>
    <xsl:result-document href="{$uri}">

    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Test Log <xsl:value-of select="/Site/@Name"/> -- <xsl:value-of select="/Site/@BuildName"/></xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>
    <h2>Testing started on <xsl:value-of select="Site/Testing/StartDateTime"/></h2>
    <p>
      <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
    </p>
    <p>
      <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
    </p>
    <br/>
    <h3>
      <xsl:value-of select="count(Site/Testing/Test[@Status='passed'])"/> passed, 
      <xsl:value-of select="count(Site/Testing/Test[@Status='failed'])"/> failed,
      <xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/> not run
      <xsl:if test="$NumberOfTests != $NumberOfUniqueTests">, <xsl:value-of select="$NumberOfTests - $NumberOfUniqueTests"/> duplicate tests</xsl:if>
    </h3>
    <br/>
    <table cellspacing="0">
      <tr>
        <th>Name <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Status (<a href="Test.html">sort by</a>)<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>Time (<a href="TestByTime.html">sort by</a>)<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text></th>
        <th>Detail</th>
      </tr>
      <xsl:for-each select="Site/Testing/Test">
        <xsl:sort select="Name" order="ascending"/>

        <xsl:call-template name="TestRow"/>

      </xsl:for-each>
    </table>
    
    <xsl:call-template name="DashboardFooter">
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

    </xsl:result-document>
  </xsl:template>
 
  <xsl:template name="TestRow">
    <xsl:choose>
        <xsl:when test="@Status='notrun'">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:value-of select="Name"/>
            </a>
          </td>
          <td align="center">
            <xsl:attribute name="class">error</xsl:attribute>
            Not Run
          </td>
          <td></td>
          <td></td>
         </tr>
        </xsl:when>
        <xsl:when test="@Status='failed'">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute><xsl:value-of select="Name"/>
            </a>
          </td>
          <td align="center">
            <xsl:attribute name="class">warning</xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Results/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
                Failed
            </a>
          </td>
          <td align="right">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
            <xsl:value-of select="Results/NamedMeasurement[@name='Execution Time']"/>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
          <td align="center">
            <xsl:choose>
               <xsl:when test="Results/NamedMeasurement[@name='Completion Status'] = 'Timeout'">
                   Timeout
               </xsl:when>
               <xsl:when test="Results/NamedMeasurement[@name='Exit Code']">
                <xsl:value-of select="Results/NamedMeasurement[@name='Exit Code']"/>
               </xsl:when>
            </xsl:choose>
          </td>
         </tr>
        </xsl:when>
        <xsl:when test="@Status='passed' and count(key('TestNames', FullName))!=1">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute><xsl:value-of select="Name"/>
            </a>
          </td>
          <td align="center">
            <xsl:attribute name="class">warning</xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Results/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
                Duplicate 
            </a>
          </td>
          <td align="right">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
            <xsl:value-of select="Results/NamedMeasurement[@name='Execution Time']"/>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
          <td align="center">
            <xsl:choose>
               <xsl:when test="Results/NamedMeasurement[@name='Completion Status'] = 'Timeout'">
                   Timeout
               </xsl:when>
               <xsl:when test="Results/NamedMeasurement[@name='Exit Code']">
                <xsl:value-of select="Results/NamedMeasurement[@name='Exit Code']"/>
               </xsl:when>
            </xsl:choose>
          </td>
         </tr>
        </xsl:when>
        <xsl:when test="@Status='passed' and count(key('TestNames', FullName))=1">
         <tr>
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">tr-even</xsl:attribute>
          </xsl:if>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix"><xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:value-of select="Name"/>
            </a>
          </td>
          <td  align="center">
            <xsl:attribute name="class">pass</xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Results/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
                Passed
            </a>
          </td>
          <td align="right">
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
            <xsl:value-of select="Results/NamedMeasurement[@name='Execution Time']"/>
            <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
          </td>
          <td></td>
         </tr>
        </xsl:when>
      </xsl:choose>
  </xsl:template>
    
  <xsl:template name="Test">
    <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/Results/', translate ( FullName, '/.', '__' ) , '.html' )"/>
      <xsl:result-document href="{$uri}">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Test results for <xsl:value-of select="Name"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir">../<xsl:value-of select="$DashboardDir"/></xsl:with-param>
      </xsl:call-template>
      <p>
        <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
      </p>
      <p>
        <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
      </p>
      <a>
        <xsl:attribute name="href">
          <xsl:call-template name="TranslateTestName">
            <xsl:with-param name="Prefix">../<xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
            <xsl:with-param name="TestName" select="FullName"/>
            <xsl:with-param name="Postfix">.html</xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
        <xsl:value-of select="Name"/> 
      </a>
      <xsl:choose>
        <xsl:when test="count(key('TestNames', FullName))!=1">
          <font>
            <xsl:attribute name="color"><xsl:value-of select="$WarningColor"/></xsl:attribute>
            Duplicate test name
          </font>
        </xsl:when>
        <xsl:when test="contains('failed',@Status)">
          <font>
            <xsl:attribute name="color"><xsl:value-of select="$WarningColor"/></xsl:attribute>
            Failed
          </font>
        </xsl:when>
        <xsl:when test="contains('passed',@Status)">
          <font>
            <xsl:attribute name="color"><xsl:value-of select="$NormalColor"/></xsl:attribute>
            Passed
          </font>
        </xsl:when>
      </xsl:choose>
	
      <br/><br/><br/>
      <table>
        <xsl:for-each select="Results/NamedMeasurement">
	  <xsl:sort select="@type"/>
	  <xsl:sort select="@name"/>
          <xsl:call-template name="NamedMeasurements"/>
        </xsl:for-each>
      </table>
      <br/><br/><br/>
      <b>Test output</b>
      <pre>
        <xsl:value-of select="Results/Measurement/Value" disable-output-escaping="yes"/>
      </pre>
      <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
      </xsl:call-template>
    </xsl:result-document>
  </xsl:template>
    
<xsl:template name="NamedMeasurements">
   <tr>
     <th><xsl:attribute name="class">measurement</xsl:attribute><xsl:value-of select="@name"/></th>
     <td>
       <xsl:choose>
	  <xsl:when test="contains(@type,'numeric') or contains(@type,'text/string')">
	     <xsl:value-of select="Value"/>
	  </xsl:when>

	  <xsl:when test="contains(@type,'link/url')">
	     <a><xsl:attribute name="href"><xsl:value-of select="Value"/></xsl:attribute><xsl:value-of select="Value"/></a>
	  </xsl:when>

	  <xsl:when test="contains(@type,'link/image')">
	     <img><xsl:attribute name="src"><xsl:value-of select="Value"/></xsl:attribute><xsl:value-of select="Value"/></img>
	  </xsl:when>

	  <xsl:when test="contains(@type,'image/png') and contains(@encoding,'base64')">
            <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/Results/', translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.png.base64' )"/>
             <xsl:result-document href="{$uri}">
  	       <xsl:value-of select="Value"/>
	     </xsl:result-document>
	     <img><xsl:attribute name="src"><xsl:value-of select="concat(translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.png' )"/></xsl:attribute></img>
	  </xsl:when>
	  <xsl:when test="contains(@type,'image/jpeg') and contains(@encoding,'base64')">
            <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/Results/', translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.jpg.base64' )" />
             <xsl:result-document href="{$uri}">
  	       <xsl:value-of select="Value"/>
	     </xsl:result-document>
	     <img><xsl:attribute name="src"><xsl:value-of select="concat(translate ( ../../FullName, '/.', '__' ) , translate(@name, '/. ', '___') , '.jpg' )"/></xsl:attribute></img>
	  </xsl:when>
       </xsl:choose>	
     </td>
   </tr>
</xsl:template>

<xsl:template name="Summary">
  <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/TestSummary.xml')"/>
  <xsl:result-document href="{$uri}">
    <xsl:variable name="DuplicateTests" select="$NumberOfTests - $NumberOfUniqueTests"/>
    <Testing>
      <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
      <StartDateTime><xsl:value-of select="Site/Testing/StartDateTime"/></StartDateTime>
      
      <PassedCount><xsl:value-of select="count(Site/Testing/Test[@Status='passed']) - $DuplicateTests"/></PassedCount>
      <FailedCount><xsl:value-of select="count(Site/Testing/Test[@Status='failed']) + $DuplicateTests"/></FailedCount>
      <NotRunCount><xsl:value-of select="count(Site/Testing/Test[@Status='notrun'])"/></NotRunCount>
      <EndDateTime><xsl:value-of select="Site/Testing/EndDateTime"/></EndDateTime>
      <ElapsedMinutes><xsl:value-of select="Site/Testing/ElapsedMinutes"/></ElapsedMinutes>
      <Generator><xsl:value-of select="Site/@Generator"/></Generator>
      <Tests>
        <xsl:for-each select="Site/Testing/Test">
            <Test>
              <FullName><xsl:value-of select="FullName"/></FullName>
              <xsl:choose>
              <xsl:when test="count(key('TestNames', FullName))=1">
                <Status><xsl:value-of select="@Status"/></Status>
                <xsl:if test="Results/NamedMeasurement[@name='Completion Status']">
                  <CompletionStatus><xsl:value-of select="Results/NamedMeasurement[@name='Completion Status']"/></CompletionStatus>
                </xsl:if>
                <xsl:if test="Results/NamedMeasurement[@name='Exit Code']">
                  <ExitCode><xsl:value-of select="Results/NamedMeasurement[@name='Exit Code']"/></ExitCode>
                </xsl:if>
                <xsl:if test="Results/NamedMeasurement[@name='Execution Time']">
                  <ExecutionTime><xsl:value-of select="Results/NamedMeasurement[@name='Execution Time']"/></ExecutionTime>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <Status>Failed</Status>
                <CompletionStatus>Duplicate test name</CompletionStatus>
              </xsl:otherwise>
            </xsl:choose>
            </Test>
        </xsl:for-each>
      </Tests>
    </Testing>
  </xsl:result-document>
</xsl:template>

</xsl:stylesheet>
  
