/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class CascadedDeleteReaddTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Item
		{
			public Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item _child1;

			public Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item _child2;

			public string _name;

			public Item()
			{
			}

			public Item(string name)
			{
				_name = name;
			}

			public Item(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item
				 child1, Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item 
				child2, string name)
			{
				_child1 = child1;
				_child2 = child2;
				_name = name;
			}
		}

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase().RunSoloAndClientServer
				();
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			base.Configure(config);
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				).ObjectField("_child1").CascadeOnDelete(true);
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				).ObjectField("_child2").CascadeOnDelete(true);
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				).ObjectField("_child1").CascadeOnUpdate(true);
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				).ObjectField("_child2").CascadeOnUpdate(true);
		}

		protected override void Store()
		{
			Store(new Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item(
				new Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item("1"), 
				null, "parent"));
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item item = ParentItem
				();
			item._child2 = item._child1;
			item._child1 = null;
			Store(item);
			Db().Delete(item);
			AssertItemCount(0);
		}

		private Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item ParentItem
			()
		{
			Db4objects.Db4o.Query.IQuery q = Db().Query();
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				);
			q.Descend("_name").Constrain("parent");
			return (Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)q.
				Execute().Next();
		}

		private void AssertItemCount(int count)
		{
			Db4objects.Db4o.Query.IQuery q = Db().Query();
			q.Constrain(typeof(Db4objects.Db4o.Tests.Common.Assorted.CascadedDeleteReaddTestCase.Item)
				);
			Db4objects.Db4o.IObjectSet objectSet = q.Execute();
			Db4oUnit.Assert.AreEqual(count, objectSet.Size());
		}
	}
}
