/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System.IO;
using System.IO.IsolatedStorage;
using Db4objects.Db4o;
using Db4objects.Db4o.IO;
using Db4objects.Db4o.Internal;

namespace Db4objects.Db4odoc.IsolatedStorage
{
    /// <summary>IO adapter for isolated storage files.</summary>
    /// <remarks>IO adapter for isolated storage files.</remarks>
    public class IsolatedStorageFileAdapter : IoAdapter
    {
        private string _path;

        private Db4oIsolatedStorageFile _delegate;

        public IsolatedStorageFileAdapter()
        {
        }
        
        protected IsolatedStorageFileAdapter(string path, bool lockFile, long initialLength)
        {
            bool ok = false;
            try
            {
                _path = path;
                _delegate = new Db4oIsolatedStorageFile(_path, "rw");
                if (initialLength > 0)
                {
                    _delegate.Seek(initialLength - 1);
                    _delegate.Write(new byte[] { 0 });
                }
                ok = true;
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
            finally
            {
                if (!ok)
                {
                    Close();
                }
            }
        }
        // end IsolatedStorageFileAdapter

        public override void Close()
        {
            try
            {
                if (_delegate != null)
                {
                    _delegate.Close();
                }
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end Close

        public override void Delete(string path)
        {
            IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForAssembly();
            isf.DeleteFile(path);
        }
        // end Delete

        public override bool Exists(string path)
        {
            IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForAssembly();
            bool res = isf.GetFileNames(path).Length > 0;
            return res;
        }
        // end Exists

        public override long GetLength()
        {
            try
            {
                return _delegate.Length();
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end GetLength

        public override IoAdapter Open(string path, bool lockFile, long initialLength)
        {
            return new IsolatedStorageFileAdapter(path, lockFile, initialLength
                );
        }
        // end Open

        public override int Read(byte[] bytes, int length)
        {
            try
            {
                return _delegate.Read(bytes, 0, length);
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end Read

        public override void Seek(long pos)
        {
            try
            {
                _delegate.Seek(pos);
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end Seek

        public override void Sync()
        {
            try
            {
                _delegate.GetFD().Sync();
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end Sync

        public override void Write(byte[] buffer, int length)
        {
            try
            {
                _delegate.Write(buffer, 0, length);
            }
            catch (IOException e)
            {
                throw new Db4oIOException(e);
            }
        }
        // end Write
    }
}
