/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.IO;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Tests.Common.Backup;

namespace Db4objects.Db4o.Tests.Common.Backup
{
	public abstract class MemoryBackupTestCaseBase : ITestCase
	{
		public class Item
		{
			public int _id;

			public Item(int id)
			{
				_id = id;
			}
		}

		private static readonly string DbPath = "database";

		private const int NumItems = 10;

		private static readonly string BackupPath = "backup";

		/// <exception cref="System.Exception"></exception>
		public virtual void TestMemoryBackup()
		{
			LocalObjectContainer origDb = (LocalObjectContainer)Db4oFactory.OpenFile(Config(OrigStorage
				()), DbPath);
			Store(origDb);
			string backupPath = BackupPath;
			Backup(origDb, backupPath);
			origDb.Close();
			IObjectContainer backupDb = Db4oFactory.OpenFile(Config(BackupStorage()), backupPath
				);
			IObjectSet result = backupDb.Query(typeof(MemoryBackupTestCaseBase.Item));
			Assert.AreEqual(NumItems, result.Size());
			backupDb.Close();
		}

		protected abstract void Backup(LocalObjectContainer origDb, string backupPath);

		protected abstract IoAdapter BackupStorage();

		protected abstract IoAdapter OrigStorage();

		private void Store(LocalObjectContainer origDb)
		{
			for (int itemId = 0; itemId < NumItems; itemId++)
			{
				origDb.Store(new MemoryBackupTestCaseBase.Item(itemId));
			}
			origDb.Commit();
		}

		private IConfiguration Config(IoAdapter storage)
		{
			IConfiguration origConfig = Db4oFactory.NewConfiguration();
			origConfig.Io(storage);
			return origConfig;
		}
	}
}
