#include <unistd.h>
#include <string>
#include <memory>
#include <iostream>
#include <ace/Task.h>
#include <ace/Method_Object.h>
#include <ace/Activation_Queue.h>
#include <ace/Synch.h>

class DBThreadWorkerGuard {
public:
  DBThreadWorkerGuard(ACE_Atomic_Op<ACE_Thread_Mutex,int> &thread_number):_thread_number(thread_number) {
    ++_thread_number;
    //ACE_DEBUG((LM_NOTICE,"Guard++ = %d \n",_thread_number.value()));
  };
  ~DBThreadWorkerGuard(void) { 
    --_thread_number; 
    //ACE_DEBUG((LM_NOTICE,"Guard-- = %d \n",_thread_number.value()));
  };
protected:
  ACE_Atomic_Op<ACE_Thread_Mutex,int> & _thread_number;
};


class DBThreadWorker: public ACE_Task<ACE_MT_SYNCH> {

public:

  DBThreadWorker(string name, int nthreads);
  ~DBThreadWorker();

  // ACE_Task
  void open(int nthreads);
  void shutdown();
  int svc(void);

  // Used by the thread pool
  void submit(ACE_Method_Object *t);
  inline int getQueueSize() { return activation_queue_.method_count(); }
  inline int getThreads() { return _nthreads.value(); }
  inline string getName() { return _name; }

private:

  bool _open;
  string _name;
  ACE_Atomic_Op<ACE_Thread_Mutex,int> _nthreads;
  ACE_Activation_Queue activation_queue_;

};
