% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbReadTable}
\alias{dbReadTable}
\alias{dbWriteTable}
\title{Copy data frames to and from database tables.}
\usage{
dbReadTable(conn, name, ...)

dbWriteTable(conn, name, value, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}

\item{value}{a data.frame (or coercible to data.frame).}
}
\value{
a data.frame.
}
\description{
\code{dbReadTable}: database table -> data frame; \code{dbWriteTable}:
data frame -> database table.
}
\note{
The translation of identifiers between R and SQL is done through calls
  to \code{\link{make.names}} and \code{\link{make.db.names}}, but we cannot
  guarantee that the conversion is reversible.  For details see
  \code{\link{make.db.names}}.
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars[1:10, ])
dbReadTable(con, "mtcars")

dbDisconnect(con)
}
}
\seealso{
Other connection methods: \code{\link{dbDisconnect}};
  \code{\link{dbExistsTable}};
  \code{\link{dbGetException}}; \code{\link{dbGetQuery}},
  \code{\link{dbGetQuery,DBIConnection,character-method}};
  \code{\link{dbListFields}}; \code{\link{dbListResults}};
  \code{\link{dbListTables}}; \code{\link{dbRemoveTable}};
  \code{\link{dbSendQuery}}
}

