/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * find_result_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: find_result_clist.c,v 1.6 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "find_result_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "misc.h"
#include "global_user.h"

/************************************************************/
/* ListStore used to keep the copy of the find_result store */
/* It has the same format but is not sorted                 */
/************************************************************/
static GtkListStore *find_result_copy=NULL;

/****************************************************************************************/
/* this function calls the given fnc for each selected entry of the "find_result" clist */
/****************************************************************************************/
void generic_selected_find_result_calls(GtkTreeSelectionForeachFunc fnc, void *data)
{
	GtkWidget *w;
	GtkTreeSelection *slc;

	w=get_widget_by_widget_name(main_window,"find_result");
	if(w==NULL)
		return;

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(w));
	gtk_tree_selection_selected_foreach(slc,fnc,data);
}

/********************************************************/
/* handle special column sorting for find_result column */
/********************************************************/
static gint frc_sort(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
	gint sort_col=GPOINTER_TO_INT(user_data);

	switch(sort_col)
	{
		case FRC_SIZE_COL:	
									{
										gulong va,vb;
										gtk_tree_model_get(model,a,FRC_SIZE_AS_VAL,&va,-1);
										gtk_tree_model_get(model,b,FRC_SIZE_AS_VAL,&vb,-1);

										if(va<vb)
											return -1;
										if(va==vb)
											return 0;
										return 1;
		}
	}
	return 0;
}


static void colorized_find_result_clist_on_size(GtkTreeModel *gtm, GtkListStore *gls)
{
	int valid;
	int color_idx=0;
	static char *color_list[]={NULL,"grey87","grey94"};
	GtkTreeIter iter;
	gulong old_size;

	valid=gtk_tree_model_get_iter_first(gtm,&iter);
	if(valid)
	{
		gtk_tree_model_get(gtm,&iter,FRC_SIZE_AS_VAL,&old_size,-1);
		gtk_list_store_set(gls,&iter,FRC_LINE_BACKGROUND,color_list[color_idx],-1);
		valid=gtk_tree_model_iter_next(gtm,&iter);
		while(valid)
		{
			gulong size;
			gtk_tree_model_get(gtm,&iter,FRC_SIZE_AS_VAL,&size,-1);
			if(old_size!=size)
			{ /* size has changed, so swap */
				old_size=size;
				color_idx=(color_idx+1)%3;
			}
			
			gtk_list_store_set(gls,&iter,FRC_LINE_BACKGROUND,color_list[color_idx],-1);
			valid=gtk_tree_model_iter_next(gtm,&iter);
		}
	}
}


/********************************************************/
/* this function is called when the sort column changed */
/********************************************************/
static void frc_new_sort_col(GtkTreeViewColumn *gtvc, gpointer user_data)
{
	GtkWidget *w;
	int sort_col=GPOINTER_TO_INT(user_data);
	GtkTreeModel *gtm;
	GtkListStore *gls;

	w=get_widget_by_widget_name(main_window,"find_result");
	if(w==NULL)
		return;

	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));
	if(sort_col==FRC_SIZE_COL)
	{
		colorized_find_result_clist_on_size(gtm,gls);
	}
	else
	{
		int valid;
		GtkTreeIter iter;
		valid=gtk_tree_model_get_iter_first(gtm,&iter);
		while(valid)
		{
			gtk_list_store_set(gls,&iter,FRC_LINE_BACKGROUND,NULL,-1);
			valid=gtk_tree_model_iter_next(gtm,&iter);
		}
	}
}

/************************************************/
/* update user information using GLOB_USER data */
/************************************************/
static void find_clist_user_info_update_row(GtkTreeModel *gtm, GtkTreePath *gtp, GtkTreeIter *gti, gpointer user_data)
{
	GLOB_USER *gu;

	/* get GLOB_USER entry to use */
	gtk_tree_model_get(gtm,gti,FRC_USER_POINTER,&gu,-1);

	/* block the update signal on this function */
	g_signal_handlers_block_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,find_clist_user_info_update_row,NULL);

	/* update user info */
	gtk_list_store_set(GTK_LIST_STORE(gtm),gti,
												FRC_NICK_COL,gu->fmt_nick,
												FRC_SPEED_COL,gu->cnx_type,
												FRC_LINE_FOREGROUND,gu->front_color,
			/* we don't set the background color else it may conflict with size sorting color */
												-1);

	/* unblock the update signal on this function */
	g_signal_handlers_unblock_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,find_clist_user_info_update_row,NULL);
}

/***************************************************/
/* build modele and view for the find result clist */
/***************************************************/
void bmav4_find_result_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_FRC_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_ULONG,G_TYPE_INT,G_TYPE_INT,
													G_TYPE_STRING, G_TYPE_POINTER);
	g_signal_connect_after(G_OBJECT(model),"row-changed",G_CALLBACK(find_clist_user_info_update_row),NULL);


	/* use to keep a copy of the previous store. It has the same format */
	find_result_copy=gtk_list_store_new(NB_FRC_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_ULONG,G_TYPE_INT,G_TYPE_INT,
													G_TYPE_STRING, G_TYPE_POINTER);
	g_signal_connect_after(G_OBJECT(model),"row-changed",G_CALLBACK(find_clist_user_info_update_row),NULL);

	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(model),FRC_SIZE_COL,frc_sort,GINT_TO_POINTER(FRC_SIZE_COL),NULL);

	view=get_widget_by_widget_name(main_window,"find_result");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_NICK_COL,_("Nick"),rend,"text",FRC_NICK_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_FULL_PATH_COL,_("Filename"),rend,"text",FRC_FULL_PATH_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_SIZE_COL,_("Size"),rend,"text",FRC_SIZE_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_SLOT_COL,_("Slot"),rend,"text",FRC_SLOT_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_SPEED_COL,_("Spd"),rend,"text",FRC_SPEED_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_CK_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),frc_new_sort_col,FRC_HUBNAME_COL,_("Hubname"),rend,"text",FRC_HUBNAME_COL,"background",FRC_LINE_BACKGROUND,"foreground",FRC_LINE_FOREGROUND,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

static void my_gtk_list_store_copy(GtkListStore *source, GtkListStore *dest)
{
	GtkTreeIter iter;
	GtkTreeIter n_iter;
	gboolean valid;
	int i;
	GtkTreeModel *dest_gtm;

	GtkTreeModel *gtm;

	gtm=GTK_TREE_MODEL(source);
	dest_gtm=GTK_TREE_MODEL(dest);

	gu_unref_model(dest_gtm);
	gtk_list_store_clear(dest);

	valid=gtk_tree_model_get_iter_first(gtm,&iter);
	while(valid)
	{
		gchar *str[6];
		gulong ul;
		gint in[2];
		GLOB_USER *gu;

		gtk_tree_model_get(gtm,&iter,
										 FRC_FULL_PATH_COL,&str[0],
										 FRC_SIZE_COL,&str[1],
										 FRC_SLOT_COL,&str[2],
										 FRC_SPEED_COL,&str[3],
										 FRC_HUBNAME_COL,&str[4],
										 FRC_SIZE_AS_VAL,&ul,
										 FRC_FREE_SLOT,&in[0],
										 FRC_TTL_SLOT,&in[1],
										 FRC_FULL_PATH,&str[5],
										 FRC_USER_POINTER,&gu,
										-1);

		/* create the new row */
		gtk_list_store_append(dest,&n_iter);

		/* and register it */
		gu_ref_from_iter(gu,dest_gtm,&n_iter);

		gtk_list_store_set(dest,&n_iter,
										 FRC_FULL_PATH_COL,str[0],
										 FRC_SIZE_COL,str[1],
										 FRC_SLOT_COL,str[2],
										 FRC_SPEED_COL,str[3],
										 FRC_HUBNAME_COL,str[4],
										 FRC_SIZE_AS_VAL,ul,
										 FRC_FREE_SLOT,in[0],
										 FRC_TTL_SLOT,in[1],
										 FRC_FULL_PATH,str[5],
										 FRC_USER_POINTER,gu,
										-1);

		for(i=0;i<6;i++)
			g_free(str[i]);

		valid=gtk_tree_model_iter_next(gtm,&iter);
	}
}

/*************************************************/
/* copy the find_result list store into its copy */
/*************************************************/
void copy_find_result_store_into_the_copy(void)
{
	my_gtk_list_store_copy(GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(get_widget_by_widget_name(main_window,"find_result")))),find_result_copy);
}

/***************************************************************/
/* copy the copy of find_result list store into the list store */
/***************************************************************/
void copy_the_copy_into_find_result_store(void)
{
	gint sort_col;
	GtkSortType gst;
	GtkTreeModel *gtm;
	GtkListStore *gls;

	my_gtk_list_store_copy(find_result_copy,gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(get_widget_by_widget_name(main_window,"find_result")))));

	if(gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(gtm),&sort_col,&gst)==TRUE)
	{
		if(sort_col==FRC_SIZE_COL)
		{
			colorized_find_result_clist_on_size(gtm,gls);
		}
	}
}

/*****************************************************************************************/
/* check if the file size of the given row of the find_result store is below a given one */
/*****************************************************************************************/
/* input: param= (const gulong *) size to compare                    */
/* output: TRUE= criteria ok, FALSE= criteria not ok (row to delete) */
/*********************************************************************/
static gboolean filter_size_below(GtkTreeModel *gtm, GtkTreeIter *iter, const void *param)
{
	gulong fsize;
	gtk_tree_model_get(gtm,iter, FRC_SIZE_AS_VAL,&fsize,
										-1);

	return fsize < (*((const gulong*)param));
}

/*****************************************************************************************/
/* check if the file size of the given row of the find_result store is above a given one */
/*****************************************************************************************/
/* input: param= (const gulong *) size to compare                    */
/* output: TRUE= criteria ok, FALSE= criteria not ok (row to delete) */
/*********************************************************************/
static gboolean filter_size_above(GtkTreeModel *gtm, GtkTreeIter *iter, const void *param)
{
	gulong fsize;
	gtk_tree_model_get(gtm,iter, FRC_SIZE_AS_VAL,&fsize,
										-1);

	return fsize > (*((const gulong*)param));
}

/********************************************************************************************/
/* check if the file name of the given row of the find_result store contains a given string */
/********************************************************************************************/
/* input: param= (const GString *) size to compare                      */
/* output: TRUE= criteria ok, FALSE= criteria not ok (row to delete) */
/*********************************************************************/
static gboolean filter_fname_with(GtkTreeModel *gtm, GtkTreeIter *iter, const void *param)
{
	char *utf_fname;
	gboolean out;
	gtk_tree_model_get(gtm,iter, FRC_FULL_PATH_COL,&utf_fname,
										-1);

	out=(my_strcasestr((GString *)param,utf_fname)!=NULL)? TRUE:FALSE;
	free(utf_fname);
	return out;
}

/********************************************************************************************/
/* check if the file name of the given row of the find_result store contains a given string */
/********************************************************************************************/
/* input: param= (const char *) size to compare                      */
/* output: TRUE= criteria ok, FALSE= criteria not ok (row to delete) */
/*********************************************************************/
static gboolean filter_fname_without(GtkTreeModel *gtm, GtkTreeIter *iter, const void *param)
{
	char *utf_fname;
	gboolean out;
	gtk_tree_model_get(gtm,iter, FRC_FULL_PATH_COL,&utf_fname,
										-1);

	out=(my_strcasestr((GString *)param,utf_fname)==NULL)? TRUE:FALSE;
	free(utf_fname);
	return out;
}

static gboolean (*filter_fnc[])(GtkTreeModel *gtm, GtkTreeIter *iter, const void *param)=
			{
				filter_size_below,			/* param= const gulong * 	*/
				filter_size_above,			/* param= const gulong * 	*/
				filter_fname_with,			/* param= const char * 		*/
				filter_fname_without			/* param= const char * 		*/
			};

/*************************************/
/* filter the find_result list store */
/*************************************/ 
void filter_find_result_store(FILTER_ID fi, const void *param)
{
	GtkWidget *w;
	GtkTreeView *gtv;
	GtkTreeModel *gtm;
	GtkListStore *gls;
	GtkTreeIter iter;
	int i;
	int updated=FALSE;

	w=get_widget_by_widget_name(main_window,"find_result");
	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(gtv=GTK_TREE_VIEW(w)));

	i=gtk_tree_model_iter_n_children(gtm,NULL)-1;
	while(i>=0)
	{
		if(gtk_tree_model_iter_nth_child(gtm,&iter,NULL,i)==TRUE)
		{
			if(((filter_fnc[fi])(gtm,&iter,param))==FALSE)
			{
				GLOB_USER *gu;

				gtk_tree_model_get(gtm,&iter,FRC_USER_POINTER,&gu,-1);
				gu_unref_from_iter(gu,gtm,&iter);
				gtk_list_store_remove(gls,&iter);
				updated=TRUE;
			}
			i--;
		}
		else
		{
			fprintf(stderr,"filter_find_result_store: idx too big\n");
			break;
		}
	}

	if(updated)
	{
		gint sort_col;
		GtkSortType gst;

		if(gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(gtm),&sort_col,&gst)==TRUE)
		{
			if(sort_col==FRC_SIZE_COL)
			{
				colorized_find_result_clist_on_size(gtm,gls);
			}
		}
	}
}

