/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_define.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_define.h,v 1.16 2003/12/30 09:00:18 ericprev Exp $
*/

#ifndef __GUI_DEFINE_H__
#define __GUI_DEFINE_H__

/*
 meaning of () values:

wo => write only. This value should never been read to perform task. There is
      always another column in the same model containing the "unformatted"
      version. For numeric "unformatted" value, this column probably contains
      a "locale" formatted one. For string "unformatted" value, this column
      is the UTF-8 version (required to be displayed correctly).
		This column is displayed in a view.
org => read/write value. It is the value as it was received from the client
      (it is an "unformatted" value).  This column is NOT displayed in a view.
*/

/* list of all tabs of main_notebook */
enum
{
	CONNECT_TAB=0,
	CHAT_TAB,
	FIND_TAB,
	FIND_CONFIG_TAB,
	USER_FILE_LIST_TAB,
	USER_PREFERENCES_TAB,
	GUI_PREFERENCES_TAB,
	UADDR_TAB,
	FLAGGED_USER_TAB,
};

#if 0
#define PRIVATE_CHAT_TAB CHAT_TAB
#endif

/* list of all tabs of xfer_notebook */
enum
{
	XFER_GDL_TAB=0,
	XFER_UATGDL_TAB,
	XFER_UL_TAB,
	XFER_Q_TAB,
	XFER_DONE_TAB,
	XFER_DL_TAB,
	XFER_ERRMSG_TAB,
	XFER_BITTORRENT_TAB,
};

/* list of all tabs of connect_notebook */
enum
{
	RUNNING_HUB_TAB=0,
	FAVORITE_HUB_TAB,
	PUBLIC_HUB_TAB,
	RECENT_HUB_TAB,
	SEEN_PUBLIC_HUB_TAB,
}; 

/* list of all tabs of user_pref_notebook */
enum
{
	IDENTITY_TAB=0,
	SHARES_TAB,
	MISC_EXTRA_PARAM_TAB,
	EXTRA_PARAM_DL_TAB,
	EXTRA_PARAM_GDL_TAB,
	EXTRA_PARAM_UL_TAB,
	TYPE_OF_SERV_TAB,
};

/* list of all tabs of gui_pref_notebook */
enum
{
	HUBLIST_TAB=0,
	MISC2_EXTRA_PARAM_TAB,
	SOUND_EVENT_PARAM_TAB,
	FLAGGED_USERS_TAB,
	BITTORRENT_TAB,
};

/* list of all columns of the "user_file_list_clist" */
/* UTF8: ok */
enum
{
	UFLC_TREE_COL=0,		/* char* (wo) */
	UFLC_SIZE_COL,			/* char* (wo) */
	UFLC_SIZE_RIGHT_ALIGN,/* gfloat: this column is only in the model, it forces right alignment */
	UFLC_TYPE,				/* guint (org):this column is only in the model, it is the type of entry NICK_ROOT,DIR_ENTRY,FILE_ENTRY */
	UFLC_STR,				/* char* (org): if type==NICK_ROOT, it is the nick, if type==DIR_ENTRY, it is the dirname, if type=FILE_ENTRY, it is the filename */
	UFLC_SIZE_AS_VAL,		/* gulong (org): it is the unformatted value of UFLC_SIZE_COL (only meaningful for FILE_ENTRY) */
	NB_UFLC_COL
};

/* list of all column of the "find_result" clist */
/* UTF8: ok */
enum
{
	FRC_NICK_COL=0,		/* char* (wo) */
	FRC_FULL_PATH_COL,	/* char* (wo) */
	FRC_SIZE_COL,			/* char* (wo) */
	FRC_SLOT_COL,			/* char* (wo) : it is the ratio FRC_FREE_SLOT/FRC_TTL_SLOT */
	FRC_SPEED_COL,			/* char* (wo) */
	FRC_HUBNAME_COL,		/* char* (wo) */
	FRC_LINE_BACKGROUND,	/* char*: this column is only in the model, it is the background color of the line */
	FRC_LINE_FOREGROUND,	/* char*: this column is only in the model, it is the foreground color of the line */
	FRC_SIZE_AS_VAL,		/* gulong: it is the unformatted value of FRC_SIZE_COL */
	FRC_FREE_SLOT,			/* gint: this column is only in the model, it is the number of free slots */
	FRC_TTL_SLOT,			/* gint: this column is only in the model, it is the numver of slots */
#if 0
	FRC_CNX_SPD,			/* char *: this column is only in the model, it is the connection speed (as in user list) */
	FRC_NICK,				/* char *: unformatted value of FRC_NICK_COL */
#endif
	FRC_FULL_PATH,			/* char *: unformatted value of FRC_FULL_PATH_COL */
	FRC_USER_POINTER,		/* GLOB_USER *: pointer on the user of this row */
	NB_FRC_COL
};

/* List of all column of the "user_clist" treeview */
/* UTF8: ok */
enum
{
	UCC_TVC_TYPE_COL=0,		/* only in the TreeViewColumn, no entry in the liststore */
	UCC_TVC_NICK_COL,			/* only in the TreeViewColumn, no entry in the liststore */
	UCC_TVC_SIZE_COL,			/* only in the TreeViewColumn, no entry in the liststore */
	UCC_TVC_EMAIL_COL,		/* only in the TreeViewColumn, no entry in the liststore */
	UCC_TVC_DESCRIPTION_COL,/* only in the TreeViewColumn, no entry in the liststore */
	NB_UCC_TVC_COL
};

/* List of all columns of the "user_clist" list store */
enum
{
	UCC_LST_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER structure assigned to this user */
	NB_UCC_LST_COL
};

/* List of all column of the "gdl_ctree" ctree */
/* NOTE: the GDL_CT_ENTRY is mapped on GtkTreeModel */
/*       It is quite unreadable to map an union on a tree model */
/*       you can find a more readable version of the fields in gdl_ctree.h */
/* UTF8: ok */
enum
{
	GCC_GID_NICK_COL=0,	/* char * (wo) */
	GCC_GID_NICK_VISI,	/* (gboolean): if TRUE, the previous value is displayed */
	GCC_GID_NICK_NOT_VISI,/* (gboolean): NOT the previous value */
	GCC_FULL_PATH_COL,	/* char * (wo) */
	GCC_PIXBUF,				/* (GdkPixbuf*) ROOT: a 100x18 pixbuf */
								/*              others: NULL */
	GCC_SIZE_COL,			/* char * (wo) */
	GCC_STATUS_COL,		/* char * (wo) */
	GCC_SIZE_RIGHT_ALIGN,/* gfloat: this column is only in the model, it forces right alignment */
	GCC_LINE_BACKGROUND,	/* char *: background color of the line */
	GCC_LINE_FOREGROUND,	/* char *: foreground color of the line */
	GCC_TYPE,				/* (guint) it is the type of the row (GDL_CT_TYPE) */
	GCC_ID,					/* (gulong) ROOT: gdl_id 
												SEARCH_PATTERN: autoscan_id */
	GCC_STR1,				/* (char*)	ROOT: local_filename
												SEARCH_PATTERN: search_pattern
#if 0
												ACTIVE_SEGMENT: nickname
#endif
												STORED_SEGMENT: stored_filename
												RENAME_AT_END: filename_directory
												SCRIPT_AT_END: script_to_start */
	GCC_VAL1,				/* (gulong) ROOT: gdl_size
												SEARCH_PATTERN: autoscan_type
												ACTIVE_SEGMENT: remote_file_size */
	GCC_STR2,				/* (char*)	ACTIVE_SEGMENT: remote_filename 
												STORED_SEGMENT: stored_interval
												RENAME_AT_END: final_filename */
	GCC_STR3,				/* (char*)	ACTIVE_SEGMENT: status */
	GCC_BYTE_OFFSET,		/* (gulong) ROOT: byte_offset */
	GCC_RECEIVED_BYTES,	/* (gulong) ROOT: received_bytes */
	GCC_START_TIME,		/* (guint64) ROOT: start_time */
	GCC_LAST_10S_SPD,		/* (gulong) ROOT: last_10sec_speed */
	GCC_MISC_POINTER,		/* (gpointer) ACTIVE_SEGMENT: GLOB_USER of the user on this row */

	GCC_PIXBUF_DIRTY,		/* (gboolean) ROOT: FALSE= GCC_PIXBUF is correct, TRUE= it must be rebuilt */
	NB_GCC_COL
};

/* list of all column of the "download_clist" clist */
/* UTF8: ok */
enum
{
	DLC_NICK_COL=0,		/* char * (wo) */
	DLC_SIZE_COL,			/* char * (wo) */
	DLC_SPEED_COL,			/* char * (wo) */
	DLC_FNAME_COL,			/* char * (wo) */
	DLC_LFNAME_COL,		/* char * (wo) */
	DLC_ID_COL,				/* gulong: xfer ID */
	DLC_SIZE_RIGHT_ALIGN,/* gfloat: this column is only in the model, it forces right alignment */
	DLC_LINE_BACKGROUND,	/* char *: background color of the line */
	DLC_LINE_FOREGROUND,	/* char *: foreground color of the line */
	DLC_SIZE_AS_VAL,		/* gulong: unformated value of ULC_SIZE_COL */
	DLC_HAS_START_INFO,	/* gboolean: if TRUE, the 2 following values are set */
	DLC_START_TIME,		/* gulong: start time (it is a time_t value stored in a G_TYPE_ULONG) */
	DLC_START_POS,			/* gulong: start position */
	DLC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER structure of this user */
	NB_DLC_COL
};

/* list of all column of the "upload_clist" clist */
/* UTF8: ok */
enum
{
	ULC_NICK_COL=0,		/* char * (wo) */
	ULC_SIZE_COL,			/* char * (wo) */
	ULC_SPEED_COL,			/* char * (wo) */
	ULC_FNAME_COL,			/* char * (wo) */
	ULC_ID_COL,				/* gulong: xfer ID */
	ULC_SIZE_RIGHT_ALIGN,/* gfloat: this column is only in the model, it forces right alignment */
	ULC_LINE_BACKGROUND,	/* char *: background color of the line */
	ULC_LINE_FOREGROUND,	/* char *: foreground color of the line */
	ULC_SIZE_AS_VAL,		/* gulong: unformated value of ULC_SIZE_COL */
	ULC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER structure of this user */
	NB_ULC_COL
	
};

#if 0
/* list of all column of the "done_clist" clist */
/* UTF8: ok */
enum
{
	DOC_FNAME_COL=0,		/* char * (wo) */
	DOC_END_TIME,			/* char * (wo) */
	DOC_SIZE_COL,			/* char * (wo) */
	DOC_LFNAME_COL,		/* char * (wo) */
	DOC_SIZE_AS_VAL,		/* gulong: unformatted value of DOC_SIZE_COL */
	DOC_END_TIME_AS_VAL,	/* gulong: unformatted value of DOC_END_TIME */
	NB_DOC_COL
};
#endif

/* list of all column of the "cached_user_list_clist" clist */
/* UTF8: ok */
enum
{
	CULC_NICK_COL=0,			/* char* (wo): nickname: UTF-8 string */
	CULC_SIZE_COL,				/* char* (wo): share size: can be in locale format */
	CULC_DATE_COL,				/* char* (wo): date: in human readable format */
	CULC_LINE_BACKGROUND,	/* char *: background color of the line */
	CULC_LINE_FOREGROUND,	/* char *: foreground color of the line */
	CULC_SIZE_AS_VAL,			/* guint64: unformatted value of CULC_SIZE_COL */
	CULC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER structure of this user */
	CULC_DL_DATE,				/* guint64: retrieve date (org): unformatted value of CULC_DATE_COL */
	NB_CULC_COL
};

/* list of all column of the "running_hub_clist" clist */
/* UTF8: ok */
enum
{
	RHC_HUB_ADDR_COL=0,		/* char * (org) */
	RHC_HUB_NAME_COL,			/* char * (wo) */
	RHC_NB_USERS_COL,			/* guint (org) */
	RHC_NB_GDL_COL,			/* guint (org) */
	RHC_NB_UL_COL,				/* guint (org) */
	RHC_PROCESS_ID_COL,		/* char * : path of the unix socket of the process */
	RHC_PROCESS_PID_COL,		/* glong : pid of the process */
	RHC_LINE_BACKGROUND,		/* char *: background color of the line */
	RHC_HUB_NAME,				/* char *: unformatted value of RHC_HUB_NAME_COL */
	RHC_FLAGS_COL,				/* gulong: it is the status flags of the hub (only "is_clock_master" is recognized) */
	NB_RHC_COL
};

/* list of all column of the "hub_favorite_clist" clist */
/* UTF8: ok */
enum
{
	FHC_HUB_NAME_COL=0,		/* char * (wo) */
	FHC_DESC_COL,				/* char * (wo) */
	FHC_HUB_ADDR_COL,			/* char * (org) */
	FHC_PROFILE,				/* char * (org) */
	FHC_FLAGS,					/* char * (org) */
	FHC_MARK_NUM,				/* gint: mark number in the Bookmark file */
	FHC_LINE_BACKGROUND,		/* char *: background color of the line */
	NB_FHC_COL
};

/* list of all column of the "hub_public_clist" clist */
/* UTF8: ok */
enum
{
	PHC_COUNTRY_COL=0,		/* (GdkPixbuf*): country icon */
	PHC_HUB_NAME_COL,			/* char * (wo) */
	PHC_NB_USERS_COL,			/* char *: contains nb_users/maxusers */
	PHC_SHARES_COL,			/* char * (wo) */
	PHC_MIN_SHARE_COL,		/* char * (wo) */
	PHC_MAXHUB_COL,			/* char * (wo) */
	PHC_HUB_ADDR_COL,			/* char * (wo) */
	PHC_RATING_COL,			/* char * (wo) */
	PHC_RELIABILITY_COL,		/* char * (wo) */
	PHC_DESC_COL,				/* char * (wo) */
	/* end of visible column (see HUB_ENTRY structure for value meaning) */
	PHC_RIGHT_ALIGN_COL,		/* gfloat: this column is only in the model, it forces right alignment */
	PHC_HUB_NAME,				/* char *: unformatted value of PHC_HUB_NAME_COL */
	PHC_DESC,					/* char *: unformatted value of PHC_DESC_COL */
	PHC_NB_USERS,				/* guint: unformatted value of PHC_NB_USERS_COL: #users */
	PHC_COUNTRY,				/* char *: country in the string format */
	PHC_SHARES,					/* guint64: unformatted value of PHC_SHARES_COL: hub share size */
	PHC_STATUS,					/* char *: status: "online", ...  */
	PHC_MIN_SHARE,				/* guint64: unformatted value of PHC_MIN_SHARE_COL: minimal client share size */
	PHC_MAXHUB,					/* guint: unformatted value of PHC_MAXHUB_COL: max #hubs a client can connect to */
	PHC_MAXUSERS,				/* guint: max #users on the hub */
	PHC_RELIABILITY,			/* gfloat: u.value of PHC_RELIABILITY_COL */
	PHC_RATING,					/* gint: hub rating */
	PHC_STATUS_BACKGROUND,		/* char *: altered according to PHC_STATUS (for PHC_HUB_NAME_COL background) */
	NB_PHC_COL
};

/* list of all column of the "hub_recent_clist" clist */
/* UTF8: ok */
enum
{
	REHC_HUB_NAME_COL=0,		/* char * (wo) */
	REHC_HUB_ADDR_COL,		/* char * (org) */
	REHC_HUB_NAME,				/* char *: unformatted value of REHC_HUB_NAME_COL */
	REHC_DUMMY,					/* gint: this column only exists to allow a fake sort order (always ==0) */
	NB_REHC_COL
};

/* list of all column of the "seen_hub_clist" clist */
/* UTF8: ok */
enum
{
	SHC_HUB_NAME_COL=0,		/* char * (wo) */
	SHC_NB_USERS_COL,			/* guint (org) */
	SHC_DESC_COL,				/* char * (wo) */
	SHC_HUB_ADDR_COL,			/* char * (org) */
	SHC_RIGHT_ALIGN_COL,		/* gfloat: this column is only in the model, it forces right alignment */
	SHC_HUB_NAME,				/* char *: unformatted value of SHC_HUB_NAME_COL */
	SHC_DESC,					/* char *: unformatted value of SHC_DESC */
	NB_SHC_COL
};

/* list of all column of the "locate_user_clist" clist */
/* UTF8: ? */
enum
{
	LUC_NICK_COL=0,
	LUC_SIZE_COL=1,
	LUC_IP_COL=2,
	LUC_RIGHT_ALIGN_COL=3,		/* this column is only in the model, it forces right alignment */
	NB_LUC_COL
};

/* list of all column of the "uaddr_clist" clist */
/* UTF8: ok */
enum
{
	UAC_NICK_COL=0,		/* char * (wo) */
	UAC_ADDR_PORT_COL,	/* char * (org) */
	UAC_BACKGROUND_COL,	/* char *: background color */
	UAC_FOREGROUND_COL,	/* char *: foreground color */
#if 0
	UAC_NICK,				/* char *: unformatted value of UAC_NICK_COL */
#endif
	UAC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER of this entry */
	NB_UAC_COL
};

/* list of all column of the "unode_clist" clist */
/* UTF8: ok */
enum
{
	UNC_UNODE_ADDR_COL=0,
	NB_UNC_COL
};

/* list of all column of the "flagged_user_clist" clist */
/* UTF8: ok */
enum
{
	FUC_NICK_COL=0,		/* char * (wo) */
	FUC_FLAGS_COL,			/* char * (org) */
	FUC_BACKGROUND_COL,	/* char *: background color */
	FUC_FOREGROUND_COL,	/* char *: foreground color */
#if 0
	FUC_NICK,				/* char *: unformatted value of FUC_NICK_COL */
#endif
	FUC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER of this entry */
	NB_FUC_COL
};

/* list of all column of the "queue_clist" clist */
/* UTF8: ok */
enum
{
	QUC_NICK_COL=0,		/* char * (wo) */
	QUC_FILENAME_COL,		/* char * (wo) */
	QUC_ID_COL,				/* gulong: the xfer ID */
	QUC_BACKGROUND_COL,	/* char *: background color */
	QUC_FOREGROUND_COL,	/* char *: foreground color */
#if 0
	QUC_NICK,				/* char *: unformatted value of QUC_NICK_COL */
#endif
	QUC_USER_POINTER,		/* GLOB_USER *: pointer on the GLOB_USER of this entry */
	NB_QUC_COL
};

/* list of all columns of the "bittorrent_clist" tree_view */
enum
{
	BTC_FILENAME_COL=0,	/* char * (wo) */
	BTC_SIZE_COL,			/* char * (wo) */
	BTC_STATUS_COL,		/* char * (wo) */
	BTC_DL_SPEED_COL,		/* char * (wo) */
	BTC_UL_SPEED_COL,		/* char * (wo) */
	BTC_DL_SPEED,			/* gfloat: unformatted value of BTC_DL_SPEED_COL */
	BTC_UL_SPEED,			/* gfloat: unformatted value of BTC_UL_SPEED_COL */
	BTC_BACKGROUND_COL,	/* char *: background color */
	BTC_BITTORRENT_PID,	/* gint: pid of the bittorrent process */
	NB_BTC_COL
};

/* list of all column of the "shared_dir_clist" clist */
/* UTF8: ? */
enum
{
	SDC_DIRECTORY_COL=0,
	NB_SDC_COL
};

/* list of all column of the "custom_hublist_treeview" clist */
/* UTF8: ? */
enum
{
	CHT_URL_COL=0,
	NB_CHT_COL
};

/* list of all column of the "unattached_gdl_treeview" list */
enum
{
	UAG_FILENAME_COL=0,	/* char * (wo) */
	UAG_SIZE_COL,			/* char * (wo) */
	UAG_NB_SRC_COL,		/* guint : number of download sources */
	UAG_COMPRATIO_COL,	/* char *: download completion ratio (estimated) */
	UAG_FINALNAME_COL,	/* char * (wo): final filename */
	UAG_FILENAME,			/* char *: unformatted value of UAG_FILENAME_COL */
	UAG_COMPRATIO,			/* gfloat: unformatted value of UAG_COMPRATIO_COL */
	UAG_SIZE_AS_VAL,		/* gulong: unformated value of UAG_SIZE_COL */
	NB_UAG_COL
};

#endif
