<?php
/*
 * $Id: class.boChecklistTpl.inc.php,v 1.2.4.3 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('chk');

class boChecklistTpl
{
	function GetTplPath($id, $bCreate = false)
	{
		global $dcl_info;

		$filePath = $dcl_info['DCL_FILE_PATH'] . '/checklists/templates';
		$dir[1] = $id % 10; // last digit
		$dir[2] = ($id - $dir[1]) % 100;
		$dir[3] = ($id - $dir[2] - $dir[1]) % 1000;
		$dir[4] = ($id - $dir[3] - $dir[2] - $dir[1]) % 10000;
		$dir[5] = ($id - $dir[4] - $dir[3] - $dir[2] - $dir[1]) % 100000;

		// make directories and build path as needed, except for last one ;-)
		for ($i = 5; $i > 2; $i--)
		{
			$filePath .= '/' . $dir[$i];
			if ($bCreate && !is_dir($filePath))
				mkdir($filePath, 0755);
		}

		$filePath .= '/' . $id . '.xml';

		return $filePath;
	}

	function RenderOptions(&$aRecord)
	{
		global $dcl_info, $g_oSec;

		$str = '<td>';

		if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
		{
			if ($aRecord['dcl_chklst_tpl_active'] == 'Y')
				$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boChecklists.add&dcl_chklst_tpl_id=' . $aRecord['dcl_chklst_tpl_id']) . '">' . STR_CHK_INITIATE . '</a>';
			else
				$str .= '<b>' . STR_CHK_INITIATE . '</b>';

			$str .= '&nbsp;|&nbsp;';
		}

		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boChecklistTpl.view&dcl_chklst_tpl_id=' . $aRecord['dcl_chklst_tpl_id']) . '">' . STR_CMMN_VIEW . '</a>';
		if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
		{
			$str .= '&nbsp;|&nbsp;';
			$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boChecklistTpl.modify&dcl_chklst_tpl_id=' . $aRecord['dcl_chklst_tpl_id']) . '">' . STR_CMMN_EDIT . '</a>';
		}
		if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
		{
			$str .= '&nbsp;|&nbsp;';
			$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boChecklistTpl.delete&dcl_chklst_tpl_id=' . $aRecord['dcl_chklst_tpl_id']) . '">' . STR_CMMN_DELETE . '</a>';
		}
		$str .= '</td>';
		echo $str;
	}

	function show()
	{
		commonHeader();

		$oView = CreateObject('dcl.boView');
		$o = CreateObject('dcl.dbChklstTpl');

		$oView->table = 'dcl_chklst_tpl';
		$oView->style = 'report';
		$oView->title = STR_CHK_CHECKLISTTEMPLATES;
		$oView->AddDef('columns', '', array('dcl_chklst_tpl_id', 'dcl_chklst_tpl_active', 'dcl_chklst_tpl_name'));
		$oView->AddDef('columnhdrs', '', array(STR_CMMN_ID, STR_CMMN_ACTIVE, STR_CHK_CHECKLISTNAME));

		$startrow = 0;
		$numrows = 15;
		if (IsSet($GLOBALS['startrow']))
			$offset = $GLOBALS['startrow'];
		if (IsSet($GLOBALS['numrows']))
			$numrows = $GLOBALS['numrows'];

		$oView->startrow = $startrow;
		$oView->numrows = $numrows;

		$oHtml = CreateObject('dcl.htmlChecklistTplView');
		$oHtml->Render($oView);
	}

	function add()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
		{
			$obj = CreateObject('dcl.htmlChklstTpl');
			$obj->add();
		}
		else
			PrintPermissionDenied();
	}

	function dbadd()
	{
		global $dcl_info, $g_oSec;
		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
		{
			PrintPermissionDenied();
			return;
		}

		$sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile_name'];
		if ($sFileName != 'none')
		{
			$sName = '';

			$oXML = CreateObject('dcl.xmlDoc');
			$oXML->ParseFile($sFileName);
			$oXML->FindChildNode($oXML->root, 'Name');
			if ($oXML->currentNode != NULL)
			{
				$sName = $oXML->currentNode->data;
				$oXML->FindChildNode($oXML->root, 'Version');
				if ($oXML->currentNode != NULL)
				{
					if ($sName != '')
						$sName .= ' ';

					$sName .= $oXML->currentNode->data;
				}

				echo $sName;
				$o = CreateObject('dcl.dbChklstTpl');
				$o->Connect();
				$o->dcl_chklst_tpl_name = $sName;
				$o->Add();
				if (IsSet($o->dcl_chklst_tpl_id))
				{
					// Insert successful, now stow file in its place
					$filePath = $this->GetTplPath($o->dcl_chklst_tpl_id, true);

					if (!copy($sFileName, $filePath))
						echo STR_BO_UPLOADERR;
				}
			}
		}

		$this->show();
	}

	function modify()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
		{
			$obj = CreateObject('dcl.htmlChklstTpl');
			$obj->modify();
		}
		else
			PrintPermissionDenied();
	}

	function dbmodify()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
		{
			PrintPermissionDenied();
			return;
		}

		$o = CreateObject('dcl.dbChklstTpl');
		$o->Connect();
		if ($o->Load($GLOBALS['dcl_chklst_tpl_id']) != -1)
		{
			$sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile_name'];
			if ($sFileName != 'none')
			{
				$sName = '';

				$oXML = CreateObject('dcl.xmlDoc');
				$oXML->ParseFile($sFileName);
				$oXML->FindChildNode($oXML->root, 'Name');
				if ($oXML->currentNode != NULL)
				{
					$sName = $oXML->currentNode->data;
					$oXML->FindChildNode($oXML->root, 'Version');
					if ($oXML->currentNode != NULL)
					{
						if ($sName != '')
							$sName .= ' ';

						$sName .= $oXML->currentNode->data;
					}

					$o->dcl_chklst_tpl_name = $sName;
				}
			}

			$o->dcl_chklst_tpl_active = $GLOBALS['dcl_chklst_tpl_active'];
			$o->BeginTransaction();
			$o->Edit();

			if ($sFileName != 'none')
			{
				// Insert successful, now stow file in its place
				$filePath = $this->GetTplPath($o->dcl_chklst_tpl_id, true);

				if (copy($sFileName, $filePath))
				{
					$o->EndTransaction();
				}
				else
				{
					$o->RollbackTransaction();
					echo STR_BO_UPLOADERR;
				}
			}
			else
			{
				$o->EndTransaction();
			}
		}

		$this->show();
	}

	function delete()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
		{
			$o = CreateObject('dcl.dbChklstTpl');
			$o->Connect();
			if ($o->Load($GLOBALS['dcl_chklst_tpl_id']) != -1)
				ShowDeleteYesNo(STR_CHK_CHECKLISTTEMPLATE, 'boChecklistTpl.dbdelete', $o->dcl_chklst_tpl_id, $o->dcl_chklst_tpl_name, true, 'dcl_chklst_tpl_id');
		}
		else
			PrintPermissionDenied();
	}

	function dbdelete()
	{
		global $dcl_info, $g_oSec;

		commonHeader();
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
		{
			PrintPermissionDenied();
			return;
		}

		$o = CreateObject('dcl.dbChklstTpl');
		$o->Connect();
		$o->Query('select count(*) from dcl_chklst where dcl_chklst_tpl_id=' . $GLOBALS['dcl_chklst_tpl_id']);
		$o->next_record();
		if ($o->f(0) > 0)
		{
			// records? - deactivate it
			if ($o->Load($GLOBALS['dcl_chklst_tpl_id']) != -1)
			{
				$o->dcl_chklst_tpl_active = 'N';
				$o->Edit();
			}
		}
		else
		{
			// no records, so delete it
			$o->dcl_chklst_tpl_id = $GLOBALS['dcl_chklst_tpl_id'];
			$o->Delete();
			$filePath = $this->GetTplPath($GLOBALS['dcl_chklst_tpl_id']);
			if (is_file($filePath) && is_readable($filePath))
				unlink($filePath);
		}

		$this->show();
	}

	function view()
	{
		commonHeader();
		$oCL = CreateObject('dcl.htmlChecklistForm');
		$oCL->show($GLOBALS['dcl_chklst_tpl_id'], $this->GetTplPath($GLOBALS['dcl_chklst_tpl_id']), true);
	}
}
?>
