<?php
/*
 * $Id: class.htmlPreferences.inc.php,v 1.1.2.4 2003/12/14 01:12:47 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('menu');
LoadStringResource('usr');
LoadStringResource('cfg');

class htmlPreferences
{
	function modify()
	{
		global $dcl_info, $g_oSession;

		commonHeader();
		$t = CreateTemplate(array('hForm' => 'htmlPreferences.tpl'));
		$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$t->set_var('VAL_FORMACTION', menuLink());
		$t->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$t->set_var('BTN_RESET', STR_CMMN_RESET);
		$t->set_var('TXT_PREFERENCES', DCL_MENU_PREFERENCES);
		$t->set_var('TXT_EMAIL', STR_USR_EMAIL);
		$t->set_var('TXT_DEFAULTTEMPLATESET', STR_CFG_DEFTEMPLATESET);
		$t->set_var('TXT_DEFAULTLANGUAGE', STR_CFG_LANGUAGE);
		$t->set_var('VAL_EMAIL', $GLOBALS['USEREMAIL']);

		// Reuse methods from here for lang and template
		$o = CreateObject('dcl.htmlConfig');
		$t->set_var('CMB_DEFAULTTEMPLATESET', $o->GetTemplatesCombo('DCL_PREF_TEMPLATE_SET', GetDefaultTemplateSet()));

		$lang = $dcl_info['DCL_DEFAULT_LANGUAGE'];
		$oPrefs = CreateObject('dcl.dbPreferences');
		$oPrefs->preferences_data = $g_oSession->Value('dcl_preferences');
		if (isset($oPrefs->preferences_data) && is_array($oPrefs->preferences_data))
		{
			if ($oPrefs->Value('DCL_PREF_LANGUAGE') != '')
				$lang = $oPrefs->Value('DCL_PREF_LANGUAGE');
		}

		$t->set_var('CMB_DEFAULTLANGUAGE', $o->GetLangCombo('DCL_PREF_LANGUAGE', $lang));

		$t->pparse('out', 'hForm');
	}

	function submitModify()
	{
		global $g_oSession, $dcl_info;

		$o = CreateObject('dcl.dbPersonnel');
		if ($o->Load($GLOBALS['DCLID']) != -1)
		{
			if ($GLOBALS['USEREMAIL'] != $GLOBALS[GetSourceArray()]['email'])
			{
				$o->email = $GLOBALS[GetSourceArray()]['email'];
				$o->edit();

				$GLOBALS['USEREMAIL'] = $o->email;
				$g_oSession->Register('USEREMAIL', $o->email);
				$g_oSession->Edit();
			}
		}

		unset($o);

		$bHasChanges = false;
		$o = CreateObject('dcl.dbPreferences');
		$o->Connect();
		$o->personnel_id = $GLOBALS['DCLID'];
		$o->preferences_data = $g_oSession->Value('dcl_preferences');
		if (!isset($o->preferences_data) || !is_array($o->preferences_data) || count($o->preferences_data) < 1)
		{
			$o->preferences_data = array(
					'DCL_PREF_TEMPLATE_SET' => $dcl_info['DCL_DEF_TEMPLATE_SET'],
					'DCL_PREF_LANGUAGE' => $dcl_info['DCL_DEFAULT_LANGUAGE']
				);

			$o->Add();

			$bHasChanges = true;
		}

		$sOldTpl = $o->preferences_data['DCL_PREF_TEMPLATE_SET'];

		$_SRC = GetSourceArray();
		while (list($pref, $setting) = each($GLOBALS[$_SRC]))
		{
			if (substr($pref, 0, 9) != 'DCL_PREF_')
				continue;

			if ($o->Value($pref) != $setting)
			{
				$bHasChanges = true;
				$o->Register($pref, $setting);
			}
		}

		if ($bHasChanges)
		{
			$o->Edit();
			$g_oSession->Register('dcl_preferences', $o->preferences_data);
			$g_oSession->Edit();
		}

		// Template change?
		$sNewTpl = $o->preferences_data['DCL_PREF_TEMPLATE_SET'];
		if ($sNewTpl != $sOldTpl)
		{
			// Do we need to break out of frames?
			$menuAction = 'menuAction=htmlPreferences.modify';
			$sNewIsFramed = file_exists(DCL_ROOT . 'templates/' . $sNewTpl . '/frameset.php');
			$sOldIsFramed = file_exists(DCL_ROOT . 'templates/' . $sOldTpl . '/frameset.php');

			if ($sOldIsFramed)
			{
				if ($sNewIsFramed)
					RefreshTop(menuLink(DCL_WWW_ROOT . 'templates/' . $sNewTpl . '/frameset.php', $menuAction));
				else
					RefreshTop(menuLink('', $menuAction));
			}
			else if ($sNewIsFramed)
			{
				RefreshTop(menuLink(DCL_WWW_ROOT . 'templates/' . $sNewTpl . '/frameset.php', $menuAction));
			}
		}

		$this->modify();
	}
}
?>
