-- $Id: createdb.sql,v 1.5.2.6.2.13 2003/05/10 02:05:03 mdean Exp $
--
-- Host: localhost Database : dcl

-- --------------------------------------------------------
--
-- Table structure for table 'accounts'
--

use dcl
go

CREATE TABLE accounts (
		id numeric(11,0) IDENTITY,
		short varchar(25) NOT NULL,
		name varchar(50) NOT NULL,
		add1 varchar(30) NULL,
		add2 varchar(30) NULL,
		city varchar(50) NULL,
		state char(2) NULL,
		zip varchar(11) NULL,
		contact varchar(50) NULL,
		voice varchar(10) NULL,
		fax varchar(10) NULL,
		data1 varchar(10) NULL,
		data2 varchar(10) NULL,
		notes text NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

CREATE UNIQUE INDEX uc_accounts_short ON accounts(short)
CREATE UNIQUE INDEX uc_accounts_name ON account(name)
go


--
-- Dumping data for table 'accounts'
--


-- --------------------------------------------------------
--
-- Table structure for table 'actions'
--

CREATE TABLE actions (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'actions'
--

INSERT INTO actions VALUES( 'DBG', 'Debug', 'Y')
go
INSERT INTO actions VALUES( 'RES', 'Research', 'Y')
go
INSERT INTO actions VALUES( 'DOC', 'Document', 'Y')
go
INSERT INTO actions VALUES( 'TST', 'Testing', 'Y')
go
INSERT INTO actions VALUES( 'DES', 'Design', 'Y')
go
INSERT INTO actions VALUES( 'IMP', 'Implementation', 'Y')
go
INSERT INTO actions VALUES( 'CORR', 'Correction', 'Y')
go

-- --------------------------------------------------------
--
-- Table structure for table 'departments'
--

CREATE TABLE departments (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(30) NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'departments'
--


-- --------------------------------------------------------
--
-- Table structure for table 'jcn'
--

CREATE TABLE jcn (
		id numeric(11,0) IDENTITY,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'jcn'
--


-- --------------------------------------------------------
--
-- Table structure for table 'personnel'
--

CREATE TABLE personnel (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		lastname varchar(25) NOT NULL,
		firstname varchar(20) NULL,
		reportto int NOT NULL,
		department int NOT NULL,
		pwd varchar(50) NOT NULL,
		security int NOT NULL,
		email varchar(80) NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

CREATE UNIQUE INDEX ix_short ON personnel(short)
go

--
-- Dumping data for table 'personnel'
--

INSERT INTO personnel (short,lastname,firstname,reportto,department,pwd,security,email,active) VALUES( 'sa', 'Administrator', 'System', 0, 0, 'c12e01f2a13ff5587e1e9e4aedb8242d', 9, '', 'Y')
go

-- --------------------------------------------------------
--
-- Table structure for table 'priorities'
--

CREATE TABLE priorities (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		weight int  NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'priorities'
--


-- --------------------------------------------------------
--
-- Table structure for table 'products'
--

CREATE TABLE products (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(50) NOT NULL,
		reportto int NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		ticketsto int DEFAULT '0' not null,
		wosetid int DEFAULT '0' not null,
		tcksetid int DEFAULT '0' not null,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'products'
--


-- --------------------------------------------------------
--
-- Table structure for table 'severities'
--

CREATE TABLE severities (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		weight int NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'severities'
--


-- --------------------------------------------------------
--
-- Table structure for table 'statuses'
--

CREATE TABLE statuses (
		id numeric(11,0) IDENTITY,
		short varchar(10) NOT NULL,
		name varchar(20) NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		dcl_status_type int default '1' not null,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'statuses'
--

INSERT INTO statuses VALUES( 'OP', 'Open', 'Y', 1)
go
INSERT INTO statuses VALUES( 'CL', 'Closed', 'Y', 2)
go
INSERT INTO statuses VALUES( 'DF', 'Deferred', 'Y', 3)
go
INSERT INTO statuses VALUES( 'UA', 'Unassigned', 'Y', 1)
go

-- --------------------------------------------------------
--
-- Table structure for table 'timecards'
--

CREATE TABLE timecards (
		id numeric(11,0) IDENTITY,
		jcn int  NOT NULL,
		seq int  NOT NULL,
		actionon varchar(8) NOT NULL,
		inputon varchar(14) NOT NULL,
		actionby int  NOT NULL,
		status int  NOT NULL,
		action int  NOT NULL,
		hours float DEFAULT '0.00' NOT NULL,
		summary varchar(100) NOT NULL,
		description text NOT NULL,
		revision varchar(20) NOT NULL,
		reassign_from_id int null,
		reassign_to_id int null,
		PRIMARY KEY (id)
	)
go

--
-- Dumping data for table 'timecards'
--


-- --------------------------------------------------------
--
-- Table structure for table 'workorders'
--

CREATE TABLE workorders (
		jcn int  NOT NULL,
		seq int  NOT NULL,
		product int  NOT NULL,
		account int NULL,
		createby int  NOT NULL,
		createdon varchar(14) NULL,
		closedby int NULL,
		closedon varchar(8) NULL,
		status int  NOT NULL,
		statuson varchar(14) NULL,
		lastactionon varchar(14) NULL,
		deadlineon varchar(8) NULL,
		eststarton varchar(8) NULL,
		estendon varchar(8) NULL,
		starton varchar(8) NULL,
		esthours float NULL,
		totalhours float NULL,
		priority int  NOT NULL,
		severity int  NOT NULL,
		contact varchar(50) NULL,
		contactphone varchar(10) NULL,
		summary varchar(100) NOT NULL,
		notes text NULL,
		description text NOT NULL,
		responsible int  NOT NULL,
		revision varchar(20) NULL,
		publicview tinyint NULL,
		oid numeric(11,0) IDENTITY,
		etchours float NULL,
		module_id int NULL,
		PRIMARY KEY (oid)
	)
go

--
-- Dumping data for table 'workorders'
--

-- --------------------------------------------------------
--
-- Table structure for table 'dcl_projects'
--

CREATE TABLE dcl_projects (
		projectid numeric(11,0) IDENTITY,
		name varchar(100) NOT NULL,
		reportto int NOT NULL,
		createdby int NOT NULL,
		createdon varchar(14) NULL,
		projectdeadline varchar(8) NULL,
		description text NOT NULL,
		status int NOT NULL,
		lastactivity varchar(14) NULL,
		finalclose varchar(8) NULL,
		parentprojectid int DEFAULT '0' not null,
		PRIMARY KEY (projectid)
	)
go

CREATE UNIQUE INDEX ix_name ON dcl_projects(name)
go

--
-- Dumping data for table 'projects'
--

-- --------------------------------------------------------
--
-- Table structure for table 'projectmap'
--

CREATE TABLE projectmap (
		projectid int NOT NULL,
		jcn int NOT NULL,
		seq int NOT NULL,
		PRIMARY KEY (projectid,jcn,seq)
	)
go

--
-- Dumping data for table 'projectmap'
--

-- --------------------------------------------------------
--
-- Table structure for table 'watches'
--

CREATE TABLE watches (
		watchid numeric(11,0) identity,
		typeid int NOT NULL,
		whatid1 int NOT NULL,
		whatid2 int NOT NULL,
		whoid int NOT NULL,
		actions int NOT NULL,
		PRIMARY KEY (watchid)
	)
go
CREATE TABLE tickets (
		ticketid numeric(11,0) IDENTITY NOT NULL,
		product int NOT NULL,
		account int NOT NULL,
		createdby int NOT NULL,
		createdon varchar(14)  NOT NULL,
		responsible int NOT NULL,
		closedby int NULL,
		closedon varchar(14) NULL,
		status int NOT NULL,
		statuson varchar(14) NOT NULL,
		lastactionon varchar(14) NULL,
		priority int NOT NULL,
		type int NOT NULL,
		contact varchar(80) NULL,
		contactphone varchar(20) NULL,
		issue text NOT NULL,
		version varchar(20) NULL,
		summary varchar(100) NULL,
		seconds int DEFAULT '0' not null,
		contactemail varchar(100) NULL,
		module_id int NULL,
		PRIMARY KEY (ticketid)
	)
GO

CREATE TABLE ticketresolutions (
		resid numeric(11,0) IDENTITY NOT NULL,
		ticketid int NOT NULL,
		loggedby int NOT NULL,
		loggedon varchar(14)  NOT NULL,
		status int NOT NULL,
		resolution text NOT NULL,
		startedon varchar(14) NOT NULL,
		PRIMARY KEY (resid)
	)
GO

CREATE TABLE faq (
		faqid numeric(11,0) IDENTITY NOT NULL,
		name varchar(80) NOT NULL,
		createby int NOT NULL,
		createon varchar(14)  NOT NULL,
		modifyby int NULL,
		modifyon varchar(14) NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		description text NULL,
		PRIMARY KEY (faqid)
	)
GO

CREATE TABLE faqtopics (
		topicid numeric(11,0) IDENTITY NOT NULL,
		seq int NOT NULL,
		faqid int NOT NULL,
		name varchar(80) NOT NULL,
		description text NOT NULL,
		createby int NOT NULL,
		createon varchar(14)  NOT NULL,
		modifyby int NULL,
		modifyon varchar(14) NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (topicid)
	)
GO

CREATE TABLE faqquestions (
		questionid numeric(11,0) IDENTITY NOT NULL,
		seq int NOT NULL,
		topicid int NOT NULL,
		questiontext text NOT NULL,
		createby int NOT NULL,
		createon varchar(14)  NOT NULL,
		modifyby int NULL,
		modifyon varchar(14) NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (questionid)
	)
GO

CREATE TABLE faqanswers (
		answerid numeric(11,0) IDENTITY NOT NULL,
		questionid int NOT NULL,
		answertext text NOT NULL,
		createby int NOT NULL,
		createon varchar(14)  NOT NULL,
		modifyby int NULL,
		modifyon varchar(14) NULL,
		active char(1) DEFAULT 'Y' NOT NULL,
		PRIMARY KEY (answerid)
	)
GO

CREATE TABLE views (
		viewid numeric(11,0) IDENTITY NOT NULL,
		whoid int NOT NULL,
		name varchar(100) NOT NULL,
		ispublic char(1) DEFAULT 'N' NOT NULL,
		viewurl text NOT NULL,
		tablename varchar(30) not null,
		PRIMARY KEY(viewid)
	)
GO


CREATE TABLE attributesets (
		id numeric(11,0) IDENTITY NOT NULL,
		short varchar(20) NOT NULL,
		name varchar(100) NOT NULL,
		active char(1) DEFAULT 'Y' NOT NULL
	)
GO

INSERT INTO attributesets(short,name,active) VALUES ('WO', 'Work Orders', 'Y')
GO
INSERT INTO attributesets(short,name,active) VALUES ('TCK', 'Tickets', 'Y')
GO

CREATE TABLE attributesetsmap (
		setid int NOT NULL,
		typeid int NOT NULL,
		keyid int NOT NULL,
		weight int NOT NULL
	)
GO

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses
GO

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses
GO
CREATE TABLE dcl_config (
		dcl_config_name varchar(50) NOT NULL,
		dcl_config_field varchar(30) NOT NULL,
		dcl_config_int int NULL,
		dcl_config_double float NULL,
		dcl_config_date varchar(8) NULL,
		dcl_config_datetime varchar(14) NULL,
		dcl_config_varchar varchar(255) NULL,
		PRIMARY KEY (dcl_config_name)
	)
GO

CREATE TABLE dcl_chklst (
	dcl_chklst_id numeric(11,0) IDENTITY NOT NULL,
	dcl_chklst_tpl_id int NOT NULL,
	dcl_chklst_summary varchar(255) NOT NULL,
	dcl_chklst_createby int NOT NULL,
	dcl_chklst_createon varchar(14) NOT NULL,
	dcl_chklst_modifyby int NULL,
	dcl_chklst_modifyon varchar(14) NULL,
	dcl_chklst_status varchar(255) NULL,
	PRIMARY KEY (dcl_chklst_id)
)
GO

CREATE TABLE dcl_chklst_tpl (
	dcl_chklst_tpl_id numeric(11,0) IDENTITY NOT NULL,
	dcl_chklst_tpl_name varchar(255) NOT NULL,
	dcl_chklst_tpl_active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (dcl_chklst_tpl_id)
)
GO

CREATE TABLE dcl_product_module (
	product_module_id numeric(11,0) IDENTITY NOT NULL,
	product_id int Not Null,
	module_name varchar(50) NOT NULL,
	active char(1) NOT NULL,
	PRIMARY KEY (product_module_id)
)
GO

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_VERSION', 'dcl_config_varchar', '0.9.3')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT', 'dcl_config_varchar', 'm/d/Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT_DB', 'dcl_config_varchar', 'Ymd')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT_DB', 'dcl_config_varchar', 'YmdHis')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT', 'dcl_config_varchar', 'm/d/Y H:i:s')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_MAX_UPLOAD_FILE_SIZE', 'dcl_config_int', 1048576)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DEFAULT_LANGUAGE','dcl_config_varchar', 'en')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PRIVATE_KEY','dcl_config_varchar', 'IloveDCL')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_ROOT', 'dcl_config_varchar', 'http://localhost/dcl/')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ADD_USER', 'dcl_config_int', 9)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEL_WO', 'dcl_config_int', 8)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_MOD_WO', 'dcl_config_int', 7)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ASSIGN_WO', 'dcl_config_int', 5)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_ADD_WO', 'dcl_config_int', 3)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_HAVE_WO', 'dcl_config_int', 4)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_CHG_PWD', 'dcl_config_int', 2)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_STATUS_ASSIGN_WO', 'dcl_config_int', 1)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_STATUS_UNASSIGN_WO', 'dcl_config_int', 4)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_PRIORITY', 'dcl_config_int', 1)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEF_SEVERITY', 'dcl_config_int', 2)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_AUTO_DATE', 'dcl_config_varchar', 'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_TIME_CARD_ORDER', 'dcl_config_varchar', 'ASC')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_XML_TEMPLATES', 'dcl_config_varchar', 'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_GD_TYPE', 'dcl_config_varchar', 'png')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_CQQ_PERCENT', 'dcl_config_int',0)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_FROM', 'dcl_config_varchar', 'Somebody <someone@somewhere.org>')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_SUBJECT', 'dcl_config_varchar', 'Thank You For Calling')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_CQQ_TEMPLATE', 'dcl_config_varchar', 'cqqmail.tpl')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_DEF_TEMPLATE_SET', 'dcl_config_varchar', 'default')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_COLOR_LIGHT', 'dcl_config_varchar', '#eeeef8')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_COLOR_DARK', 'dcl_config_varchar', '#737b9c')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_SERVER', 'dcl_config_varchar', 'localhost')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_SMTP_ENABLED', 'dcl_config_varchar', 'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_PORT', 'dcl_config_int', 25)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_SMTP_TIMEOUT', 'dcl_config_int', 30)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime) values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', GetDate())
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5)
GO

Create Table dcl_wo_account (
	wo_id int not null,
	seq int not null,
	account_id int not null,
	primary key(wo_id, seq, account_id)
)
GO

Create Table dcl_wo_type (
	wo_type_id numeric(11,0) IDENTITY not null primary key,
	type_name varchar(50) not null,
	active char(1) not null
)
GO

Create Table dcl_session (
	dcl_session_id varchar(32) not null primary key,
	personnel_id int not null,
	create_date datetime not null,
	update_date datetime not null,
	session_data text null
)
GO

Create Table dcl_preferences (
	personnel_id int not null primary key,
	preferences_data text null
)
GO

create table dcl_status_type (
	dcl_status_type_id int not null primary key,
	dcl_status_type_name varchar(50) not null
)
GO

insert into dcl_status_type values (1, 'Open')
insert into dcl_status_type values (2, 'Completed')
insert into dcl_status_type values (3, 'Deferred')
GO

Create Table dcl_wiki (
	dcl_entity_type_id int not null,
	dcl_entity_id int not null,
	dcl_entity_id2 int not null,
	page_name varchar(255) not null,
	page_text text null,
	page_date datetime null,
	page_ip varchar(255) null,
	primary key (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name)
)
GO
