#include "error.h"
#include <string.h>

void error_exit(error_t e, const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	vfprintf(stderr, msg, ap);
	va_end(ap);

	exit(e);
}

void perror_exit(error_t e, const char *msg) {
	perror(msg);
	exit(e);
}

void *xmalloc(size_t l) {
	void *r;
	r = calloc(1, l);
	if(!r)
		perror_exit(ERROR_SYSTEM, "calloc()");
	return r;
}

char *xstrdup(const char *s) {
	return strcpy(xmalloc(strlen(s)+1), s);
}

char *xstrndup(const char *s, int n) {
	return strncpy(xmalloc(strlen(s)+1), s, n); /* relies on calloc() for termination */
}

char *xstrcat(const char *s1, const char *s2) {
	char *s = xmalloc(strlen(s1)+strlen(s2)+1);
	strcpy(s, s1);
	strcat(s, s2);	/* relies on calloc() for termination */
	return s;
}
