/* CommonUtils.c generated by valac 0.12.1, the Vala compiler
 * generated from CommonUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <uriutils.h>


#define DEJA_DUP_TYPE_TIMESTAMP_TYPE (deja_dup_timestamp_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
#define _deja_dup_decoded_uri_free0(var) ((var == NULL) ? NULL : (var = (deja_dup_decoded_uri_free (var), NULL)))
typedef struct _DejaDupGetNicknameData DejaDupGetNicknameData;

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
typedef enum  {
	DEJA_DUP_TIMESTAMP_TYPE_NONE,
	DEJA_DUP_TIMESTAMP_TYPE_BACKUP,
	DEJA_DUP_TIMESTAMP_TYPE_RESTORE
} DejaDupTimestampType;

struct _DejaDupGetNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* f;
	gchar* result;
	gchar* s;
	gboolean _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* info;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GError * e;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_;
};


extern gboolean deja_dup_settings_read_only;
gboolean deja_dup_settings_read_only = FALSE;
extern GHashTable* deja_dup_settings_table;
GHashTable* deja_dup_settings_table = NULL;
extern GFile* deja_dup_home;
GFile* deja_dup_home = NULL;
extern GFile* deja_dup_trash;
GFile* deja_dup_trash = NULL;

#define DEJA_DUP_INCLUDE_LIST_KEY "include-list"
#define DEJA_DUP_EXCLUDE_LIST_KEY "exclude-list"
#define DEJA_DUP_BACKEND_KEY "backend"
#define DEJA_DUP_ROOT_PROMPT_KEY "root-prompt"
#define DEJA_DUP_WELCOMED_KEY "welcomed"
#define DEJA_DUP_LAST_RUN_KEY "last-run"
#define DEJA_DUP_LAST_BACKUP_KEY "last-backup"
#define DEJA_DUP_LAST_RESTORE_KEY "last-restore"
#define DEJA_DUP_PROMPT_CHECK_KEY "prompt-check"
#define DEJA_DUP_PERIODIC_KEY "periodic"
#define DEJA_DUP_PERIODIC_PERIOD_KEY "periodic-period"
#define DEJA_DUP_DELETE_AFTER_KEY "delete-after"
GQuark deja_dup_backup_error_quark (void);
GType deja_dup_timestamp_type_get_type (void) G_GNUC_CONST;
gboolean deja_dup_in_testing_mode (void);
void deja_dup_update_last_run_timestamp (DejaDupTimestampType type);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
void deja_dup_simple_settings_set_string (DejaDupSimpleSettings* self, const gchar* k, const gchar* v);
void deja_dup_simple_settings_apply (DejaDupSimpleSettings* self);
void deja_dup_run_deja_dup (const gchar* args, GAppLaunchContext* ctx, GList* files);
GDateTime* deja_dup_most_recent_scheduled_date (GTimeSpan period);
gchar* deja_dup_last_run_date (DejaDupTimestampType type);
GTimeSpan deja_dup_get_day (void);
GDateTime* deja_dup_next_run_date (void);
gint deja_dup_get_prompt_delay (void);
gboolean deja_dup_has_seen_settings (void);
void deja_dup_make_prompt_check (void);
void deja_dup_update_prompt_time (gboolean cancel);
gchar* deja_dup_get_trash_path (void);
gchar* deja_dup_get_folder_key (DejaDupSimpleSettings* settings, const gchar* key);
GFile* deja_dup_parse_dir (const gchar* dir);
GFile** deja_dup_parse_dir_list (const gchar** dirs, int dirs_length1, int* result_length1);
static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value);
void deja_dup_set_settings_read_only (gboolean ro);
DejaDupSimpleSettings* deja_dup_simple_settings_new (const gchar* schema, gboolean ro);
DejaDupSimpleSettings* deja_dup_simple_settings_construct (GType object_type, const gchar* schema, gboolean ro);
#define DEJA_DUP_SSH_USERNAME_KEY "username"
#define DEJA_DUP_SSH_SERVER_KEY "server"
#define DEJA_DUP_SSH_PORT_KEY "port"
#define DEJA_DUP_SSH_DIRECTORY_KEY "directory"
void deja_dup_convert_ssh_to_file (void);
#define DEJA_DUP_FILE_ROOT "File"
#define DEJA_DUP_FILE_PATH_KEY "path"
void deja_dup_convert_s3_folder_to_hostname (void);
#define DEJA_DUP_S3_ROOT "S3"
#define DEJA_DUP_S3_FOLDER_KEY "folder"
gchar* deja_dup_backend_get_default_type (void);
gboolean deja_dup_meet_requirements (gchar** header, gchar** msg);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, gchar** header, gchar** msg);
gboolean deja_dup_initialize (gchar** header, gchar** msg);
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
DejaDupBackend* deja_dup_backend_get_default (void);
void deja_dup_i18n_setup (void);
gchar* deja_dup_get_file_desc (GFile* file);
void deja_dup_ensure_special_paths (void);
gchar* deja_dup_get_display_name (GFile* f);
static void deja_dup_get_nickname_data_free (gpointer _data);
void deja_dup_get_nickname (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* deja_dup_get_nickname_finish (GAsyncResult* _res_);
static gboolean deja_dup_get_nickname_co (DejaDupGetNicknameData* data);
static void deja_dup_get_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint deja_dup_get_full_backup_threshold (void);
void deja_dup_get_full_backup_threshold_date (GDate* result);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark deja_dup_backup_error_quark (void) {
	return g_quark_from_static_string ("deja_dup_backup_error-quark");
}


GType deja_dup_timestamp_type_get_type (void) {
	static volatile gsize deja_dup_timestamp_type_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_timestamp_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_TIMESTAMP_TYPE_NONE, "DEJA_DUP_TIMESTAMP_TYPE_NONE", "none"}, {DEJA_DUP_TIMESTAMP_TYPE_BACKUP, "DEJA_DUP_TIMESTAMP_TYPE_BACKUP", "backup"}, {DEJA_DUP_TIMESTAMP_TYPE_RESTORE, "DEJA_DUP_TIMESTAMP_TYPE_RESTORE", "restore"}, {0, NULL, NULL}};
		GType deja_dup_timestamp_type_type_id;
		deja_dup_timestamp_type_type_id = g_enum_register_static ("DejaDupTimestampType", values);
		g_once_init_leave (&deja_dup_timestamp_type_type_id__volatile, deja_dup_timestamp_type_type_id);
	}
	return deja_dup_timestamp_type_type_id__volatile;
}


gboolean deja_dup_in_testing_mode (void) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* testing_str;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	if (testing_str != NULL) {
		gint _tmp3_;
		_tmp3_ = atoi (testing_str);
		_tmp2_ = _tmp3_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (testing_str);
	return result;
}


void deja_dup_update_last_run_timestamp (DejaDupTimestampType type) {
	GTimeVal cur_time = {0};
	gchar* _tmp0_ = NULL;
	gchar* cur_time_str;
	DejaDupSimpleSettings* _tmp1_ = NULL;
	DejaDupSimpleSettings* settings;
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	_tmp0_ = g_time_val_to_iso8601 (&cur_time);
	cur_time_str = _tmp0_;
	_tmp1_ = deja_dup_get_settings (NULL);
	settings = _tmp1_;
	g_settings_delay ((GSettings*) settings);
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_LAST_RUN_KEY, cur_time_str);
	if (type == DEJA_DUP_TIMESTAMP_TYPE_BACKUP) {
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_LAST_BACKUP_KEY, cur_time_str);
	} else {
		if (type == DEJA_DUP_TIMESTAMP_TYPE_RESTORE) {
			deja_dup_simple_settings_set_string (settings, DEJA_DUP_LAST_RESTORE_KEY, cur_time_str);
		}
	}
	deja_dup_simple_settings_apply (settings);
	_g_object_unref0 (settings);
	_g_free0 (cur_time_str);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deja_dup_run_deja_dup (const gchar* args, GAppLaunchContext* ctx, GList* files) {
	gchar* _tmp0_ = NULL;
	gchar* cmd;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GAppInfoCreateFlags flags;
	const gchar* _tmp9_ = NULL;
	GAppInfo* _tmp10_ = NULL;
	GAppInfo* _tmp11_;
	GAppInfo* app;
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	_tmp0_ = g_strdup_printf ("deja-dup %s", args);
	cmd = _tmp0_;
	_tmp1_ = g_find_program_in_path ("ionice");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strconcat ("ionice -c2 -n7 ", cmd, NULL);
		_g_free0 (cmd);
		cmd = _tmp4_;
	}
	_tmp5_ = g_find_program_in_path ("nice");
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strconcat ("nice ", cmd, NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
	}
	flags = G_APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION | G_APP_INFO_CREATE_SUPPORTS_URIS;
	_tmp9_ = _ ("Déjà Dup Backup Tool");
	_tmp10_ = g_app_info_create_from_commandline (cmd, _tmp9_, flags, &_inner_error_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	app = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch17_g_error;
	}
	g_app_info_launch (app, files, ctx, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		goto __catch17_g_error;
	}
	_g_object_unref0 (app);
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("CommonUtils.vala:92: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (cmd);
}


GDateTime* deja_dup_most_recent_scheduled_date (GTimeSpan period) {
	GDateTime* result = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* epoch;
	GDateTime* _tmp1_ = NULL;
	GDateTime* cur_date;
	GTimeSpan _tmp2_;
	GTimeSpan between;
	GTimeSpan mod;
	GDateTime* _tmp3_ = NULL;
	_tmp0_ = g_date_time_new_from_unix_local ((gint64) 0);
	epoch = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	cur_date = _tmp1_;
	_tmp2_ = g_date_time_difference (cur_date, epoch);
	between = _tmp2_;
	mod = between % period;
	_tmp3_ = g_date_time_add (cur_date, (GTimeSpan) ((-1) * mod));
	result = _tmp3_;
	_g_date_time_unref0 (cur_date);
	_g_date_time_unref0 (epoch);
	return result;
}


gchar* deja_dup_last_run_date (DejaDupTimestampType type) {
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* last_run_string;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	last_run_string = NULL;
	if (type == DEJA_DUP_TIMESTAMP_TYPE_BACKUP) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_BACKUP_KEY);
		_g_free0 (last_run_string);
		last_run_string = _tmp1_;
	} else {
		if (type == DEJA_DUP_TIMESTAMP_TYPE_RESTORE) {
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RESTORE_KEY);
			_g_free0 (last_run_string);
			last_run_string = _tmp2_;
		}
	}
	if (last_run_string == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (last_run_string, "") == 0;
	}
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RUN_KEY);
		_g_free0 (last_run_string);
		last_run_string = _tmp4_;
	}
	result = last_run_string;
	_g_object_unref0 (settings);
	return result;
}


GTimeSpan deja_dup_get_day (void) {
	GTimeSpan result = 0LL;
	gboolean _tmp0_;
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		result = G_TIME_SPAN_SECOND * ((GTimeSpan) 10);
		return result;
	} else {
		result = G_TIME_SPAN_DAY;
		return result;
	}
}


GDateTime* deja_dup_next_run_date (void) {
	GDateTime* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gboolean _tmp1_;
	gboolean periodic;
	gint _tmp2_;
	gint period_days;
	gchar* _tmp3_ = NULL;
	gchar* last_run_string;
	GTimeVal last_run_tval = {0};
	gboolean _tmp5_;
	GTimeSpan _tmp7_;
	GTimeSpan period;
	GDateTime* _tmp8_ = NULL;
	GDateTime* last_run;
	GDateTime* _tmp9_ = NULL;
	GDateTime* last_scheduled;
	gint _tmp10_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_PERIODIC_KEY);
	periodic = _tmp1_;
	_tmp2_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_PERIODIC_PERIOD_KEY);
	period_days = _tmp2_;
	_tmp3_ = deja_dup_last_run_date (DEJA_DUP_TIMESTAMP_TYPE_BACKUP);
	last_run_string = _tmp3_;
	if (!periodic) {
		result = NULL;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	if (g_strcmp0 (last_run_string, "") == 0) {
		GDateTime* _tmp4_ = NULL;
		_tmp4_ = g_date_time_new_now_local ();
		result = _tmp4_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	g_get_current_time (&last_run_tval);
	_tmp5_ = g_time_val_from_iso8601 (last_run_string, &last_run_tval);
	if (!_tmp5_) {
		GDateTime* _tmp6_ = NULL;
		_tmp6_ = g_date_time_new_now_local ();
		result = _tmp6_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp7_ = deja_dup_get_day ();
	period = ((GTimeSpan) period_days) * _tmp7_;
	_tmp8_ = g_date_time_new_from_timeval_local (&last_run_tval);
	last_run = _tmp8_;
	_tmp9_ = deja_dup_most_recent_scheduled_date (period);
	last_scheduled = _tmp9_;
	_tmp10_ = g_date_time_compare (last_scheduled, last_run);
	if (_tmp10_ <= 0) {
		GDateTime* _tmp11_ = NULL;
		_tmp11_ = g_date_time_add (last_scheduled, period);
		_g_date_time_unref0 (last_scheduled);
		last_scheduled = _tmp11_;
	}
	result = last_scheduled;
	_g_date_time_unref0 (last_run);
	_g_free0 (last_run_string);
	_g_object_unref0 (settings);
	return result;
}


gint deja_dup_get_prompt_delay (void) {
	gint result = 0;
	GTimeSpan span;
	gboolean _tmp0_;
	span = (GTimeSpan) 0;
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		span = (GTimeSpan) (G_TIME_SPAN_MINUTE * 2);
	} else {
		span = (GTimeSpan) (G_TIME_SPAN_DAY * 30);
	}
	result = (gint) (span / G_TIME_SPAN_SECOND);
	return result;
}


gboolean deja_dup_has_seen_settings (void) {
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp2_ = deja_dup_last_run_date (DEJA_DUP_TIMESTAMP_TYPE_NONE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_WELCOMED_KEY);
		_tmp1_ = _tmp5_;
	}
	result = _tmp1_;
	_g_object_unref0 (settings);
	return result;
}


void deja_dup_make_prompt_check (void) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* prompt;
	GTimeVal last_run_tval = {0};
	gboolean _tmp3_;
	GDateTime* _tmp4_ = NULL;
	GDateTime* last_run;
	gint _tmp5_;
	GDateTime* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	GDateTime* now;
	gint _tmp8_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_PROMPT_CHECK_KEY);
	prompt = _tmp1_;
	if (g_strcmp0 (prompt, "disabled") == 0) {
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return;
	} else {
		if (g_strcmp0 (prompt, "") == 0) {
			deja_dup_update_prompt_time (FALSE);
			_g_free0 (prompt);
			_g_object_unref0 (settings);
			return;
		} else {
			gboolean _tmp2_;
			_tmp2_ = deja_dup_has_seen_settings ();
			if (_tmp2_) {
				_g_free0 (prompt);
				_g_object_unref0 (settings);
				return;
			}
		}
	}
	g_get_current_time (&last_run_tval);
	_tmp3_ = g_time_val_from_iso8601 (prompt, &last_run_tval);
	if (!_tmp3_) {
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return;
	}
	_tmp4_ = g_date_time_new_from_timeval_local (&last_run_tval);
	last_run = _tmp4_;
	_tmp5_ = deja_dup_get_prompt_delay ();
	_tmp6_ = g_date_time_add_seconds (last_run, (gdouble) _tmp5_);
	_g_date_time_unref0 (last_run);
	last_run = _tmp6_;
	_tmp7_ = g_date_time_new_now_local ();
	now = _tmp7_;
	_tmp8_ = g_date_time_compare (last_run, now);
	if (_tmp8_ <= 0) {
		deja_dup_run_deja_dup ("--prompt", NULL, NULL);
	}
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (last_run);
	_g_free0 (prompt);
	_g_object_unref0 (settings);
}


void deja_dup_update_prompt_time (gboolean cancel) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* cur_time_str = NULL;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_PROMPT_CHECK_KEY);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "disabled") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		_g_object_unref0 (settings);
		return;
	}
	if (cancel) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("disabled");
		_g_free0 (cur_time_str);
		cur_time_str = _tmp4_;
	} else {
		GTimeVal cur_time = {0};
		gchar* _tmp5_ = NULL;
		g_get_current_time (&cur_time);
		g_get_current_time (&cur_time);
		_tmp5_ = g_time_val_to_iso8601 (&cur_time);
		_g_free0 (cur_time_str);
		cur_time_str = _tmp5_;
	}
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_PROMPT_CHECK_KEY, cur_time_str);
	_g_free0 (cur_time_str);
	_g_object_unref0 (settings);
}


gchar* deja_dup_get_trash_path (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "Trash", NULL);
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch18_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch18_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* deja_dup_get_folder_key (DejaDupSimpleSettings* settings, const gchar* key) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* folder;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_settings_get_string ((GSettings*) settings, key);
	folder = _tmp0_;
	_tmp1_ = string_contains (folder, "$HOSTNAME");
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = g_get_host_name ();
		_tmp3_ = string_replace (folder, "$HOSTNAME", _tmp2_);
		_g_free0 (folder);
		folder = _tmp3_;
		deja_dup_simple_settings_set_string (settings, key, folder);
	}
	_tmp4_ = g_str_has_prefix (folder, "/");
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = string_substring (folder, (glong) 1, (glong) (-1));
		_g_free0 (folder);
		folder = _tmp5_;
	}
	result = folder;
	return result;
}


GFile* deja_dup_parse_dir (const gchar* dir) {
	GFile* result = NULL;
	gchar* _tmp0_;
	gchar* s;
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = g_strdup (dir);
	s = _tmp0_;
	if (g_strcmp0 (s, "$HOME") == 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (s);
		s = _tmp2_;
	} else {
		if (g_strcmp0 (s, "$DESKTOP") == 0) {
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (s);
			s = _tmp4_;
		} else {
			if (g_strcmp0 (s, "$DOCUMENTS") == 0) {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (s);
				s = _tmp6_;
			} else {
				if (g_strcmp0 (s, "$DOWNLOAD") == 0) {
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_;
					_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (s);
					s = _tmp8_;
				} else {
					if (g_strcmp0 (s, "$MUSIC") == 0) {
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp9_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (s);
						s = _tmp10_;
					} else {
						if (g_strcmp0 (s, "$PICTURES") == 0) {
							const gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							_tmp11_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
							_tmp12_ = g_strdup (_tmp11_);
							_g_free0 (s);
							s = _tmp12_;
						} else {
							if (g_strcmp0 (s, "$PUBLIC_SHARE") == 0) {
								const gchar* _tmp13_ = NULL;
								gchar* _tmp14_;
								_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
								_tmp14_ = g_strdup (_tmp13_);
								_g_free0 (s);
								s = _tmp14_;
							} else {
								if (g_strcmp0 (s, "$TEMPLATES") == 0) {
									const gchar* _tmp15_ = NULL;
									gchar* _tmp16_;
									_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
									_tmp16_ = g_strdup (_tmp15_);
									_g_free0 (s);
									s = _tmp16_;
								} else {
									if (g_strcmp0 (s, "$TRASH") == 0) {
										gchar* _tmp17_ = NULL;
										_tmp17_ = deja_dup_get_trash_path ();
										_g_free0 (s);
										s = _tmp17_;
									} else {
										if (g_strcmp0 (s, "$VIDEOS") == 0) {
											const gchar* _tmp18_ = NULL;
											gchar* _tmp19_;
											_tmp18_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
											_tmp19_ = g_strdup (_tmp18_);
											_g_free0 (s);
											s = _tmp19_;
										} else {
											gboolean _tmp20_ = FALSE;
											gchar* _tmp21_ = NULL;
											gchar* _tmp22_;
											gboolean _tmp23_;
											_tmp21_ = g_uri_parse_scheme (s);
											_tmp22_ = _tmp21_;
											_tmp23_ = _tmp22_ == NULL;
											_g_free0 (_tmp22_);
											if (_tmp23_) {
												gboolean _tmp24_;
												_tmp24_ = g_path_is_absolute (s);
												_tmp20_ = !_tmp24_;
											} else {
												_tmp20_ = FALSE;
											}
											if (_tmp20_) {
												const gchar* _tmp25_ = NULL;
												gchar* _tmp26_ = NULL;
												_tmp25_ = g_get_home_dir ();
												_tmp26_ = g_build_filename (_tmp25_, s, NULL);
												_g_free0 (s);
												s = _tmp26_;
											} else {
												GFile* _tmp27_ = NULL;
												GFile* _tmp28_;
												_tmp27_ = g_file_parse_name (s);
												_tmp28_ = _g_object_ref0 (_tmp27_);
												result = _tmp28_;
												_g_free0 (s);
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (s != NULL) {
		GFile* _tmp29_ = NULL;
		_tmp29_ = g_file_new_for_path (s);
		result = _tmp29_;
		_g_free0 (s);
		return result;
	} else {
		result = NULL;
		_g_free0 (s);
		return result;
	}
	_g_free0 (s);
}


static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


GFile** deja_dup_parse_dir_list (const gchar** dirs, int dirs_length1, int* result_length1) {
	GFile** result = NULL;
	GFile** _tmp0_ = NULL;
	GFile** rv;
	gint rv_length1;
	gint _rv_size_;
	GFile** _tmp4_;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	rv = _tmp0_;
	rv_length1 = 0;
	_rv_size_ = 0;
	{
		const gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = dirs;
		s_collection_length1 = dirs_length1;
		for (s_it = 0; s_it < dirs_length1; s_it = s_it + 1) {
			gchar* _tmp1_;
			gchar* s;
			_tmp1_ = g_strdup ((gchar*) s_collection[s_it]);
			s = _tmp1_;
			{
				GFile* _tmp2_ = NULL;
				GFile* f;
				_tmp2_ = deja_dup_parse_dir (s);
				f = _tmp2_;
				if (f != NULL) {
					GFile* _tmp3_;
					_tmp3_ = _g_object_ref0 (f);
					_vala_array_add1 (&rv, &rv_length1, &_rv_size_, _tmp3_);
				}
				_g_object_unref0 (f);
				_g_free0 (s);
			}
		}
	}
	_tmp4_ = rv;
	if (result_length1) {
		*result_length1 = rv_length1;
	}
	result = _tmp4_;
	return result;
}


void deja_dup_set_settings_read_only (gboolean ro) {
	deja_dup_settings_read_only = ro;
	if (deja_dup_settings_read_only) {
		GHashTable* _tmp0_ = NULL;
		_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
		_g_hash_table_unref0 (deja_dup_settings_table);
		deja_dup_settings_table = _tmp0_;
	} else {
		_g_hash_table_unref0 (deja_dup_settings_table);
		deja_dup_settings_table = NULL;
	}
}


DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir) {
	DejaDupSimpleSettings* result = NULL;
	gchar* _tmp0_;
	gchar* schema;
	gboolean _tmp1_ = FALSE;
	DejaDupSimpleSettings* rv = NULL;
	_tmp0_ = g_strdup ("org.gnome.DejaDup");
	schema = _tmp0_;
	if (subdir != NULL) {
		_tmp1_ = g_strcmp0 (subdir, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_strconcat (".", subdir, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (schema, _tmp3_, NULL);
		_g_free0 (schema);
		schema = _tmp4_;
		_g_free0 (_tmp3_);
	}
	if (deja_dup_settings_read_only) {
		gconstpointer _tmp5_ = NULL;
		DejaDupSimpleSettings* _tmp6_;
		_tmp5_ = g_hash_table_lookup (deja_dup_settings_table, schema);
		_tmp6_ = _g_object_ref0 ((DejaDupSimpleSettings*) _tmp5_);
		_g_object_unref0 (rv);
		rv = _tmp6_;
		if (rv == NULL) {
			DejaDupSimpleSettings* _tmp7_ = NULL;
			gchar* _tmp8_;
			DejaDupSimpleSettings* _tmp9_;
			_tmp7_ = deja_dup_simple_settings_new (schema, TRUE);
			_g_object_unref0 (rv);
			rv = _tmp7_;
			g_settings_delay ((GSettings*) rv);
			_tmp8_ = g_strdup (schema);
			_tmp9_ = _g_object_ref0 (rv);
			g_hash_table_insert (deja_dup_settings_table, _tmp8_, _tmp9_);
		}
	} else {
		DejaDupSimpleSettings* _tmp10_ = NULL;
		_tmp10_ = deja_dup_simple_settings_new (schema, FALSE);
		_g_object_unref0 (rv);
		rv = _tmp10_;
	}
	result = rv;
	_g_free0 (schema);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


void deja_dup_convert_ssh_to_file (void) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* backend;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_BACKEND_KEY);
	backend = _tmp1_;
	if (g_strcmp0 (backend, "ssh") == 0) {
		DejaDupSimpleSettings* _tmp2_ = NULL;
		DejaDupSimpleSettings* ssh_settings;
		gchar* _tmp3_ = NULL;
		gchar* server;
		gboolean _tmp4_ = FALSE;
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_BACKEND_KEY, "file");
		_tmp2_ = deja_dup_get_settings ("SSH");
		ssh_settings = _tmp2_;
		_tmp3_ = g_settings_get_string ((GSettings*) ssh_settings, DEJA_DUP_SSH_SERVER_KEY);
		server = _tmp3_;
		if (server != NULL) {
			_tmp4_ = g_strcmp0 (server, "") != 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gchar* _tmp5_ = NULL;
			gchar* username;
			gint _tmp6_;
			gint port;
			gchar* _tmp7_ = NULL;
			gchar* directory;
			gchar* _tmp8_;
			gchar* gio_uri;
			gboolean _tmp9_ = FALSE;
			gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp20_ = FALSE;
			DejaDupSimpleSettings* _tmp27_ = NULL;
			DejaDupSimpleSettings* file_settings;
			_tmp5_ = g_settings_get_string ((GSettings*) ssh_settings, DEJA_DUP_SSH_USERNAME_KEY);
			username = _tmp5_;
			_tmp6_ = g_settings_get_int ((GSettings*) ssh_settings, DEJA_DUP_SSH_PORT_KEY);
			port = _tmp6_;
			_tmp7_ = g_settings_get_string ((GSettings*) ssh_settings, DEJA_DUP_SSH_DIRECTORY_KEY);
			directory = _tmp7_;
			_tmp8_ = g_strdup ("ssh://");
			gio_uri = _tmp8_;
			if (username != NULL) {
				_tmp9_ = g_strcmp0 (username, "") != 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp10_ = g_strconcat (username, "@", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (gio_uri, _tmp11_, NULL);
				_g_free0 (gio_uri);
				gio_uri = _tmp12_;
				_g_free0 (_tmp11_);
			}
			_tmp13_ = g_strconcat (gio_uri, server, NULL);
			_g_free0 (gio_uri);
			gio_uri = _tmp13_;
			if (port > 0) {
				_tmp14_ = port != 22;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = g_strdup_printf ("%i", port);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (":", _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (gio_uri, _tmp18_, NULL);
				_g_free0 (gio_uri);
				gio_uri = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
			}
			if (directory == NULL) {
				_tmp20_ = TRUE;
			} else {
				_tmp20_ = g_strcmp0 (directory, "") == 0;
			}
			if (_tmp20_) {
				gchar* _tmp21_;
				_tmp21_ = g_strconcat (gio_uri, "/", NULL);
				_g_free0 (gio_uri);
				gio_uri = _tmp21_;
			} else {
				gchar _tmp22_;
				_tmp22_ = string_get (directory, (glong) 0);
				if (_tmp22_ != '/') {
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp23_ = g_strconcat ("/", directory, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (gio_uri, _tmp24_, NULL);
					_g_free0 (gio_uri);
					gio_uri = _tmp25_;
					_g_free0 (_tmp24_);
				} else {
					gchar* _tmp26_;
					_tmp26_ = g_strconcat (gio_uri, directory, NULL);
					_g_free0 (gio_uri);
					gio_uri = _tmp26_;
				}
			}
			_tmp27_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
			file_settings = _tmp27_;
			deja_dup_simple_settings_set_string (file_settings, DEJA_DUP_FILE_PATH_KEY, gio_uri);
			_g_object_unref0 (file_settings);
			_g_free0 (gio_uri);
			_g_free0 (directory);
			_g_free0 (username);
		}
		_g_free0 (server);
		_g_object_unref0 (ssh_settings);
	}
	_g_free0 (backend);
	_g_object_unref0 (settings);
}


void deja_dup_convert_s3_folder_to_hostname (void) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	DejaDupSimpleSettings* _tmp1_ = NULL;
	DejaDupSimpleSettings* s3_settings;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	s3_settings = _tmp1_;
	_tmp4_ = g_settings_get_string ((GSettings*) s3_settings, DEJA_DUP_S3_FOLDER_KEY);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = g_settings_get_string ((GSettings*) s3_settings, DEJA_DUP_S3_FOLDER_KEY);
		_tmp8_ = _tmp7_;
		_tmp3_ = g_strcmp0 (_tmp8_, "/") == 0;
		_g_free0 (_tmp8_);
	}
	if (_tmp3_) {
		gboolean _tmp9_ = FALSE;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = deja_dup_backend_get_default_type ();
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strcmp0 (_tmp11_, "s3") != 0;
		_g_free0 (_tmp11_);
		if (_tmp12_) {
			_tmp9_ = TRUE;
		} else {
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RUN_KEY);
			_tmp14_ = _tmp13_;
			_tmp9_ = g_strcmp0 (_tmp14_, "") == 0;
			_g_free0 (_tmp14_);
		}
		_tmp2_ = _tmp9_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		deja_dup_simple_settings_set_string (s3_settings, DEJA_DUP_S3_FOLDER_KEY, "$HOSTNAME");
	}
	_g_object_unref0 (s3_settings);
	_g_object_unref0 (settings);
}


gboolean deja_dup_meet_requirements (gchar** header, gchar** msg) {
	gchar* _header = NULL;
	gchar* _msg = NULL;
	gboolean result = FALSE;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp4_ = deja_dup_duplicity_info_check_duplicity_version (_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (_header);
	_header = _tmp2_;
	_g_free0 (_msg);
	_msg = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	if (header) {
		*header = _header;
	} else {
		_g_free0 (_header);
	}
	if (msg) {
		*msg = _msg;
	} else {
		_g_free0 (_msg);
	}
	return result;
}


gboolean deja_dup_initialize (gchar** header, gchar** msg) {
	gchar* _header = NULL;
	gchar* _msg = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	DejaDupBackend* _tmp3_ = NULL;
	DejaDupBackend* unused_backend;
	_tmp2_ = deja_dup_meet_requirements (&_tmp0_, &_tmp1_);
	_g_free0 (_header);
	_header = _tmp0_;
	_g_free0 (_msg);
	_msg = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		if (header) {
			*header = _header;
		} else {
			_g_free0 (_header);
		}
		if (msg) {
			*msg = _msg;
		} else {
			_g_free0 (_msg);
		}
		return result;
	}
	deja_dup_convert_ssh_to_file ();
	deja_dup_convert_s3_folder_to_hostname ();
	_tmp3_ = deja_dup_backend_get_default ();
	unused_backend = _tmp3_;
	_g_object_unref0 (unused_backend);
	unused_backend = NULL;
	result = TRUE;
	_g_object_unref0 (unused_backend);
	if (header) {
		*header = _header;
	} else {
		_g_free0 (_header);
	}
	if (msg) {
		*msg = _msg;
	} else {
		_g_free0 (_msg);
	}
	return result;
}


void deja_dup_i18n_setup (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* localedir;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* language;
	gboolean _tmp6_ = FALSE;
	_tmp0_ = g_getenv ("DEJA_DUP_LOCALEDIR");
	_tmp1_ = g_strdup (_tmp0_);
	localedir = _tmp1_;
	if (localedir == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (localedir, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (LOCALE_DIR);
		_g_free0 (localedir);
		localedir = _tmp3_;
	}
	_tmp4_ = g_getenv ("DEJA_DUP_LANGUAGE");
	_tmp5_ = g_strdup (_tmp4_);
	language = _tmp5_;
	if (language != NULL) {
		_tmp6_ = g_strcmp0 (language, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		g_setenv ("LANGUAGE", language, TRUE);
	}
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, localedir);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_g_free0 (language);
	_g_free0 (localedir);
}


gchar* deja_dup_get_file_desc (GFile* file) {
	gchar* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* info;
	gboolean _tmp1_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* desc;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	_tmp1_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION);
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		_g_object_unref0 (info);
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
		if (_tmp4_) {
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			_g_object_unref0 (info);
			return result;
		}
	}
	_g_object_unref0 (info);
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp7_ = g_file_get_parse_name (file);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_path_get_basename (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	desc = _tmp10_;
	_tmp11_ = g_file_is_native (file);
	if (!_tmp11_) {
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		DejaDupDecodedUri* _tmp14_ = NULL;
		DejaDupDecodedUri* _tmp15_;
		DejaDupDecodedUri* uri;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp12_ = g_file_get_uri (file);
		_tmp13_ = _tmp12_;
		_tmp14_ = deja_dup_decoded_uri_decode_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		uri = _tmp15_;
		if (uri != NULL) {
			_tmp17_ = uri->host != NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			_tmp16_ = g_strcmp0 (uri->host, "") != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp18_ = _ ("%1$s on %2$s");
			_tmp19_ = g_strdup_printf (_tmp18_, desc, uri->host);
			_g_free0 (desc);
			desc = _tmp19_;
		}
		_deja_dup_decoded_uri_free0 (uri);
	}
	result = desc;
	return result;
}


void deja_dup_ensure_special_paths (void) {
	if (deja_dup_home == NULL) {
		const gchar* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		_tmp0_ = g_get_home_dir ();
		_tmp1_ = g_file_new_for_path (_tmp0_);
		_g_object_unref0 (deja_dup_home);
		deja_dup_home = _tmp1_;
		_tmp2_ = deja_dup_get_trash_path ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (deja_dup_trash);
		deja_dup_trash = _tmp4_;
		_g_free0 (_tmp3_);
	}
}


gchar* deja_dup_get_display_name (GFile* f) {
	gchar* result = NULL;
	gboolean _tmp0_;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	deja_dup_ensure_special_paths ();
	_tmp0_ = g_file_has_prefix (f, deja_dup_home);
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* s;
		gint _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = g_file_get_relative_path (deja_dup_home, f);
		s = _tmp1_;
		_tmp2_ = strlen (s);
		_tmp3_ = g_filename_to_utf8 (s, (gssize) _tmp2_, NULL, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch20_g_convert_error;
			}
			_g_free0 (s);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp4_;
		_g_free0 (s);
		return result;
		goto __finally20;
		__catch20_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("CommonUtils.vala:477: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (s);
	}
	_tmp5_ = g_file_get_parse_name (f);
	result = _tmp5_;
	return result;
}


static void deja_dup_get_nickname_data_free (gpointer _data) {
	DejaDupGetNicknameData* data;
	data = _data;
	_g_object_unref0 (data->f);
	_g_free0 (data->result);
	g_slice_free (DejaDupGetNicknameData, data);
}


void deja_dup_get_nickname (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupGetNicknameData* _data_;
	_data_ = g_slice_new0 (DejaDupGetNicknameData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, deja_dup_get_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_get_nickname_data_free);
	_data_->f = _g_object_ref0 (f);
	deja_dup_get_nickname_co (_data_);
}


gchar* deja_dup_get_nickname_finish (GAsyncResult* _res_) {
	gchar* result;
	DejaDupGetNicknameData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void deja_dup_get_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupGetNicknameData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_get_nickname_co (data);
}


static gboolean deja_dup_get_nickname_co (DejaDupGetNicknameData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	deja_dup_ensure_special_paths ();
	data->_tmp0_ = g_file_equal (data->f, deja_dup_home);
	if (data->_tmp0_) {
		data->_state_ = 1;
		g_file_query_info_async (data->f, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, deja_dup_get_nickname_ready, data);
		return FALSE;
		_state_1:
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
		data->info = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Home (%s)");
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_file_info_get_display_name (data->info);
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_strdup_printf (data->_tmp2_, data->_tmp3_);
		_g_free0 (data->s);
		data->s = data->_tmp4_;
		_g_object_unref0 (data->info);
		goto __finally21;
		__catch21_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("CommonUtils.vala:501: %s\n", data->e->message);
			data->_tmp5_ = NULL;
			data->_tmp5_ = _ ("Home");
			data->_tmp6_ = g_strdup (data->_tmp5_);
			_g_free0 (data->s);
			data->s = data->_tmp6_;
			_g_error_free0 (data->e);
		}
		__finally21:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		data->_tmp7_ = g_file_equal (data->f, deja_dup_trash);
		if (data->_tmp7_) {
			data->_tmp8_ = NULL;
			data->_tmp8_ = _ ("Trash");
			data->_tmp9_ = g_strdup (data->_tmp8_);
			_g_free0 (data->s);
			data->s = data->_tmp9_;
		} else {
			data->_tmp10_ = NULL;
			data->_tmp10_ = deja_dup_get_display_name (data->f);
			_g_free0 (data->s);
			data->s = data->_tmp10_;
		}
	}
	data->result = data->s;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->s);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gint deja_dup_get_full_backup_threshold (void) {
	gint result = 0;
	gint threshold;
	gint max;
	gint min;
	gint scale;
	gint min_fulls;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gint _tmp1_;
	gint delete_age;
	gboolean _tmp4_;
	gboolean periodic;
	threshold = 7 * 6;
	max = 24 * 7;
	min = 4 * 7;
	scale = 12;
	min_fulls = 2;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_DELETE_AFTER_KEY);
	delete_age = _tmp1_;
	if (delete_age > 0) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = MIN (delete_age / min_fulls, max);
		_tmp3_ = MAX (_tmp2_, min);
		max = _tmp3_;
	}
	_tmp4_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_PERIODIC_KEY);
	periodic = _tmp4_;
	if (periodic) {
		gint _tmp5_;
		gint period;
		_tmp5_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_PERIODIC_PERIOD_KEY);
		period = _tmp5_;
		threshold = period * scale;
		CLAMP (threshold, min, max);
	} else {
		threshold = max;
	}
	result = threshold;
	_g_object_unref0 (settings);
	return result;
}


void deja_dup_get_full_backup_threshold_date (GDate* result) {
	GTimeVal now = {0};
	GDate date = {0};
	gint _tmp0_;
	gint days;
	g_get_current_time (&now);
	g_get_current_time (&now);
	memset (&date, 0, sizeof (GDate));
	g_date_set_time_val (&date, &now);
	_tmp0_ = deja_dup_get_full_backup_threshold ();
	days = _tmp0_;
	g_date_subtract_days (&date, (guint) days);
	*result = date;
	return;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



