/* monitor.c generated by valac 0.12.1, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <common.h>
#include <libnotify/notify.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _Monitor {
	GObject parent_instance;
	MonitorPrivate * priv;
};

struct _MonitorClass {
	GObjectClass parent_class;
};


static gpointer monitor_parent_class = NULL;
static guint monitor_timeout_id;
static guint monitor_timeout_id = 0U;
static guint monitor_netcheck_id;
static guint monitor_netcheck_id = 0U;
static GPid monitor_pid;
static GPid monitor_pid = 0;
static gboolean monitor_op_active;
static gboolean monitor_op_active = FALSE;
static gboolean monitor_reactive_check;
static gboolean monitor_reactive_check = FALSE;
static gboolean monitor_first_check;
static gboolean monitor_first_check = FALSE;
static DejaDupSimpleSettings* monitor_settings;
static DejaDupSimpleSettings* monitor_settings = NULL;
static gboolean monitor_testing_delay;
static gboolean monitor_testing_delay = TRUE;
static gboolean monitor_show_version;
static gboolean monitor_show_version = FALSE;
static NotifyNotification* monitor_note;
static NotifyNotification* monitor_note = NULL;

GType monitor_get_type (void) G_GNUC_CONST;
enum  {
	MONITOR_DUMMY_PROPERTY
};
static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner);
static void monitor_op_ended (GDBusConnection* conn, const gchar* name);
static gboolean monitor_network_check (void);
static void monitor_prepare_next_run (void);
static void monitor_network_changed (void);
static gboolean _monitor_network_check_gsource_func (gpointer self);
static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol);
static gboolean monitor_is_ready (gchar** when);
static gboolean monitor_handle_options (gint* status);
static GTimeSpan monitor_time_until (GDateTime* date);
static void monitor_close_pid (GPid child_pid, gint status);
static void monitor_notify_delay (const gchar* header, const gchar* reason);
static void _lambda0_ (NotifyNotification* n);
static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self);
static gboolean monitor_kickoff (void);
static gboolean monitor_time_until_next_run (GTimeSpan* time);
static void monitor_prepare_tomorrow (void);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static void monitor_prepare_run (GTimeSpan wait_time);
static gboolean _monitor_kickoff_gsource_func (gpointer self);
static void monitor_prepare_if_necessary (const gchar* key);
static void monitor_make_first_check (void);
static gboolean _lambda1_ (void);
static gboolean __lambda1__gsource_func (gpointer self);
static void monitor_watch_settings (void);
static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gint monitor_main (gchar** args, int args_length1);
static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static gboolean _lambda2_ (void);
static gboolean __lambda2__gsource_func (gpointer self);
Monitor* monitor_new (void);
Monitor* monitor_construct (GType object_type);
static void monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MONITOR_options[2] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, "Show version", NULL}, {NULL}};

static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	monitor_op_active = TRUE;
}


static void monitor_op_ended (GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	monitor_op_active = FALSE;
}


static gboolean monitor_network_check (void) {
	gboolean result = FALSE;
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	monitor_reactive_check = TRUE;
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		monitor_prepare_next_run ();
	}
	monitor_reactive_check = FALSE;
	result = FALSE;
	return result;
}


static gboolean _monitor_network_check_gsource_func (gpointer self) {
	gboolean result;
	result = monitor_network_check ();
	return result;
}


static void monitor_network_changed (void) {
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	if (monitor_netcheck_id > 0) {
		g_source_remove (monitor_netcheck_id);
	}
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		guint _tmp4_;
		_tmp4_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, _monitor_network_check_gsource_func, NULL, NULL);
		monitor_netcheck_id = _tmp4_;
	}
}


static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol) {
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	monitor_reactive_check = TRUE;
	monitor_prepare_next_run ();
	monitor_reactive_check = FALSE;
}


static gboolean monitor_is_ready (gchar** when) {
	gchar* _when = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	DejaDupBackend* _tmp3_ = NULL;
	DejaDupBackend* _tmp4_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	_tmp1_ = deja_dup_in_testing_mode ();
	if (_tmp1_) {
		_tmp0_ = monitor_testing_delay;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		monitor_testing_delay = FALSE;
		_tmp2_ = g_strdup ("Testing");
		_g_free0 (_when);
		_when = _tmp2_;
		result = FALSE;
		if (when) {
			*when = _when;
		} else {
			_g_free0 (_when);
		}
		return result;
	}
	_tmp3_ = deja_dup_backend_get_default ();
	_tmp4_ = _tmp3_;
	_tmp6_ = deja_dup_backend_is_ready (_tmp4_, &_tmp5_);
	_g_free0 (_when);
	_when = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	result = _tmp7_;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
}


static gboolean monitor_handle_options (gint* status) {
	gint _status = 0;
	gboolean result = FALSE;
	_status = 0;
	if (monitor_show_version) {
		g_print ("%s %s\n", "deja-dup-monitor", VERSION);
		result = FALSE;
		if (status) {
			*status = _status;
		}
		return result;
	}
	result = TRUE;
	if (status) {
		*status = _status;
	}
	return result;
}


static GTimeSpan monitor_time_until (GDateTime* date) {
	GTimeSpan result = 0LL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_;
	GTimeSpan _tmp2_;
	GTimeSpan _tmp3_;
	g_return_val_if_fail (date != NULL, 0LL);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_difference (date, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void monitor_close_pid (GPid child_pid, gint status) {
	g_spawn_close_pid (child_pid);
	monitor_pid = (GPid) 0;
}


static void _lambda0_ (NotifyNotification* n) {
	g_return_if_fail (n != NULL);
	_g_object_unref0 (monitor_note);
	monitor_note = NULL;
}


static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	_lambda0_ (_sender);
}


static void monitor_notify_delay (const gchar* header, const gchar* reason) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (header != NULL);
	g_return_if_fail (reason != NULL);
	if (monitor_note == NULL) {
		const gchar* _tmp0_ = NULL;
		NotifyNotification* _tmp1_ = NULL;
		_tmp0_ = _ ("Backup");
		notify_init (_tmp0_);
		_tmp1_ = notify_notification_new (header, reason, "deja-dup");
		_g_object_unref0 (monitor_note);
		monitor_note = _tmp1_;
		g_signal_connect (monitor_note, "closed", (GCallback) __lambda0__notify_notification_closed, NULL);
	} else {
		notify_notification_update (monitor_note, header, reason, "deja-dup");
	}
	notify_notification_show (monitor_note, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("monitor.vala:127: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff (void) {
	gboolean result = FALSE;
	GTimeSpan wait_time = 0LL;
	GTimeSpan _tmp0_;
	gboolean _tmp1_;
	gchar* when = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp1_ = monitor_time_until_next_run (&_tmp0_);
	wait_time = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (wait_time > 0) {
		monitor_prepare_next_run ();
		result = FALSE;
		return result;
	}
	if (!monitor_reactive_check) {
		monitor_prepare_tomorrow ();
	}
	_tmp3_ = monitor_is_ready (&_tmp2_);
	_g_free0 (when);
	when = _tmp2_;
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		g_debug ("monitor.vala:153: Postponing the backup.");
		if (!monitor_reactive_check) {
			_tmp4_ = when != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("Scheduled backup delayed");
			monitor_notify_delay (_tmp5_, when);
		}
		result = FALSE;
		_g_free0 (when);
		return result;
	}
	if (monitor_note != NULL) {
		notify_notification_close (monitor_note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("monitor.vala:164: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (monitor_note);
		monitor_note = NULL;
	}
	if (monitor_pid == ((GPid) 0)) {
		_tmp6_ = !monitor_op_active;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar** _tmp7_ = NULL;
		gchar** argv;
		gint argv_length1;
		gint _argv_size_;
		gint i;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gboolean _tmp10_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gboolean _tmp16_;
		gint _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gint _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
		gboolean _tmp37_;
		_tmp7_ = g_new0 (gchar*, 8 + 1);
		argv = _tmp7_;
		argv_length1 = 8;
		_argv_size_ = 8;
		i = 0;
		g_debug ("monitor.vala:175: Running automatic backup.");
		_tmp8_ = g_find_program_in_path ("nice");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			gint _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_tmp12_ = g_strdup ("nice");
			_tmp13_ = _tmp12_;
			_g_free0 (argv[_tmp11_]);
			argv[_tmp11_] = _tmp13_;
		}
		_tmp14_ = g_find_program_in_path ("ionice");
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ != NULL;
		_g_free0 (_tmp15_);
		if (_tmp16_) {
			gint _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp17_ = i;
			i = _tmp17_ + 1;
			_tmp18_ = g_strdup ("ionice");
			_tmp19_ = _tmp18_;
			_g_free0 (argv[_tmp17_]);
			argv[_tmp17_] = _tmp19_;
			_tmp20_ = i;
			i = _tmp20_ + 1;
			_tmp21_ = g_strdup ("-c2");
			_tmp22_ = _tmp21_;
			_g_free0 (argv[_tmp20_]);
			argv[_tmp20_] = _tmp22_;
			_tmp23_ = i;
			i = _tmp23_ + 1;
			_tmp24_ = g_strdup ("-n7");
			_tmp25_ = _tmp24_;
			_g_free0 (argv[_tmp23_]);
			argv[_tmp23_] = _tmp25_;
		}
		_tmp26_ = i;
		i = _tmp26_ + 1;
		_tmp27_ = g_strdup ("deja-dup");
		_tmp28_ = _tmp27_;
		_g_free0 (argv[_tmp26_]);
		argv[_tmp26_] = _tmp28_;
		_tmp29_ = i;
		i = _tmp29_ + 1;
		_tmp30_ = g_strdup ("--backup");
		_tmp31_ = _tmp30_;
		_g_free0 (argv[_tmp29_]);
		argv[_tmp29_] = _tmp31_;
		_tmp32_ = i;
		i = _tmp32_ + 1;
		_tmp33_ = g_strdup ("--auto");
		_tmp34_ = _tmp33_;
		_g_free0 (argv[_tmp32_]);
		argv[_tmp32_] = _tmp34_;
		_tmp35_ = i;
		i = _tmp35_ + 1;
		_tmp36_ = NULL;
		_g_free0 (argv[_tmp35_]);
		argv[_tmp35_] = _tmp36_;
		_tmp37_ = deja_dup_in_testing_mode ();
		if (_tmp37_) {
			deja_dup_update_last_run_timestamp (DEJA_DUP_TIMESTAMP_TYPE_BACKUP);
		} else {
			GPid _tmp38_;
			g_spawn_async (NULL, argv, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp38_, &_inner_error_);
			monitor_pid = _tmp38_;
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch2_g_error;
			}
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, monitor_pid, _monitor_close_pid_gchild_watch_func, NULL, NULL);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("monitor.vala:208: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:212: Not rerunning deja-dup, already doing so.");
	}
	result = FALSE;
	_g_free0 (when);
	return result;
}


static gboolean monitor_time_until_next_run (GTimeSpan* time) {
	GTimeSpan _time = 0LL;
	gboolean result = FALSE;
	GDateTime* _tmp0_ = NULL;
	GDateTime* next_date;
	GTimeSpan _tmp1_;
	_tmp0_ = deja_dup_next_run_date ();
	next_date = _tmp0_;
	if (next_date == NULL) {
		g_debug ("monitor.vala:221: Automatic backups disabled.  Not scheduling a backup" \
".");
		result = FALSE;
		_g_date_time_unref0 (next_date);
		if (time) {
			*time = _time;
		}
		return result;
	}
	_tmp1_ = monitor_time_until (next_date);
	_time = _tmp1_;
	result = TRUE;
	_g_date_time_unref0 (next_date);
	if (time) {
		*time = _time;
	}
	return result;
}


static gboolean _monitor_kickoff_gsource_func (gpointer self) {
	gboolean result;
	result = monitor_kickoff ();
	return result;
}


static void monitor_prepare_run (GTimeSpan wait_time) {
	GTimeSpan secs;
	gboolean _tmp0_ = FALSE;
	if (monitor_timeout_id != 0) {
		g_source_remove (monitor_timeout_id);
	}
	secs = (GTimeSpan) ((wait_time / G_TIME_SPAN_SECOND) + 1);
	if (wait_time > 0) {
		_tmp0_ = secs > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp1_;
		g_debug ("monitor.vala:237: Waiting %ld seconds until next backup.", (glong) secs);
		_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) secs, _monitor_kickoff_gsource_func, NULL, NULL);
		monitor_timeout_id = _tmp1_;
	} else {
		g_debug ("monitor.vala:241: Late by %ld seconds.  Backing up now.", (glong) (secs * (-1)));
		monitor_kickoff ();
	}
}


static void monitor_prepare_tomorrow (void) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* now;
	GTimeSpan _tmp1_;
	GDateTime* _tmp2_ = NULL;
	GDateTime* tomorrow;
	GTimeSpan _tmp3_;
	GTimeSpan time;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = deja_dup_get_day ();
	_tmp2_ = g_date_time_add (now, _tmp1_);
	tomorrow = _tmp2_;
	_tmp3_ = monitor_time_until (tomorrow);
	time = _tmp3_;
	monitor_prepare_run (time);
	_g_date_time_unref0 (tomorrow);
	_g_date_time_unref0 (now);
}


static void monitor_prepare_next_run (void) {
	GTimeSpan wait_time = 0LL;
	GTimeSpan _tmp0_;
	gboolean _tmp1_;
	if (!monitor_first_check) {
		return;
	}
	_tmp1_ = monitor_time_until_next_run (&_tmp0_);
	wait_time = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	monitor_prepare_run (wait_time);
}


static void monitor_prepare_if_necessary (const gchar* key) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, DEJA_DUP_LAST_BACKUP_KEY) == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_KEY) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_PERIOD_KEY) == 0;
	}
	if (_tmp0_) {
		monitor_prepare_next_run ();
	}
}


static gboolean _lambda1_ (void) {
	gboolean result = FALSE;
	deja_dup_make_prompt_check ();
	result = TRUE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ ();
	return result;
}


static void monitor_make_first_check (void) {
	gint _tmp0_;
	monitor_first_check = TRUE;
	deja_dup_make_prompt_check ();
	_tmp0_ = deja_dup_get_prompt_delay ();
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, __lambda1__gsource_func, NULL, NULL);
	monitor_prepare_next_run ();
}


static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	monitor_prepare_if_necessary (key);
}


static void monitor_watch_settings (void) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	_tmp0_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (monitor_settings);
	monitor_settings = _tmp0_;
	g_signal_connect ((GSettings*) monitor_settings, "changed", (GCallback) _monitor_prepare_if_necessary_g_settings_changed, NULL);
}


static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	monitor_network_changed ();
}


static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	monitor_op_started (connection, name, name_owner);
}


static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	monitor_op_ended (connection, name);
}


static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	monitor_volume_added (_sender, volume);
}


static gboolean _lambda2_ (void) {
	gboolean result = FALSE;
	monitor_make_first_check ();
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ ();
	return result;
}


static gint monitor_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* context;
	gint status = 0;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	DejaDupNetwork* _tmp7_ = NULL;
	DejaDupNetwork* _tmp8_;
	GVolumeMonitor* _tmp9_ = NULL;
	GVolumeMonitor* mon;
	GMainLoop* _tmp10_ = NULL;
	GMainLoop* loop;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	deja_dup_i18n_setup ();
	_tmp0_ = _ ("Backup Monitor");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_option_context_new ("");
	context = _tmp1_;
	g_option_context_add_main_entries (context, MONITOR_options, GETTEXT_PACKAGE);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp3_ = _tmp2_;
		g_printerr ("%s\n\n%s", e->message, _tmp3_);
		_g_free0 (_tmp3_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = monitor_handle_options (&_tmp4_);
	status = _tmp4_;
	if (!_tmp5_) {
		result = status;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp6_ = deja_dup_initialize (NULL, NULL);
	if (!_tmp6_) {
		result = 1;
		_g_option_context_free0 (context);
		return result;
	}
	deja_dup_network_ensure_status (NULL, NULL);
	_tmp7_ = deja_dup_network_get ();
	_tmp8_ = _tmp7_;
	g_signal_connect ((GObject*) _tmp8_, "notify::connected", (GCallback) _monitor_network_changed_g_object_notify, NULL);
	_g_object_unref0 (_tmp8_);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_monitor_op_started_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_started_gbus_name_appeared_callback, NULL, NULL)), (GClosure*) ((_monitor_op_ended_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_ended_gbus_name_vanished_callback, NULL, NULL)));
	_tmp9_ = g_volume_monitor_get ();
	mon = _tmp9_;
	g_object_ref ((GObject*) mon);
	g_signal_connect (mon, "volume-added", (GCallback) _monitor_volume_added_g_volume_monitor_volume_added, NULL);
	_tmp10_ = g_main_loop_new (NULL, FALSE);
	loop = _tmp10_;
	_tmp11_ = deja_dup_in_testing_mode ();
	if (_tmp11_) {
		monitor_make_first_check ();
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, __lambda2__gsource_func, NULL, NULL);
	}
	monitor_watch_settings ();
	g_main_loop_run (loop);
	result = 0;
	_g_main_loop_unref0 (loop);
	_g_object_unref0 (mon);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


Monitor* monitor_construct (GType object_type) {
	Monitor * self = NULL;
	self = (Monitor*) g_object_new (object_type, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = MONITOR (obj);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static volatile gsize monitor_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		GType monitor_type_id;
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
		g_once_init_leave (&monitor_type_id__volatile, monitor_type_id);
	}
	return monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



