/************************************/
/* DeskMenu (c) Ken Lynch, May 2001 */
/* Distributed under the GPL        */
/* See LISENCE for more details     */
/************************************/

#include "deskmenu.h"

int confirm=False;

void run_program(GtkWidget *widget, char *cmd)
{
  pid_t pid;
  
#ifdef DEBUG
  printf("run_program\n");
#endif
  
  pid=fork();

  switch(pid)
  {
  case 0:
    execlp("/bin/sh", "sh", "-c", cmd, NULL);
    fprintf(stderr, "%s: Failed to run command %s\n", PROGNAME, cmd);
    exit(1);
    break;
  case -1:
    fprintf(stderr, "%s: Fork failed.\n", PROGNAME);
    break;
  }
}

void ok_click(GtkWidget *w)
{
  confirm=True;
  gtk_main_quit();
}

void quit(GtkWidget *widget)
{
  GtkWidget *dialog, *label, *ok, *cancel;

#ifdef DEBUG
  printf("quit\n");
#endif

  dialog=gtk_dialog_new();
  label=gtk_label_new("Do you really want to quit?");
  ok=gtk_button_new_with_label("Ok");
  cancel=gtk_button_new_with_label("Cancel");

  gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(ok_click), NULL);
  gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer) dialog);
 
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), ok, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), cancel, TRUE, TRUE, 0);

  gtk_container_border_width(GTK_CONTAINER(dialog), 5);
  gtk_window_set_title(GTK_WINDOW(dialog), "Confirm"); 
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, TRUE);

  gtk_widget_show_all(dialog); 
  gtk_main();
  gtk_widget_destroy(dialog);
 
  if(confirm) 
    exit(0);
}

GtkWidget *add_menu_item(GtkMenu *menu, char *label, GtkSignalFunc fn, gpointer data)
{
  GtkWidget *menu_item;

#ifdef DEBUG
  printf("add_menu_item\n");
#endif

  if(!label) menu_item=gtk_menu_item_new();
  else menu_item=gtk_menu_item_new_with_label(label);
  if(fn)
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate", fn, data);
  gtk_widget_show(menu_item);
  gtk_menu_append(menu, menu_item);
  return menu_item;
}

GtkWidget *build_menu(char *dir, char *file)
{
  GtkWidget *menu, *menu_item, *submenu=NULL;
  char buf[1024], *rc_file, *lvalue, *rvalue;
  FILE *rc;

#ifdef DEBUG
  printf("add_programs_menu\n");
#endif

  if((rc_file=malloc(strlen(dir)+strlen(file)+2))==NULL)
  {
    fprintf(stderr, "%s: Memory allocation failed in function add_programs_menu.\n", PROGNAME);
    exit(1);
  }

  menu=gtk_menu_new();
  sprintf(rc_file, "%s/%s", dir, file);

  if((rc=fopen(rc_file, "r")))
  {
    while(fgets(buf, sizeof buf, rc))
    {
      lvalue=strtok(buf, "=");
      if(lvalue)
      {
        if(!strcmp(lvalue, "menuitem"))
        {
          lvalue=strtok(NULL, ":");
          if(lvalue)
          {
            rvalue=strtok(NULL, "\n");
            if(rvalue)
            {
              add_menu_item(GTK_MENU(menu), lvalue, run_program, strdup(rvalue));
              submenu=NULL;
            }
          }
        }
        if(!strcmp(lvalue, "windowlist"))
        {
          rvalue=strtok(NULL, "\n");
          if(rvalue)
          {
            add_windows_menu(GTK_MENU(menu), rvalue);
            submenu=NULL;
          }
        }
        if(!strcmp(lvalue, "workspaces"))
        {
          rvalue=strtok(NULL, "\n");
          if(rvalue)
          {
            add_workspace_menu(GTK_MENU(menu), rvalue);
            submenu=NULL;
          }
        }
        if(!strcmp(lvalue, "divider"))
        {
          add_menu_item(GTK_MENU(menu), NULL, NULL, NULL);
          submenu=NULL;
        }
          
        if(!strcmp(lvalue, "submenu"))
        {
          rvalue=strtok(NULL, "\n");
          if(rvalue)
          {
            submenu=gtk_menu_new();
            menu_item=add_menu_item(GTK_MENU(menu), rvalue, NULL, NULL);
            gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), submenu);
          }
        }
        if(!strcmp(lvalue, "submenuitem"))
        {
          lvalue=strtok(NULL, ":");
          if(lvalue)
          {
            rvalue=strtok(NULL, "\n");
            if(rvalue && submenu)
              add_menu_item(GTK_MENU(submenu), lvalue, run_program, strdup(rvalue));
          }
        }
      }
    }
  }

  if(quit_menu)
  {
    add_menu_item(GTK_MENU(menu), NULL, NULL, NULL);
    add_menu_item(GTK_MENU(menu), "Quit", GTK_SIGNAL_FUNC(quit), NULL);
  }

  gtk_signal_connect(GTK_OBJECT(menu), "deactivate", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  return menu;
}

void menu_pos(GtkMenu *m, int *x, int *y, XEvent *ev)
{
  int w, h, dw, dh;

  w=GTK_WIDGET(m)->requisition.width;
  h=GTK_WIDGET(m)->requisition.height;
  gdk_window_get_size(GDK_ROOT_PARENT(), &dw, &dh);

  *x=ev->xbutton.x;
  *y=ev->xbutton.y;

  if(*x>dw-w) *x=dw-w;
  if(*y>dh-h) *y=dh-h;
}

void popup_menu(XEvent *ev)
{
  GtkWidget *root_menu;

  root_menu=build_menu(getenv("HOME"), RCFILE);
  gtk_menu_popup(GTK_MENU(root_menu), NULL, NULL, (GtkMenuPositionFunc)menu_pos, ev, ev->xbutton.button, ev->xbutton.time);
  gtk_main();
  gtk_widget_destroy(root_menu);
}
