FIND_PROGRAM(GETTEXT_MSGMERGE_EXECUTABLE msgmerge)

FIND_PROGRAM(GETTEXT_MSGFMT_EXECUTABLE msgfmt)

FIND_PROGRAM(GETTEXT_XGETTEXT_EXECUTABLE xgettext)

MACRO(GETTEXT_POT _domain)
	SET(_potName "${_domain}.pot")

	ADD_CUSTOM_COMMAND(
		OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/${_potName}
		COMMAND ${GETTEXT_XGETTEXT_EXECUTABLE}
			-o ${CMAKE_CURRENT_BINARY_DIR}/${_potName}
			-C
			--keyword=_
			--keyword=N_
#			--keyword=q_
#			--keyword=translate:2
			--package-name=${PACKAGE}
			--package-version=${VERSION}
			--add-comments=TRANSLATORS:
			--directory=${PROJECT_SOURCE_DIR}
			--directory=${CMAKE_BINARY_DIR}
			--files-from=POTFILES.in
			--copyright-holder=Stefan\ Haller
		DEPENDS POTFILES.in
		WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
		COMMENT "Generating ${_potName}"
		VERBATIM
	)

	ADD_CUSTOM_TARGET(
		"${_domain}-pot"
		DEPENDS ${_potName}
	)
ENDMACRO(GETTEXT_POT)


MACRO(GETTEXT_MO _domain _lang)
	SET(_files)
	FOREACH(_curLang ${_lang} ${ARGN})
		SET(_source      "${CMAKE_CURRENT_SOURCE_DIR}/${_curLang}.po")
		SET(_destination "${CMAKE_CURRENT_BINARY_DIR}/${_curLang}.mo")
		ADD_CUSTOM_COMMAND(
			OUTPUT ${_destination}
			COMMAND ${GETTEXT_MSGFMT_EXECUTABLE} -o ${_destination} ${_source}
			DEPENDS ${_source}
			WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
			COMMENT "compile message catalog ${_domain}/${_curLang}.mo"
			VERBATIM
		)

		INSTALL(
			FILES ${_destination}
			DESTINATION ${DIRS_LOCALEDIR}/${_curLang}/LC_MESSAGES
			RENAME "${_domain}.mo"
		)

		SET(_files ${_files} ${_destination})
	ENDFOREACH(_curLang)

	ADD_CUSTOM_TARGET("gettext-${_domain}-mo"
	                  ALL
	                  DEPENDS ${_files})
ENDMACRO(GETTEXT_MO)


MACRO(GETTEXT_UPDATE_PO _domain _lang)
ENDMACRO(GETTEXT_UPDATE_PO)


IF (GETTEXT_MSGMERGE_EXECUTABLE AND GETTEXT_MSGFMT_EXECUTABLE  AND GETTEXT_XGETTEXT_EXECUTABLE)
   SET(GETTEXT_FOUND TRUE)
ELSE (GETTEXT_MSGMERGE_EXECUTABLE AND GETTEXT_MSGFMT_EXECUTABLE AND GETTEXT_XGETTEXT_EXECUTABLE)
   SET(GETTEXT_FOUND FALSE)
   IF (GetText_REQUIRED)
      MESSAGE(FATAL_ERROR "GetText not found")
   ENDIF (GetText_REQUIRED)
ENDIF (GETTEXT_MSGMERGE_EXECUTABLE AND GETTEXT_MSGFMT_EXECUTABLE AND GETTEXT_XGETTEXT_EXECUTABLE)



