case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting config.h (with variable substitutions)"
sed <<!GROK!THIS! >config.h -e 's!^#undef\(.*/\)\*!/\*#define\1 \*!' -e 's!^#un-def!#undef!'
/*
 * This file was produced by running the config_h.SH script, which
 * gets its values from config.sh, which is generally produced by
 * running Configure.
 *
 * Feel free to modify any of this as the need arises.  Note, however,
 * that running config_h.SH again will wipe out any changes you've made.
 * For a more permanent change edit config.sh and rerun config_h.SH.
 *
 * \$Id: Config_h.U,v 3.0.1.5 1997/02/28 14:57:43 ram Exp $
 */

/*
 * Package name      : $package
 * Source directory  : $src
 * Configuration time: $cf_time
 * Configured by     : $cf_by
 * Target system     : $myuname
 */

#ifndef _config_h_
#define _config_h_

/* BSD:
 *	This symbol, if defined, indicates that the program is running under
 *	a BSD system.
 */
#$d_bsd BSD		/**/

/* HAS_BCOPY:
 *	This symbol is defined if the bcopy() routine is available to
 *	copy blocks of memory.
 */
#$d_bcopy HAS_BCOPY	/**/

/* HAS_BZERO:
 *	This symbol is defined if the bzero() routine is available to
 *	set a memory block to 0.
 */
#$d_bzero HAS_BZERO	/**/

/* HAS_FMOD:
 *	This symbol, if defined, indicates that the fmod routine is
 *	available to compute the remainder r=x-n*y where n=trunc(x/y).
 */
#$d_fmod HAS_FMOD		/**/

/* HAS_GETOPT:
 *	This symbol, if defined, indicates that the getopt() routine exists.
 */
#$d_getopt HAS_GETOPT		/**/

/* HAS_MEMCPY:
 *	This symbol, if defined, indicates that the memcpy routine is available
 *	to copy blocks of memory.
 */
#$d_memcpy HAS_MEMCPY	/**/

/* HAS_MEMSET:
 *	This symbol, if defined, indicates that the memset routine is available
 *	to set blocks of memory.
 */
#$d_memset HAS_MEMSET	/**/

/* HAS_SETLOCALE:
 *	This symbol, if defined, indicates that the setlocale routine is
 *	available to handle locale-specific ctype implementations.
 */
#$d_setlocale HAS_SETLOCALE	/**/

/* I_LIMITS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <limits.h> to get definition of symbols like WORD_BIT or
 *	LONG_MAX, i.e. machine dependant limitations.
 */
#$i_limits I_LIMITS		/**/

/* I_LOCALE:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <locale.h>.
 */
#$i_locale	I_LOCALE		/**/

/* I_MATH:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <math.h>.
 */
#$i_math I_MATH		/**/

/* I_MEMORY:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <memory.h>.
 */
#$i_memory I_MEMORY		/**/

/* I_STDLIB:
 *	This symbol, if defined, indicates that <stdlib.h> exists and should
 *	be included.
 */
#$i_stdlib I_STDLIB		/**/

/* I_SYS_PARAM:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/param.h>.
 */
#$i_sysparam I_SYS_PARAM		/**/

/* I_SYS_STAT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/stat.h>.
 */
#$i_sysstat	I_SYS_STAT		/**/

/* I_SYS_TYPES:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/types.h>.
 */
#$i_systypes	I_SYS_TYPES		/**/

/* I_TIME:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <time.h>.
 */
/* I_SYS_TIME:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/time.h>.
 */
#$i_time I_TIME		/**/
#$i_systime I_SYS_TIME		/**/

/* I_UNISTD:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <unistd.h>.
 */
#$i_unistd I_UNISTD		/**/

/* CAN_PROTOTYPE:
 *	If defined, this macro indicates that the C compiler can handle
 *	function prototypes.
 */
/* _:
 *	This macro is used to declare function parameters for folks who want
 *	to make declarations with prototypes using a different style than
 *	the above macros.  Use double parentheses.  For example:
 *
 *		int main _((int argc, char *argv[]));
 */
#$prototype	CAN_PROTOTYPE	/**/
#ifdef CAN_PROTOTYPE
#define	_(args) args
#else
#define	_(args) ()
#endif

/* VOIDFLAGS:
 *	This symbol indicates how much support of the void type is given by this
 *	compiler.  What various bits mean:
 *
 *	    1 = supports declaration of void
 *	    2 = supports arrays of pointers to functions returning void
 *	    4 = supports comparisons between pointers to void functions and
 *		    addresses of void functions
 *	    8 = suports declaration of generic void pointers
 *
 *	The package designer should define VOIDUSED to indicate the requirements
 *	of the package.  This can be done either by #defining VOIDUSED before
 *	including config.h, or by defining defvoidused in Myinit.U.  If the
 *	latter approach is taken, only those flags will be tested.  If the
 *	level of void support necessary is not present, defines void to int.
 */
#ifndef VOIDUSED
#define VOIDUSED $defvoidused
#endif
#define VOIDFLAGS $voidflags
#if (VOIDFLAGS & VOIDUSED) != VOIDUSED
#define void int		/* is void to be avoided? */
#define M_VOID			/* Xenix strikes again */
#endif

/* HAS_BINDTEXTDOMAIN:
 *	This symbol is defined if the bindtextdomain() routine is available.
 */
#$d_bindtextdomain HAS_BINDTEXTDOMAIN	/**/

/* HAS_ENDMNTENT:
 *	This symbol is defined if the endmntent() routine is available.
 */
#$d_endmntent HAS_ENDMNTENT	/**/

/* DCL_ERRNO:
 *	This symbol, if defined, indicates that errno is declared
 */
#$d_dcl_errno DCL_ERRNO		/**/

/* HAS_FS_INFO:
 *	This symbol is defined if the fs_info() routine is available.
 */
#$d_fs_info HAS_FS_INFO	/**/

/* HAS_FS_STAT_DEV:
 *	This symbol, if defined, indicates that the fs_stat_dev()
 *     routine exists.
 */
#$d_fs_stat_dev HAS_FS_STAT_DEV	/**/

/* HAS_FSHELP:
 *	This symbol, if defined, indicates that the fshelp() routine exists.
 */
#$d_fshelp HAS_FSHELP		/**/

/* HAS_GETFSSTAT:
 *	This symbol is defined if the getfsstat() routine is available.
 */
#$d_getfsstat HAS_GETFSSTAT	/**/

/* HAS_GETMNT:
 *	This symbol is defined if the getmnt() routine is available.
 */
#$d_getmnt HAS_GETMNT	/**/

/* HAS_GETMNTENT:
 *	This symbol is defined if the getmntent() routine is available.
 */
#$d_getmntent HAS_GETMNTENT	/**/

/* HAS_GETMNTINFO:
 *	This symbol is defined if the getmntinfo() routine is available.
 */
#$d_getmntinfo HAS_GETMNTINFO	/**/

/* HAS_GETTEXT:
 *	This symbol is defined if the gettext() routine is available.
 */
#$d_gettext HAS_GETTEXT	/**/

/* HAS_HASMNTOPT:
 *	This symbol is defined if the hasmntopt() routine is available.
 */
#$d_hasmntopt HAS_HASMNTOPT	/**/

/* HAS_MNTCTL:
 *	This symbol is defined if the mntctl() routine is available.
 */
#$d_mntctl HAS_MNTCTL	/**/

/* DCL_OPTIND:
 *	This symbol, if defined, indicates that the optind external
 *	variable is declared.
 */
/* DCL_OPTARG:
 *	This symbol, if defined, indicates that the optarg external
 *	variable is declared.
 */
#$d_dcl_optind DCL_OPTIND                /**/
#if ! defined (DCL_OPTIND)
    extern int optind;
#endif
#$d_dcl_optarg DCL_OPTARG                /**/
#if ! defined (DCL_OPTARG)
    extern char *optarg;
#endif

/* HAS_SETMNTENT:
 *	This symbol is defined if the setmntent() routine is available.
 */
/* HAS_SETMNTENT_1ARG:
 *	This symbol is defined if the setmntent() has one argument.
 */
/* HAS_SETMNTENT_2ARG:
 *	This symbol is defined if the setmntent() has two arguments.
 */
#$d_setmntent HAS_SETMNTENT	/**/
#$d_setmntent_1arg HAS_SETMNTENT_1ARG	/**/
#$d_setmntent_2arg HAS_SETMNTENT_2ARG	/**/

/* HAS_SNPRINTF:
 *	This symbol is defined if the snprintf() routine is available.
 */
#$d_snprintf HAS_SNPRINTF	/**/
# if defined (HAS_SNPRINTF)
#  define Snprintf snprintf
#  define SPF(a1,a2,a3)      a1,a2,a3
# else
#  define Snprintf sprintf
#  define SPF(a1,a2,a3)      a1,a3
# endif

/* HAS_STATFS:
 *	This symbol is defined if the statfs() routine is available.
 */
/* HAS_STATFS_2ARG:
 *	This symbol is defined if statfs() has two arguments.
 */
/* HAS_STATFS_3ARG:
 *	This symbol is defined if statfs() has three arguments.
 */
/* HAS_STATFS_4ARG:
 *	This symbol is defined if statfs() has four arguments.
 */
#$d_statfs HAS_STATFS	/**/
#$d_statfs_2arg HAS_STATFS_2ARG      /**/
#$d_statfs_3arg HAS_STATFS_3ARG  /**/
#$d_statfs_4arg HAS_STATFS_4ARG  /**/

/* HAS_STATVFS:
 *	This symbol is defined if the statvfs() routine is available.
 */
#$d_statvfs HAS_STATVFS	/**/

/* HAS_SYSFS:
 *	This symbol is defined if the sysfs() routine is available.
 */
#$d_sysfs HAS_SYSFS	/**/

/* HAS_TEXTDOMAIN:
 *	This symbol is defined if the textdomain() routine is available.
 */
#$d_textdomain HAS_TEXTDOMAIN	/**/

/* I_CTYPE:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <ctype.h>.
 */
#$i_ctype I_CTYPE		/**/

/* I_ERRNO:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <errno.h>.
 */
#$i_errno I_ERRNO		/**/

/* I_FSHELP:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <fshelp.h>.
 */
#$i_fshelp I_FSHELP		/**/

/* I_GETOPT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <getopt.h>.
 */
#$i_getopt I_GETOPT		/**/

/* I_KERNFSINFO:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <kernel/fs_info.h>.
 */
#$i_kernfsinfo I_KERNFSINFO		/**/

/* I_LIBINTL:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <libintl.h>.
 */
#$i_libintl I_LIBINTL		/**/

/* I_MALLOC:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <malloc.h>.
 */
/* INCLUDE_MALLOC:
 *	This symbol, if defined, indicates to the C program that it is ok
 *	to include <malloc.h>.
 */
#$i_malloc I_MALLOC		/**/
#$d_include_malloc INCLUDE_MALLOC /**/

/* I_MNTENT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <mntent.h>.
 */
#$i_mntent I_MNTENT		/**/

/* I_MNTTAB:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <mnttab.h>.
 */
#$i_mnttab I_MNTTAB		/**/

/* I_STOR_DIRECTORY:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <storage/Directory.h>.
 */
#$i_stor_directory I_STOR_DIRECTORY		/**/

/* I_STOR_ENTRY:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <storage/Entry.h>.
 */
#$i_stor_entry I_STOR_ENTRY		/**/

/* I_STOR_PATH:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <storage/Path.h>.
 */
#$i_stor_path I_STOR_PATH		/**/

/* I_STRING:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <string.h>.
 */
/* I_STRINGS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <strings.h>.
 */
/* INCLUDE_STRING:
 *	This symbol, if defined, indicates to the C program that it is ok
 *	to include both <string.h> and <strings.h>.
 */
#$i_string I_STRING		/**/
#$i_strings I_STRINGS	/**/
#$d_include_string INCLUDE_STRING /**/

/* I_SYS_FSTYP:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/fstyp.h>.
 */
#$i_sysfstyp I_SYS_FSTYP		/**/

/* I_SYS_FSTYPES:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/fstypes.h>.
 */
/* I_SYS_FS_TYPES:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/fs_types.h>.
 */
#$i_sysfstypes I_SYS_FSTYPES		/**/
#$i_sysfs_types I_SYS_FS_TYPES	/**/

/* I_SYS_MNTCTL:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/mntctl.h>.
 */
#$i_sysmntctl I_SYS_MNTCTL		/**/

/* I_SYS_MNTENT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/mntent.h>.
 */
#$i_sysmntent I_SYS_MNTENT		/**/

/* I_SYS_MNTTAB:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/mnttab.h>.
 */
#$i_sysmnttab I_SYS_MNTTAB		/**/

/* I_SYS_MOUNT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/mount.h>.
 */
#$i_sysmount I_SYS_MOUNT		/**/

/* I_SYS_STATFS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/statfs.h>.
 */
#$i_sysstatfs I_SYS_STATFS		/**/

/* I_SYS_STATVFS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/statvfs.h>.
 */
#$i_sysstatvfs I_SYS_STATVFS		/**/

/* I_SYS_VFS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/vfs.h>.
 */
#$i_sysvfs I_SYS_VFS		/**/

/* I_SYS_VFSTAB:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/vfstab.h>.
 */
#$i_sysvfstab I_SYS_VFSTAB		/**/

/* I_SYS_VMOUNT:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <sys/vmount.h>.
 */
#$i_sysvmount I_SYS_VMOUNT		/**/

/* I_WINDOWS:
 *	This symbol, if defined, indicates to the C program that it should
 *	include <windows.h>.
 */
#$i_windows I_WINDOWS		/**/

/* MEM_MNT_TIME_MNTTAB:
 *	This symbol indicates that the mnttab.mnt_time field is available.
 */
/* MEM_VMT_TIME_VMOUNT:
 *	This symbol indicates that the vmount.vmt_time field is available.
 */
#$d_mem_mnt_time_mnttab MEM_MNT_TIME_MNTTAB /**/
#$d_mem_vmt_time_vmount MEM_VMT_TIME_VMOUNT /**/

/* MEM_F_FSTYPENAME_STATFS:
 *	This symbol is defined if the statfs.f_fstypename field is available.
 */
/* MEM_F_FSIZE_STATFS:
 *	This symbol, if defined, indicates that statfs.f_fsize should
 *	is available.
 */
/* MEM_F_BSIZE_STATFS:
 *	This symbol, if defined, indicates that statfs.f_bsize
 *	is available.
 */
/* MEM_MOUNT_INFO_STATFS:
 *	This symbol, if defined, indicates that statfs.mount_info
 *	is available.
 */
/* MEM_F_IOSIZE_STATFS:
 *	This symbol, if defined, indicates that statfs.f_iosize
 *	is available.
 */
/* MEM_F_FRSIZE_STATFS:
 *	This symbol, if defined, indicates that statfs.f_frsize
 *	is available.
 */
/* MEM_F_TYPE_STATFS:
 *	This symbol, if defined, indicates that statfs.f_type
 *	is available.
 */
#$d_mem_f_fstypename_statfs MEM_F_FSTYPENAME_STATFS /**/
#$d_mem_f_fsize_statfs MEM_F_FSIZE_STATFS /**/
#$d_mem_f_bsize_statfs MEM_F_BSIZE_STATFS /**/
#$d_mem_f_iosize_statfs MEM_F_IOSIZE_STATFS /**/
#$d_mem_f_frsize_statfs MEM_F_FRSIZE_STATFS /**/
#$d_mem_mount_info_statfs MEM_MOUNT_INFO_STATFS /**/
#$d_mem_f_type_statfs MEM_F_TYPE_STATFS /**/

/* COMMAND_MSGFMT:
 * This variable defines the message format command
 */
#$d_msgfmt COMMAND_MSGFMT $msgfmt

/* NPT_GETENV:
 * This symbol indicates that getenv() needs a prototype.
 */
#$d_npt_getenv NPT_GETENV /**/

/* NPT_STATFS:
 * This symbol indicates that statfs() needs a prototype.
 */
#$d_npt_statfs NPT_STATFS /**/

/* Size_t:
 *	This symbol holds the type used to declare length parameters
 *	for string functions.  It is usually size_t, but may be
 *	unsigned long, int, etc.  It may be necessary to include
 *	<sys/types.h> to get any typedef'ed information.
 */
/* TYP_SIZE_T:
 *	This symbol, if defined, indicates that size_t exists.
 */
#define Size_t $sizetype	 /* length parameter for string functions */
#$d_typ_size_t TYP_SIZE_T  /**/

/* SIZ_LONG_LONG:
 *	This symbol, if defined, indicates the size of a long long.
 */
#define SIZ_LONG_LONG $d_siz_long_long /**/

/* Statvfs_t:
 *	This symbol holds the typedef for statvfs_t.
 */
/* TYP_STATVFS_T:
 *	This symbol, if defined, indicates that statvfs_t exists.
 */
#define Statvfs_t $statvfstype
#$d_typ_statvfs_t TYP_STATVFS_T  /**/

#endif
!GROK!THIS!
