/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include "appsupport.h"
#include "profile.h"
#include "appglobals.h"
#include "appfunctions.h"
#include "usergrouplists.h"
#include "connect_dialog.h"

void
profileselected_fill (GtkWidget * widget)
{

  GList *loopix = g_list_first (connection_profile_list);
  GList *milista = NULL;

  g_assert (widget);

  while (loopix)
    {

      milista = g_list_append (milista,
			       g_strdup (connection_profile_get_name
					 ((connection_profile *)
					  loopix->data)));
      loopix = g_list_next (loopix);
    }

  gtk_combo_set_popdown_strings (GTK_COMBO (widget), milista);


  g_list_foreach (milista, (GFunc) g_free, NULL);
  g_list_free (milista);

}


int
profileselected_commit (GtkWidget * widget)
{
  gchar *profilename = NULL;

  g_print ("\ncalled: profileselected_commit\n");
  profilename =
    gtk_entry_get_text (GTK_ENTRY
			(lookup_widget (widget, "profileselectedentry")));
  g_assert (profilename);

  return app_connect(profilename);
}
