#include "config.h"
#include "playlist.h"
#include <qtabwidget.h>
#include "list.h"
#include "virlist.h"
#include "playerlist.h"
#include "cdlist.h"
#include <qlistview.h>
#include "dirview.h"
#include <qpushbutton.h>
#include <qmessagebox.h>
#include "frame.h"
#include <qfiledialog.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include "jack.h"
#include "searchdlg.h"
#ifdef HAVE_QOBJECTLIST_H
#include <qobjectlist.h>
#else
#ifdef HAVE_QOBJCOLL_H
#include <qobjcoll.h>
#else
#error "Your QT has neither qobjcoll.h nor qobjectlist.h"
#endif
#endif
#include <qapplication.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qpixmap.h>
#include <qpainter.h>
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "metadatadlg.h"
#include "cfgfile.h"

#include "background-topleft.xpm"
#include "background-topright.xpm"
#include "background-bottomleft.xpm"
#include "background-bottomright.xpm"

#include "metallic_70.xpm"
#include "metallic_70_down.xpm"

void Playlist::closeEvent(QCloseEvent *e)
{
	e->ignore();
}

void Playlist::resizeEvent(QResizeEvent *e)
{
	tab_widget->resize(e->size().width()-20, e->size().height()-45);
}

Playlist::Playlist(QWidget *parent, const char *name, WFlags f) : QWidget(parent, name, f)
{
    topleft=new QPixmap((const char **)background_topleft_xpm);
    topright=new QPixmap((const char **)background_topright_xpm);
    bottomleft=new QPixmap((const char **)background_bottomleft_xpm);
    bottomright=new QPixmap((const char **)background_bottomright_xpm);

	scanthread=new ScanThread();
	scanthread->start();

	def_dir=getenv("HOME");
	BitmapButton *btn=new BitmapButton(this);
	btn->setGeometry(10, 10, 70, 20);
	btn->show();
	btn->setText(_("New List"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(new_clicked()));

	btn=new BitmapButton(this);
	btn->setGeometry(85, 10, 70, 20);
	btn->show();
	btn->setText(_("Virtual List"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(virtual_clicked()));

#ifdef HAVE_LIBCDDA_PARANOIA
	btn=new BitmapButton(this);
	btn->setGeometry(160, 10, 70, 20);
	btn->show();
	btn->setText(_("CD List"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(cdda_clicked()));
#endif

	btn=new BitmapButton(this);
	btn->setGeometry(235, 10, 70, 20);
	btn->show();
	btn->setText(_("Close"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(close_clicked()));

	btn=new BitmapButton(this);
	btn->setGeometry(310, 10, 70, 20);
	btn->show();
	btn->setText(_("Left"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(left_clicked()));

	btn=new BitmapButton(this);
	btn->setGeometry(385, 10, 70, 20);
	btn->show();
	btn->setText(_("Right"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(right_clicked()));

	btn=new BitmapButton(this);
	btn->setGeometry(460, 10, 70, 20);
	btn->show();
	btn->setText(_("Find"));
	btn->setBitmaps(metallic_70_xpm, metallic_70_down_xpm);
	connect(btn, SIGNAL(clicked()), this, SLOT(find_clicked()));

	tab_widget=new QTabWidget(this);
	tab_widget->move(10, 35);
	tab_widget->show();

	PlayerList *plist=new PlayerList((QWidget *)tab_widget, this);
	QString file=(QString)getenv("HOME")+"/"+"Auto.pll";
	plist->setTitle("Auto");
	plist->setFile(file);
	plist->show();
	tab_widget->addTab(plist, plist->getTitle());
	tab_widget->showPage(plist);
	player_list=plist;

	MetadataDlg *meta=new MetadataDlg((QWidget *)tab_widget);
	meta->show();
	tab_widget->addTab(meta, "Meta");
	tab_widget->showPage(meta);

	List *list=new List((QWidget *)tab_widget, this);
	list->setDir(config->getValue("InitialDir", "/"));
	list->show();
	tab_widget->addTab(list, list->getDir());
	tab_widget->showPage(list);
}

Playlist::~Playlist()
{
	delete tab_widget;
	delete scanthread;
    delete topleft;
    delete topright;
    delete bottomleft;
    delete bottomright;
}

QString Playlist::getSelectedFile()
{
	List *list=(List *)tab_widget->currentPage();
	if(!list)
		return QString::null;
	return list->getSelectedFile();
}

void Playlist::new_clicked()
{
	QString dir=config->getValue("InitialDir", "/");
	List *list=(List *)tab_widget->currentPage();
	if(list)
		dir=list->getDir();
	if(dir == "" || dir == QString::null)
		dir=config->getValue("InitialDir", "/");
	list=new List((QWidget *)tab_widget, this);
	list->setDir(dir);
	list->show();
	tab_widget->addTab(list, list->getDir());
	tab_widget->showPage(list);
}

void Playlist::close_clicked()
{
	List *list=(List *)tab_widget->currentPage();
	if(!list)
		return;
	
	if(list->isA("PlayerList"))
		return;

	if(QMessageBox::warning(this, "Close", "Really close playlist?", "Yes", "No", 0, 0, 1) == 1)
		return;
	tab_widget->removePage(list);
	delete list;
}

void Playlist::left_clicked()
{
	QString path=getSelectedFile();
	if(path == "" || path == QString::null)
		return;
	frame->left()->OpenMediaFile(path);
	setCurrentSong(1);
}

void Playlist::right_clicked()
{
	QString path=getSelectedFile();
	if(path == "" || path == QString::null)
		return;
	frame->right()->OpenMediaFile(path);
	setCurrentSong(2);
}

void Playlist::virtual_clicked()
{
	QString strFilter="Playlist (*.pll);;Xmms Playlists (*.m3u);;PLS Lists (*.pls);;Text files (*.txt);;All files (*)";
	QFileDialog filed(def_dir, strFilter, this, 0, true);
	filed.setMode(QFileDialog::AnyFile);
	filed.setCaption("Open / Create playlist");
	QObjectList *ch=filed.queryList("QPushButton");
	if(ch)
	{
		QObjectListIt oi(*ch);
		QObject *o;
		while((o=oi.current()) != 0)
		{
			++oi;
			QPushButton *b=(QPushButton *)o;
			if(b->text().mid(0, 1) == "S")
				b->setText("OK");
		}
		delete ch;
	}
	filed.exec();
	QString file=filed.selectedFile();
	if(file == QString::null || file == "")
		return;
	QFileInfo info(file);
	def_dir=info.dirPath(true);
	if(info.extension(false) == "" || info.extension(false) == QString::null)
		file=file+".pll";

	info.setFile(file);

	int fd=open(file, O_CREAT | O_APPEND | O_WRONLY, 0644);
	if(fd >= 0)
		close(fd);
	if(!info.isWritable())
	{
		QMessageBox::warning(this, "Error", "Cannot create file", "OK", 0, 0, 0, 0);
		return;
	}

	List *list;

	list=new VirList((QWidget *)tab_widget, this);
	QString title=info.fileName();
	int pos=info.fileName().find(".pll");
	if(pos != -1)
		title=info.fileName().left(pos);
	pos=info.fileName().find(".m3u");
	if(pos != -1)
	{
		title=info.fileName().left(pos);
		((VirList *)list)->setType(VirList::M3U);
	}
	pos=info.fileName().find(".pls");
	if(pos != -1)
	{
		title=info.fileName().left(pos);
		((VirList *)list)->setType(VirList::PLS);
	}
	list->setTitle(title);
	list->setFile(file);
	list->show();
	tab_widget->addTab(list, list->getTitle());
	tab_widget->showPage(list);
}

void Playlist::doubleClick()
{
	QString path=getSelectedFile();
	if(path == "" || path == QString::null)
		return;
	if(!frame->left()->isPlaying())
	{
		frame->left()->OpenMediaFile(path);
		setCurrentSong(1);
		return;
	}
	if(!frame->right()->isPlaying())
	{
		frame->right()->OpenMediaFile(path);
		setCurrentSong(2);
		return;
	}
}

ScanThread * Playlist::scanThread()
{
	return scanthread;
}

void Playlist::setCurrentSong(int player)
{
	List *list=(List *)tab_widget->currentPage();
	if(!list->isA("PlayerList"))
	{
		player_list->clearCurrentSong(player);
		return;
	}
	PlayerList *pl=(PlayerList *)list;
	pl->setCurrentSong(player);
}

void Playlist::setCurrentSongAuto(int player)
{
	player_list->setCurrentSong(player);
}

void Playlist::clearCurrentSong(int player)
{
	player_list->clearCurrentSong(player);
}

QString Playlist::getNextSong(int random)
{
	bool success;

	if(random)
		success=player_list->selectRandomUnplayed();
	else
		success=player_list->selectFirstUnplayed();
	if(!success)
		return QString::null;
	
	return player_list->getSelectedFile();
}

void Playlist::cdda_clicked()
{
#ifdef HAVE_LIBCDDA_PARANOIA
	CDList *cdlist=new CDList((QWidget *)tab_widget, this);
	cdlist->setDir("/dev/cdrom");
	cdlist->show();
	tab_widget->addTab(cdlist, cdlist->getDir());
	tab_widget->showPage(cdlist);
#endif
}

void Playlist::find_clicked()
{
	SearchDlg dlg(this, 0, true);

	if(!dlg.exec())
		return;
	
	QString term=dlg.Term->text().lower();

	if(term == "")
		return;
	QStringList results;
	int skip_count=0;
    QObjectList *ch=player_list->parent()->queryList("List");
    if(ch)
    {
        if(ch->count())
        {
            QObjectListIt i(*ch);
            QObject *obj;
            while((obj=i.current()) != 0)
            {
                ++i;
                List *list=(VirList *)obj;

				DirViewItem *it=(DirViewItem *)list->lv->firstChild();
				while(it)
				{
					QString name=it->text(0).lower();
					if(!dlg.RegExp->isChecked())
					{
						if(name.find(term) != -1)
						{
							results.append(it->text(3));
						}
					}
					else
					{
						if(name.find(QRegExp(dlg.Term->text())) != -1)
						{
							results.append(it->text(3));
						}
					}
					it=(DirViewItem *)it->nextSibling();
				}
				++skip_count;
				if(skip_count >= 100)
				{
					skip_count=0;
					app->processEvents(10);
				}
            }
        }
    }
    delete ch;

	if(results.count())
	{
		VirList *rlist=new VirList(tab_widget, this);
		rlist->setTitle((QString)"Results "+dlg.Term->text());
		rlist->setFile("");

		QStringList::Iterator it;
		for(it=results.begin();it != results.end();++it)
		{
			rlist->addFile((*it), false);
		}
		rlist->show();
		tab_widget->addTab(rlist, rlist->getTitle());
		tab_widget->showPage(rlist);
	}
}

void Playlist::paintEvent(QPaintEvent *e)
{
    QPixmap bg(width(), height());

    QPainter p;
    p.begin(&bg, this);

    QPen bgp(QColor(58, 59, 63));
    QBrush bgb(QColor(58, 59, 63));

    p.setPen(bgp);
    p.setBrush(bgb);

    p.drawRect(0, 0, width(), height());

    bitBlt(&bg, 0, 0, topleft);
    bitBlt(&bg, width()-8, 0, topright);
    bitBlt(&bg, 0, height()-8, bottomleft);
    bitBlt(&bg, width()-8, height()-8, bottomright);

    QPen w(QColor(255, 255, 255));
    p.setPen(w);
	p.moveTo(7,2);
    p.lineTo(width()-8, 2);
    p.moveTo(7,3);
    p.lineTo(width()-8, 3);

    p.moveTo(7,height()-3);
    p.lineTo(width()-7, height()-3);
    p.moveTo(7,height()-4);
    p.lineTo(width()-7, height()-4);

    p.moveTo(2, 7);
    p.lineTo(2, height()-8);
    p.moveTo(3, 7);
    p.lineTo(3, height()-8);

    p.moveTo(width()-3, 7);
    p.lineTo(width()-3, height()-8);
    p.moveTo(width()-4, 7);
    p.lineTo(width()-4, height()-8);

	bitBlt(this, 0, 0, &bg);
}

