#include "bitmapbutton.h"
#include <qpainter.h>

BitmapButton::BitmapButton(QWidget *parent, const char *name) : QPushButton(parent, name)
{
	pm_u=NULL;
	pm_d=NULL;
	pm_ul=NULL;
	pm_dl=NULL;
	m_bLit=false;
	m_bToggleLit=false;

	connect(this, SIGNAL(pressed()), this, SLOT(btnPressed()));
	connect(this, SIGNAL(released()), this, SLOT(btnReleased()));
}

BitmapButton::~BitmapButton()
{
	if(pm_u)
		delete pm_u;
	if(pm_d)
		delete pm_d;
	if(pm_ul)
		delete pm_ul;
	if(pm_dl)
		delete pm_dl;
}

void BitmapButton::setToggleLit(bool on)
{
	m_bToggleLit=on;
}

bool BitmapButton::toggleLit() const
{
	return m_bToggleLit;
}

void BitmapButton::setUpPixmap(QPixmap& up)
{
	if(pm_u)
		delete pm_u;
	pm_u=new QPixmap(up);
}

const QPixmap* BitmapButton::upPixmap() const
{
	return pm_u;
}

void BitmapButton::setDownPixmap(QPixmap& down)
{
	if(pm_d)
		delete pm_d;
	pm_d=new QPixmap(down);
}

const QPixmap* BitmapButton::downPixmap() const
{
	return pm_d;
}

void BitmapButton::setUpLitPixmap(QPixmap& up_lit)
{
	if(pm_ul)
		delete pm_ul;
	pm_ul=new QPixmap(up_lit);
}

const QPixmap* BitmapButton::upLitPixmap() const
{
	return pm_ul;
}

void BitmapButton::setDownLitPixmap(QPixmap& down_lit)
{
	if(pm_dl)
		delete pm_dl;
	pm_dl=new QPixmap(down_lit);
}

const QPixmap* BitmapButton::downLitPixmap() const
{
	return pm_dl;
}

void BitmapButton::setBitmaps(char **up, char **down, char **up_l, char **down_l)
{
	if(pm_u)
		delete pm_u;
	if(pm_d)
		delete pm_d;
	if(up_l && pm_ul)
		delete pm_ul;
	if(down_l && pm_dl)
		delete pm_dl;

	pm_u=new QPixmap((const char **)up);
	pm_d=new QPixmap((const char **)down);
	if(up_l)
		pm_ul=new QPixmap((const char **)up_l);
	if(down_l)
		pm_dl=new QPixmap((const char **)down_l);

	resize(pm_u->size());
	update();
}

void BitmapButton::paintEvent(QPaintEvent *ev)
{
	if(!pm_ul && pm_u)
		pm_ul=new QPixmap(*pm_u);
	if(!pm_dl && pm_d)
		pm_dl=new QPixmap(*pm_d);

	if(!pm_u || !pm_d)
	{
		QPushButton::paintEvent(ev);
		return;
	}
	QPainter p(this);
	if(!m_bLit)
	{
		if(!isDown() && !isOn())
			p.drawPixmap(0, 0, *pm_u);
		else if(!isDown() && isOn())
		{
			if(m_bToggleLit)
				p.drawPixmap(0, 0, *pm_ul);
			else
				p.drawPixmap(0, 0, *pm_d);
		}
		else if(isDown() && !isOn())
			p.drawPixmap(0, 0, *pm_d);
		else
		{
			if(m_bToggleLit)
				p.drawPixmap(0, 0, *pm_dl);
			else
				p.drawPixmap(0, 0, *pm_d);
		}
	}
	else
	{
		if(!isDown() && !isOn())
			p.drawPixmap(0, 0, *pm_ul);
		else
			p.drawPixmap(0, 0, *pm_dl);
	}

	if(text() == QString::null || text() == "")
		return;
	

	QFont f=font();
	f.setPixelSize(9);
	p.setFont(f);

	QPen pb(QColor(0, 0, 0));
	QPen pw(QColor(255, 255, 255));

	QRect rc=p.boundingRect(0, height()-11, width(), 9, AlignCenter, text());

	if(isDown() || isOn())
		rc.moveBy(1, 1);

	p.setPen(pb);
	p.drawText(rc, AlignCenter, text());

	rc.moveBy(-1, -1);
	p.setPen(pw);
	p.drawText(rc, AlignCenter, text());
}

void BitmapButton::setLit(bool bLit)
{
	m_bLit=bLit;
	update();
}

bool BitmapButton::lit() const
{
	return m_bLit;
}

void BitmapButton::btnPressed()
{
	update();
}

void BitmapButton::btnReleased()
{
	update();
}
