/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
 * header file for easy-handling of socket-related routines.
 * $Id: libsocket.h,v 1.5 2001/11/18 08:44:45 dancer Exp $
 */

/* nicked off pieces of code from :
 * nantarad client... obtains information from nantarad, and returns 
 * the value obtained to stdout and exit value.
 * on error, returns EXIT_FAILURE on normal failure, and -1 on 
 * more obscure failures.
 *
 * originally a Telnet clone which does little input/output cooking.
 * 2001 Feb 28 Junichi Uekawa <dancer@debian.org>
 * 2001 Mar 4 Junichi Uekawa <dancer@debian.org> reuse for nantaraclient
 * copyright 2001 Junichi Uekawa
 * See GPL version 2 or later for license.
 */
#ifndef __LIBSOCKET_H
#define __LIBSOCKET_H

int dm_connect_to_host(const char * stringaddress, int portnumber );

/**
   Used in \Ref{dm_tcp_host_setup}.
   The parameter sent to the callback function.
 */
struct dm_handle_incoming_params
{
  /**file descriptor of socket*/
  int t;
  /** address of the caller*/
  struct sockaddr_in *tmpisap ;
} dm_handle_incoming_params ;

int dm_tcp_host_setup( const char * programname, const char * port_name,
		    void* handle_incoming_function);
				/* programname = name of program,
				 portname = port number
				 handle_incoming_function = pthread routine.
				parameter is dm_handle_incoming_params, and 
				parameter->t is the socket. */
				/* You will need to close 
				 socket by yourself..*/
 
char * dm_gethostname_versatile(void);
				/* get the local hostname. please free after use */

#endif
