/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * structure tree viewer: gives you a clue on tree structure of dmachinemon
 */
/* 
 * 2001 Sep 12
 * $Id: dmachinemon-pdga.c,v 1.5 2001/10/01 06:46:38 dancer Exp $
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <unistd.h>
#include <dmachinemon/dmachinemon.h>


#define PROGRAMNAME "dmachinemon-pdga"
#define MESSAGETAG "dmachinemon-pdga-info"
#define SLEEPTIME 1000000 * 10

static void
processing_command()
{
  char * b = NULL ;
  char ** get = NULL;
  int i;
  
  
  while (1)
    { 
      asprintf (&b, "%li", random());
      dm_sendinfo (MESSAGETAG, b);
      free (b);
      usleep ( SLEEPTIME );
      get = dm_gatherinfo(MESSAGETAG);

      if (get)
	{
	  i=0;
	  while (*(get+i))
	    {
	      printf ("%i: %s\n", i, *(get+i));
	      i++;
	    }
	  dm_freeinfo(get);
	}
      usleep ( SLEEPTIME );
    }  
}


int
main(int ac, char ** av)
{ 
  int t = time(NULL);
  srand(t);
  
  if (ac != 1)
    {
      fprintf(stderr, "%s\n"
	      "\n\n"
	      "Tries to solve problem using GA\n"
	     " Copyright 2001 Junichi Uekawa\n\n",
	      av[0]);
      exit (1);
    }
  
  dm_Init(&ac, &av);
  processing_command();
  dm_Finalize();
  
  return 0;
}
