/*
 * FaderP.h
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _XawDialP_h
#define _XawDialP_h

#define MAXSEGMENTS		200

#include <X11/IntrinsicP.h>

typedef struct _XsFaderClassPart
{
  int ignore;
} XsFaderClassPart;

typedef struct _XsFaderClassRec
{
  CoreClassPart		core_class;
  XsFaderClassPart	fader_class;
} XsFaderClassRec;

typedef struct _XmsFaderThumb
{
  Window		w;
  int		xoffs;
  Pixmap		pm;
  unsigned int	width,
    height;
  int 		hx,
    hy;
  int		type;
  Window		val_win;  /* Window, which takes the value of the slider */
  GC		GC_vw1;
} XmsFaderThumb;

typedef struct _XsFaderPart
{
  /* Colors */
  Pixel		foreground;
  /*	Pixel		background; */
  Pixel		slider_color;
  Pixel		ident_color;
  Pixel		shadow1_color;
  Pixel		shadow2_color;

  Position	position;
  XtCallbackList	select;
  XtCallbackList	changed;

  char		hit;		/* 1 => active (got BtnDown) */
  int		fadeto_pos;	/* wert, zu dem der Autofader regeln soll */

  XtAppContext	cont;		/* Widget dependend Appl. context */
  XtIntervalId	autofadeId;	/* auto-fade's interval ID */

  GC		GC_bg;
  GC		GC_fg;
  GC		GC_slider;
  GC		GC_ident;
  GC		GC_shadow1;
  GC		GC_shadow2;

  XmsFaderThumb	th;


  /*====[ ShadowValueBar ]====*/
  Position	shadowPos;
  Position	lastShadowPos;
  Pixel		shadowColor;
  GC		GC_shadow;
  GC		GC_shadow_thumb;

  char          fast_motion;
} XsFaderPart;

typedef struct _XsFaderRec
{
  CorePart	core;
  XsFaderPart	fader;
} XsFaderRec;


extern	XsFaderClassRec	XsfaderClassRec;

#endif
