/*
 * utils.c
 *
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define __NO_VERSION__
#include <linux/module.h>

#include <dmxdev/dmxdevP.h>
#include <dmxdev/utils.h>
#include <dmx/dmxmem.h>

#include <linux/slab.h>
#include <asm/uaccess.h>


char *strdup (char *s)
{
  char *r = NULL;
  /* should use memdup   return s?memdup (s, strlen(s)+1) : NULL; */
  if (s)
    {
      int l = strlen(s);
      r = (char *)kmalloc(l+1, GFP_KERNEL);
      memcpy(r, s, l+1);
      /*      r[l]=0;*/
    }
  return r;
}


#if 0
void memset (unsigned char *s, unsigned char c, size_t len)
{
  while (len-- > 0)
    *(s++) = c;
}
#endif


/*
 * a save memory dup function
 */
char *memdup (const char *src, size_t size)
{
  char *dst = NULL;
  if (verify_area (VERIFY_WRITE, src, size) >= 0)
    {
      char *dst = (char *)MALLOC(size);
      if (dst)
	memcpy (dst, src, size);
    }
  return dst;
}



/*
 *
 */
char *skipspace (const char *s)
{
    if (s)
    {
        while (*s)
        {
            if (*s!=' ') return (char *)s;
            s++;
        }
    }
    return NULL;
}

