/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.Callout;
import org.xml.sax.SAXException;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected boolean foStylesheet = false;

    public FormatCallout(boolean fo) {
        this.foStylesheet = fo;
    }

    public String areaLabel(ElementInfo area) {
        String label = null;
        if (area.getAttributeList().getValue("label") != null) {
            label = area.getAttributeList().getValue("label");
        } else {
            ElementInfo parent = (ElementInfo)area.getParentNode();
            if (parent != null && parent.getLocalName().equalsIgnoreCase("areaset") && parent.getAttributeList().getValue("label") != null) {
                label = parent.getAttributeList().getValue("label");
            }
        }
        return label;
    }

    public void endSpan(Emitter rtf) throws SAXException {
        if (!this.foStylesheet) {
            Name spanName = new Name("span");
            rtf.endElement(spanName);
        }
    }

    public abstract void formatCallout(Emitter var1, Callout var2);

    public void formatTextCallout(Emitter rtfEmitter, Callout callout) {
        ElementInfo area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        char[] chars = label.toCharArray();
        try {
            this.startSpan(rtfEmitter);
            rtfEmitter.characters(chars, 0, label.length());
            this.endSpan(rtfEmitter);
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatTextCallout");
        }
    }

    public void startSpan(Emitter rtf) throws SAXException {
        if (!this.foStylesheet) {
            Name spanName = new Name("span");
            AttributeCollection spanAttr = new AttributeCollection();
            spanAttr.addAttribute(new Name("class"), "CDATA", "co");
            rtf.startElement(spanName, spanAttr);
        }
    }
}

