/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.Context;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import com.nwalsh.saxon.FormatGraphicCallout;
import com.nwalsh.saxon.FormatTextCallout;
import com.nwalsh.saxon.FormatUnicodeCallout;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Verbatim {
    private static Stack elementStack = null;
    private static Stack tempStack = null;
    private static int lineNumber = 0;
    private static int colNumber = 0;
    private static int modulus = 0;
    private static int width = 0;
    private static String separator = "";
    private static Callout[] callout = null;
    private static int calloutCount = 0;
    private static int calloutPos = 0;
    private static int defaultColumn = 60;
    private static FormatCallout fCallout = null;

    private static void addCallout(int coNum, NodeInfo node, int defaultColumn) {
        ElementInfo area = (ElementInfo)node;
        AttributeCollection attr = area.getAttributeList();
        String units = attr.getValue("units");
        String coords = attr.getValue("coords");
        if (units != null && !units.equalsIgnoreCase("linecolumn") && !units.equalsIgnoreCase("linerange")) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (coords == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer st = new StringTokenizer(coords);
        int tokenCount = 0;
        int c1 = 0;
        int c2 = 0;
        while (st.hasMoreTokens()) {
            if (++tokenCount > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                int coord;
                String token = st.nextToken();
                c2 = coord = Integer.parseInt(token);
                if (tokenCount != 1) continue;
                c1 = coord;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (calloutCount == callout.length) {
            Callout[] bigger = new Callout[calloutCount + 10];
            int count = 0;
            while (count < callout.length) {
                bigger[count] = callout[count];
                ++count;
            }
            callout = bigger;
        }
        if (tokenCount == 2) {
            if (units != null && units.equalsIgnoreCase("linerange")) {
                int count = c1;
                while (count <= c2) {
                    Verbatim.callout[Verbatim.calloutCount++] = new Callout(coNum, area, count, defaultColumn);
                    ++count;
                }
            } else {
                Verbatim.callout[Verbatim.calloutCount++] = new Callout(coNum, area, c1, c2);
            }
        } else {
            Verbatim.callout[Verbatim.calloutCount++] = new Callout(coNum, area, c1, defaultColumn);
        }
    }

    private static void calloutFragment(FragmentValue rtf, NodeInfo node) {
        NodeInfo[] children = null;
        try {
            char[] chars;
            String text;
            if (node.getNodeType() == 4) {
                rtf.startDocument();
                children = ((DocumentInfo)node).getAllChildNodes();
            } else if (node.getNodeType() == 1) {
                rtf.startElement(node.getExpandedName(), ((ElementInfo)node).getAttributeList());
                children = ((ElementInfo)node).getAllChildNodes();
                elementStack.push(node);
            } else if (node.getNodeType() == 3) {
                text = node.getValue();
                chars = new char[text.length()];
                int pos = 0;
                int count = 0;
                while (count < text.length()) {
                    if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        Verbatim.closeOpenElements(rtf);
                        while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                            fCallout.formatCallout((Emitter)rtf, callout[calloutPos]);
                            ++calloutPos;
                        }
                        Verbatim.openClosedElements(rtf);
                    }
                    if (text.charAt(count) == '\n') {
                        if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                            if (pos > 0) {
                                rtf.characters(chars, 0, pos);
                                pos = 0;
                            }
                            Verbatim.closeOpenElements(rtf);
                            while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                                Verbatim.formatPad(rtf, callout[calloutPos].getColumn() - colNumber);
                                colNumber = callout[calloutPos].getColumn();
                                while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                                    fCallout.formatCallout((Emitter)rtf, callout[calloutPos]);
                                    ++calloutPos;
                                }
                            }
                            Verbatim.openClosedElements(rtf);
                        }
                        ++lineNumber;
                        colNumber = 1;
                    } else {
                        ++colNumber;
                    }
                    chars[pos++] = text.charAt(count);
                    ++count;
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getValue();
                chars = new char[text.length()];
                int count = 0;
                while (count < text.length()) {
                    chars[count] = text.charAt(count);
                    ++count;
                }
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getValue());
            } else {
                System.out.println("Warning: unexpected node type in calloutFragment");
            }
            if (children != null) {
                int count = 0;
                while (count < children.length) {
                    Verbatim.calloutFragment(rtf, children[count]);
                    ++count;
                }
            }
            if (node.getNodeType() == 4) {
                rtf.endDocument();
            } else if (node.getNodeType() == 1) {
                rtf.endElement(node.getExpandedName());
                elementStack.pop();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in calloutFragment");
        }
    }

    private static void closeOpenElements(FragmentValue rtf) throws SAXException {
        String foURI = "http://www.w3.org/1999/XSL/Format";
        String xhURI = "http://www.w3.org/1999/xhtml";
        tempStack = new Stack();
        while (!elementStack.empty()) {
            ElementInfo elem = (ElementInfo)elementStack.pop();
            Name exName = elem.getExpandedName();
            String localName = elem.getLocalName();
            String ns = exName.getURI();
            if (ns != null && ns.equals("")) {
                ns = null;
            }
            if (elementStack.empty() && (ns != null && ns.equals(foURI) && localName.equals("block") || ns == null && localName.equalsIgnoreCase("pre") || ns != null && ns.equals(xhURI) && localName.equals("pre") || ns == null && localName.equalsIgnoreCase("div") || ns != null && ns.equals(xhURI) && localName.equals("div"))) {
                elementStack.push(elem);
                break;
            }
            rtf.endElement(exName);
            tempStack.push(elem);
        }
    }

    private static int countLineBreaks(NodeInfo node) {
        NodeInfo[] children = null;
        int numLines = 0;
        if (node.getNodeType() == 4) {
            children = ((DocumentInfo)node).getAllChildNodes();
        } else if (node.getNodeType() == 1) {
            children = ((ElementInfo)node).getAllChildNodes();
        } else if (node.getNodeType() == 3) {
            String text = node.getValue();
            char[] chars = new char[text.length()];
            boolean pos = false;
            int count = 0;
            while (count < text.length()) {
                if (text.charAt(count) == '\n') {
                    ++numLines;
                }
                ++count;
            }
        }
        if (children != null) {
            int count = 0;
            while (count < children.length) {
                numLines += Verbatim.countLineBreaks(children[count]);
                ++count;
            }
        }
        return numLines;
    }

    private static void formatLineNumber(FragmentValue rtf, int lineNumber) {
        char ch = '\u00a0';
        String lno = "";
        if (lineNumber == 1 || modulus >= 1 && lineNumber % modulus == 0) {
            lno = String.valueOf(lineNumber);
        }
        while (lno.length() < width) {
            lno = String.valueOf(ch) + lno;
        }
        lno = String.valueOf(lno) + separator;
        char[] chars = new char[lno.length()];
        int count = 0;
        while (count < lno.length()) {
            chars[count] = lno.charAt(count);
            ++count;
        }
        try {
            rtf.characters(chars, 0, lno.length());
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatLineNumber");
        }
    }

    private static void formatPad(FragmentValue rtf, int numBlanks) {
        char[] chars = new char[numBlanks];
        int count = 0;
        while (count < numBlanks) {
            chars[count] = 32;
            ++count;
        }
        try {
            rtf.characters(chars, 0, numBlanks);
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatCallout");
        }
    }

    protected static String getVariable(Context context, String varName) {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (SAXException sAXException) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    public static FragmentValue insertCallouts(Context context, NodeSetIntent areaspecNodeSet, FragmentValue saxonRTF) {
        Verbatim.setupCallouts(context);
        elementStack = new Stack();
        callout = new Callout[10];
        calloutCount = 0;
        calloutPos = 0;
        lineNumber = 1;
        colNumber = 1;
        try {
            boolean pos = false;
            int coNum = 0;
            boolean inAreaSet = false;
            NodeInfo areaspec = areaspecNodeSet.getFirst();
            NodeInfo[] children = areaspec.getAllChildNodes();
            int count = 0;
            while (count < children.length) {
                NodeInfo node = children[count];
                if (node.getNodeType() == 1) {
                    if (node.getNodeName().equalsIgnoreCase("areaset")) {
                        ++coNum;
                        NodeInfo[] areas = node.getAllChildNodes();
                        int acount = 0;
                        while (acount < areas.length) {
                            NodeInfo area = areas[acount];
                            if (area.getNodeType() == 1) {
                                if (area.getNodeName().equalsIgnoreCase("area")) {
                                    Verbatim.addCallout(coNum, area, defaultColumn);
                                } else {
                                    System.out.println("Unexpected element in areaset: " + area.getNodeName());
                                }
                            }
                            ++acount;
                        }
                    } else if (node.getNodeName().equalsIgnoreCase("area")) {
                        Verbatim.addCallout(++coNum, node, defaultColumn);
                    } else {
                        System.out.println("Unexpected element in areaspec: " + node.getNodeName());
                    }
                }
                ++count;
            }
            Arrays.sort(callout, 0, calloutCount);
            FragmentValue rtf = new FragmentValue();
            Verbatim.calloutFragment(rtf, saxonRTF.getFirst());
            return rtf;
        }
        catch (SAXException sAXException) {
            return saxonRTF;
        }
    }

    private static void lineNumberFragment(FragmentValue rtf, NodeInfo node) {
        NodeInfo[] children = null;
        boolean skipStack = false;
        try {
            char[] chars;
            String text;
            if (node.getNodeType() == 4) {
                rtf.startDocument();
                children = ((DocumentInfo)node).getAllChildNodes();
            } else if (node.getNodeType() == 1) {
                Name foBlock;
                rtf.startElement(node.getExpandedName(), ((ElementInfo)node).getAttributeList());
                if (elementStack.empty() && ((foBlock = new Name("fo", "http://www.w3.org/1999/XSL/Format", "block")).equals(node.getExpandedName()) || node.getNodeName().equalsIgnoreCase("pre") || node.getNodeName().equalsIgnoreCase("div"))) {
                    skipStack = true;
                }
                if (!skipStack) {
                    elementStack.push(node);
                }
                children = ((ElementInfo)node).getAllChildNodes();
            } else if (node.getNodeType() == 3) {
                text = node.getValue();
                if (lineNumber == 0) {
                    Verbatim.formatLineNumber(rtf, ++lineNumber);
                }
                chars = new char[text.length()];
                int pos = 0;
                int count = 0;
                while (count < text.length()) {
                    if (text.charAt(count) == '\n') {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        Verbatim.closeOpenElements(rtf);
                        chars[pos++] = text.charAt(count);
                        rtf.characters(chars, 0, pos);
                        pos = 0;
                        Verbatim.formatLineNumber(rtf, ++lineNumber);
                        Verbatim.openClosedElements(rtf);
                    } else {
                        chars[pos++] = text.charAt(count);
                    }
                    ++count;
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getValue();
                chars = new char[text.length()];
                int count = 0;
                while (count < text.length()) {
                    chars[count] = text.charAt(count);
                    ++count;
                }
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getValue());
            } else {
                System.out.println("Warning: unexpected node type in lineNumberFragment");
            }
            if (children != null) {
                int count = 0;
                while (count < children.length) {
                    Verbatim.lineNumberFragment(rtf, children[count]);
                    ++count;
                }
            }
            if (node.getNodeType() == 4) {
                rtf.endDocument();
            } else if (node.getNodeType() == 1) {
                rtf.endElement(node.getExpandedName());
                if (!skipStack) {
                    elementStack.pop();
                }
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in lineNumberFragment");
        }
    }

    public static FragmentValue numberLines(Context context, FragmentValue saxonRTF) {
        Verbatim.setupLineNumbering(context);
        try {
            int numLines = Verbatim.countLineBreaks(saxonRTF.getFirst()) + 1;
            elementStack = new Stack();
            lineNumber = 0;
            double log10numLines = Math.log(numLines) / Math.log(10.0);
            if ((double)width < log10numLines + 1.0) {
                width = (int)Math.floor(log10numLines + 1.0);
            }
            FragmentValue rtf = new FragmentValue();
            Verbatim.lineNumberFragment(rtf, saxonRTF.getFirst());
            return rtf;
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in numberLines");
            return saxonRTF;
        }
    }

    private static void openClosedElements(FragmentValue rtf) throws SAXException {
        while (!tempStack.empty()) {
            ElementInfo elem = (ElementInfo)tempStack.pop();
            AttributeCollection elemAttr = elem.getAttributeList();
            AttributeCollection newAttr = new AttributeCollection();
            int acount = 0;
            while (acount < elemAttr.getLength()) {
                String name = elemAttr.getName(acount);
                if (!name.equalsIgnoreCase("name") && !name.equalsIgnoreCase("id")) {
                    newAttr.addAttribute(elemAttr.getExpandedName(acount), elemAttr.getType(acount), elemAttr.getValue(acount));
                }
                ++acount;
            }
            rtf.startElement(elem.getExpandedName(), newAttr);
            elementStack.push(elem);
        }
    }

    private static void setupCallouts(Context context) {
        boolean useGraphics = false;
        boolean useUnicode = false;
        int unicodeStart = 48;
        int unicodeMax = 0;
        defaultColumn = 60;
        String graphicsPath = null;
        String graphicsExt = null;
        int graphicsMax = 0;
        boolean foStylesheet = false;
        Object variable = null;
        String varString = null;
        varString = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
        varString = Verbatim.getVariable(context, "callout.defaultcolumn");
        try {
            defaultColumn = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$callout.defaultcolumn is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "callout.graphics");
        useGraphics = (varString.equals("0") || varString.equals("")) ^ true;
        varString = Verbatim.getVariable(context, "callout.unicode");
        useUnicode = (varString.equals("0") || varString.equals("")) ^ true;
        if (useGraphics) {
            graphicsPath = varString = Verbatim.getVariable(context, "callout.graphics.path");
            graphicsExt = varString = Verbatim.getVariable(context, "callout.graphics.extension");
            varString = Verbatim.getVariable(context, "callout.graphics.number.limit");
            try {
                graphicsMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.graphics.number.limit is not a number: " + varString);
                graphicsMax = 0;
            }
            fCallout = new FormatGraphicCallout(graphicsPath, graphicsExt, graphicsMax, foStylesheet);
        } else if (useUnicode) {
            varString = Verbatim.getVariable(context, "callout.unicode.start.character");
            try {
                unicodeStart = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.start.character is not a number: " + varString);
                unicodeStart = 48;
            }
            varString = Verbatim.getVariable(context, "callout.unicode.number.limit");
            try {
                unicodeMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$callout.unicode.number.limit is not a number: " + varString);
                unicodeStart = 0;
            }
            fCallout = new FormatUnicodeCallout(unicodeStart, unicodeMax, foStylesheet);
        } else {
            fCallout = new FormatTextCallout(foStylesheet);
        }
    }

    private static void setupLineNumbering(Context context) {
        modulus = 5;
        width = 3;
        separator = " ";
        String varString = null;
        varString = Verbatim.getVariable(context, "linenumbering.everyNth");
        try {
            modulus = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.everyNth is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "linenumbering.width");
        try {
            width = Integer.parseInt(varString);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("$linenumbering.width is not a number: " + varString);
        }
        separator = varString = Verbatim.getVariable(context, "linenumbering.separator");
    }
}

