// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'uflacs'
//   split:                          True

#include "CahnHilliard2D.h"

cahnhilliard2d_finite_element_0::cahnhilliard2d_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard2d_finite_element_0::~cahnhilliard2d_finite_element_0()
{
    // Do nothing
}

const char * cahnhilliard2d_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', triangle, 1)";
}

ufc::shape cahnhilliard2d_finite_element_0::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t cahnhilliard2d_finite_element_0::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_0::geometric_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_0::space_dimension() const
{
    return 3;
}

std::size_t cahnhilliard2d_finite_element_0::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard2d_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_0::value_size() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_0::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard2d_finite_element_0::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_0::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_0::degree() const
{
    return 1;
}

const char * cahnhilliard2d_finite_element_0::family() const
{
    return "Lagrange";
}

void cahnhilliard2d_finite_element_0::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_0::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

void cahnhilliard2d_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard2d_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard2d_finite_element_0::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
}

void cahnhilliard2d_finite_element_0::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
}

void cahnhilliard2d_finite_element_0::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
}

std::size_t cahnhilliard2d_finite_element_0::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_0::create() const
{
    return new cahnhilliard2d_finite_element_0();
}


cahnhilliard2d_finite_element_1::cahnhilliard2d_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard2d_finite_element_1::~cahnhilliard2d_finite_element_1()
{
    // Do nothing
}

const char * cahnhilliard2d_finite_element_1::signature() const
{
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
}

ufc::shape cahnhilliard2d_finite_element_1::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t cahnhilliard2d_finite_element_1::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_1::geometric_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_1::space_dimension() const
{
    return 6;
}

std::size_t cahnhilliard2d_finite_element_1::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_1::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_finite_element_1::value_size() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_1::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_1::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_finite_element_1::reference_value_size() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_1::degree() const
{
    return 1;
}

const char * cahnhilliard2d_finite_element_1::family() const
{
    return "Lagrange";
}

void cahnhilliard2d_finite_element_1::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_1::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard2d_finite_element_1::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_1::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard2d_finite_element_1::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard2d_finite_element_1::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[5] = vals[1];
}

void cahnhilliard2d_finite_element_1::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
}

void cahnhilliard2d_finite_element_1::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
}

std::size_t cahnhilliard2d_finite_element_1::num_sub_elements() const
{
    return 2;
}

ufc::finite_element * cahnhilliard2d_finite_element_1::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_1::create() const
{
    return new cahnhilliard2d_finite_element_1();
}


cahnhilliard2d_finite_element_2::cahnhilliard2d_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard2d_finite_element_2::~cahnhilliard2d_finite_element_2()
{
    // Do nothing
}

const char * cahnhilliard2d_finite_element_2::signature() const
{
    return "MixedElement(FiniteElement('Lagrange', triangle, 1), FiniteElement('Lagrange', triangle, 1))";
}

ufc::shape cahnhilliard2d_finite_element_2::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t cahnhilliard2d_finite_element_2::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_2::geometric_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_2::space_dimension() const
{
    return 6;
}

std::size_t cahnhilliard2d_finite_element_2::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_2::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_finite_element_2::value_size() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_2::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_2::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_finite_element_2::reference_value_size() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_2::degree() const
{
    return 1;
}

const char * cahnhilliard2d_finite_element_2::family() const
{
    return "Mixed";
}

void cahnhilliard2d_finite_element_2::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_2::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard2d_finite_element_2::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard2d_finite_element_2::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard2d_finite_element_2::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard2d_finite_element_2::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[5] = vals[1];
}

void cahnhilliard2d_finite_element_2::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
}

void cahnhilliard2d_finite_element_2::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
}

std::size_t cahnhilliard2d_finite_element_2::num_sub_elements() const
{
    return 2;
}

ufc::finite_element * cahnhilliard2d_finite_element_2::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_2::create() const
{
    return new cahnhilliard2d_finite_element_2();
}


cahnhilliard2d_finite_element_3::cahnhilliard2d_finite_element_3() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard2d_finite_element_3::~cahnhilliard2d_finite_element_3()
{
    // Do nothing
}

const char * cahnhilliard2d_finite_element_3::signature() const
{
    return "FiniteElement('Real', triangle, 0)";
}

ufc::shape cahnhilliard2d_finite_element_3::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t cahnhilliard2d_finite_element_3::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_3::geometric_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_finite_element_3::space_dimension() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_3::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard2d_finite_element_3::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_3::value_size() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_3::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard2d_finite_element_3::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_3::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard2d_finite_element_3::degree() const
{
    return 0;
}

const char * cahnhilliard2d_finite_element_3::family() const
{
    return "Real";
}

void cahnhilliard2d_finite_element_3::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
}

void cahnhilliard2d_finite_element_3::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
}

void cahnhilliard2d_finite_element_3::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
}

void cahnhilliard2d_finite_element_3::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
}

double cahnhilliard2d_finite_element_3::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
      y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard2d_finite_element_3::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
}

void cahnhilliard2d_finite_element_3::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
}

void cahnhilliard2d_finite_element_3::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    dof_coordinates[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
}

std::size_t cahnhilliard2d_finite_element_3::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_3::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard2d_finite_element_3::create() const
{
    return new cahnhilliard2d_finite_element_3();
}


cahnhilliard2d_dofmap_0::cahnhilliard2d_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard2d_dofmap_0::~cahnhilliard2d_dofmap_0()
{
    // Do nothing
}

const char * cahnhilliard2d_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
}

bool cahnhilliard2d_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard2d_dofmap_0::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0];
}

std::size_t cahnhilliard2d_dofmap_0::num_element_dofs() const
{
    return 3;
}

std::size_t cahnhilliard2d_dofmap_0::num_facet_dofs() const
{
    return 2;
}

std::size_t cahnhilliard2d_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_dofmap_0::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard2d_dofmap_0::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
}

void cahnhilliard2d_dofmap_0::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_0::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_0::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

std::size_t cahnhilliard2d_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_0::create() const
{
    return new cahnhilliard2d_dofmap_0();
}


cahnhilliard2d_dofmap_1::cahnhilliard2d_dofmap_1() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard2d_dofmap_1::~cahnhilliard2d_dofmap_1()
{
    // Do nothing
}

const char * cahnhilliard2d_dofmap_1::signature() const
{
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
}

bool cahnhilliard2d_dofmap_1::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard2d_dofmap_1::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_dofmap_1::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

std::size_t cahnhilliard2d_dofmap_1::num_element_dofs() const
{
    return 6;
}

std::size_t cahnhilliard2d_dofmap_1::num_facet_dofs() const
{
    return 4;
}

std::size_t cahnhilliard2d_dofmap_1::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_dofmap_1::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard2d_dofmap_1::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
}

void cahnhilliard2d_dofmap_1::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_1::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_1::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
}

std::size_t cahnhilliard2d_dofmap_1::num_sub_dofmaps() const
{
    return 2;
}

ufc::dofmap * cahnhilliard2d_dofmap_1::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_1::create() const
{
    return new cahnhilliard2d_dofmap_1();
}


cahnhilliard2d_dofmap_2::cahnhilliard2d_dofmap_2() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard2d_dofmap_2::~cahnhilliard2d_dofmap_2()
{
    // Do nothing
}

const char * cahnhilliard2d_dofmap_2::signature() const
{
    return "FFC dofmap for MixedElement(FiniteElement('Lagrange', triangle, 1), FiniteElement('Lagrange', triangle, 1))";
}

bool cahnhilliard2d_dofmap_2::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard2d_dofmap_2::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_dofmap_2::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

std::size_t cahnhilliard2d_dofmap_2::num_element_dofs() const
{
    return 6;
}

std::size_t cahnhilliard2d_dofmap_2::num_facet_dofs() const
{
    return 4;
}

std::size_t cahnhilliard2d_dofmap_2::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_dofmap_2::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard2d_dofmap_2::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
}

void cahnhilliard2d_dofmap_2::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_2::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_2::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
}

std::size_t cahnhilliard2d_dofmap_2::num_sub_dofmaps() const
{
    return 2;
}

ufc::dofmap * cahnhilliard2d_dofmap_2::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_2::create() const
{
    return new cahnhilliard2d_dofmap_2();
}


cahnhilliard2d_dofmap_3::cahnhilliard2d_dofmap_3() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard2d_dofmap_3::~cahnhilliard2d_dofmap_3()
{
    // Do nothing
}

const char * cahnhilliard2d_dofmap_3::signature() const
{
    return "FFC dofmap for FiniteElement('Real', triangle, 0)";
}

bool cahnhilliard2d_dofmap_3::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard2d_dofmap_3::topological_dimension() const
{
    return 2;
}

std::size_t cahnhilliard2d_dofmap_3::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 1;
}

std::size_t cahnhilliard2d_dofmap_3::num_element_dofs() const
{
    return 1;
}

std::size_t cahnhilliard2d_dofmap_3::num_facet_dofs() const
{
    return 0;
}

std::size_t cahnhilliard2d_dofmap_3::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_dofmap_3::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard2d_dofmap_3::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = 0;
}

void cahnhilliard2d_dofmap_3::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_3::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

void cahnhilliard2d_dofmap_3::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          
          break;
        }
      case 1:
        {
          
          break;
        }
      case 2:
        {
          
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

std::size_t cahnhilliard2d_dofmap_3::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_3::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard2d_dofmap_3::create() const
{
    return new cahnhilliard2d_dofmap_3();
}


cahnhilliard2d_cell_integral_0_otherwise::cahnhilliard2d_cell_integral_0_otherwise() : ufc::cell_integral()
{

}

cahnhilliard2d_cell_integral_0_otherwise::~cahnhilliard2d_cell_integral_0_otherwise()
{

}

const std::vector<bool> & cahnhilliard2d_cell_integral_0_otherwise::enabled_coefficients() const
{
static const std::vector<bool> enabled({true, true, true, true, true});
return enabled;
}

void cahnhilliard2d_cell_integral_0_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 4
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 4
    //   quadrature_degree:           4
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights6[6] = { 0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 3 tables for 6 quadrature points
    alignas(32) static const double FE19_C0_D01_Q6[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE19_C0_D10_Q6[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE19_C0_Q6[1][6][3] =
        { { { 0.09157621350977, 0.816847572980459, 0.091576213509771 },
            { 0.0915762135097701, 0.0915762135097711, 0.816847572980459 },
            { 0.816847572980458, 0.091576213509771, 0.091576213509771 },
            { 0.445948490915965, 0.10810301816807, 0.445948490915965 },
            { 0.445948490915965, 0.445948490915965, 0.10810301816807 },
            { 0.10810301816807, 0.445948490915965, 0.445948490915965 } } };
    // Reset element tensor
    memset(A, 0, 6 * sizeof(*A));
    // Unstructured piecewise computations
    double w0_d1_c0 = 0.0;
    for (int ic = 0; ic < 3; ++ic)
    {
        w0_d1_c0 += w[0][ic] * FE19_C0_D01_Q6[0][0][ic - 0];
    }
    const double J_c0 = coordinate_dofs[0] * FE19_C0_D10_Q6[0][0][0] + coordinate_dofs[2] * FE19_C0_D10_Q6[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE19_C0_D01_Q6[0][0][0] + coordinate_dofs[3] * FE19_C0_D01_Q6[0][0][1] + coordinate_dofs[5] * FE19_C0_D01_Q6[0][0][2];
    const double J_c1 = coordinate_dofs[0] * FE19_C0_D01_Q6[0][0][0] + coordinate_dofs[2] * FE19_C0_D01_Q6[0][0][1] + coordinate_dofs[4] * FE19_C0_D01_Q6[0][0][2];
    const double J_c2 = coordinate_dofs[1] * FE19_C0_D10_Q6[0][0][0] + coordinate_dofs[3] * FE19_C0_D10_Q6[0][0][1];
    double w0_d0_c0 = 0.0;
    for (int ic = 0; ic < 2; ++ic)
    {
        w0_d0_c0 += w[0][ic] * FE19_C0_D10_Q6[0][0][ic - 0];
    }
    double w1_d1_c1 = 0.0;
    for (int ic = 3; ic < 6; ++ic)
    {
        w1_d1_c1 += w[1][ic] * FE19_C0_D01_Q6[0][0][ic - 3];
    }
    double w1_d0_c1 = 0.0;
    for (int ic = 3; ic < 5; ++ic)
    {
        w1_d0_c1 += w[1][ic] * FE19_C0_D10_Q6[0][0][ic - 3];
    }
    double w0_d1_c1 = 0.0;
    for (int ic = 3; ic < 6; ++ic)
    {
        w0_d1_c1 += w[0][ic] * FE19_C0_D01_Q6[0][0][ic - 3];
    }
    double w0_d0_c1 = 0.0;
    for (int ic = 3; ic < 5; ++ic)
    {
        w0_d0_c1 += w[0][ic] * FE19_C0_D10_Q6[0][0][ic - 3];
    }
    alignas(32) double sp6[55];
    sp6[0] = J_c0 * J_c3;
    sp6[1] = J_c1 * J_c2;
    sp6[2] = -1 * sp6[1];
    sp6[3] = sp6[0] + sp6[2];
    sp6[4] = J_c0 / sp6[3];
    sp6[5] = w0_d1_c0 * sp6[4];
    sp6[6] = -1 * J_c1;
    sp6[7] = sp6[6] / sp6[3];
    sp6[8] = w0_d0_c0 * sp6[7];
    sp6[9] = sp6[5] + sp6[8];
    sp6[10] = sp6[9] * sp6[4];
    sp6[11] = sp6[9] * sp6[7];
    sp6[12] = J_c3 / sp6[3];
    sp6[13] = w0_d0_c0 * sp6[12];
    sp6[14] = -1 * J_c2;
    sp6[15] = sp6[14] / sp6[3];
    sp6[16] = w0_d1_c0 * sp6[15];
    sp6[17] = sp6[13] + sp6[16];
    sp6[18] = sp6[17] * sp6[15];
    sp6[19] = sp6[17] * sp6[12];
    sp6[20] = sp6[10] + sp6[18];
    sp6[21] = sp6[19] + sp6[11];
    sp6[22] = sp6[20] * w[2][0];
    sp6[23] = sp6[21] * w[2][0];
    sp6[24] = -1 * sp6[22];
    sp6[25] = -1 * sp6[23];
    sp6[26] = w1_d1_c1 * sp6[4];
    sp6[27] = w1_d0_c1 * sp6[7];
    sp6[28] = sp6[26] + sp6[27];
    sp6[29] = -1 * w[4][0];
    sp6[30] = 1 + sp6[29];
    sp6[31] = sp6[28] * sp6[30];
    sp6[32] = w0_d1_c1 * sp6[4];
    sp6[33] = w0_d0_c1 * sp6[7];
    sp6[34] = sp6[32] + sp6[33];
    sp6[35] = sp6[34] * w[4][0];
    sp6[36] = sp6[31] + sp6[35];
    sp6[37] = sp6[36] * sp6[4];
    sp6[38] = sp6[36] * sp6[7];
    sp6[39] = w1_d0_c1 * sp6[12];
    sp6[40] = w1_d1_c1 * sp6[15];
    sp6[41] = sp6[39] + sp6[40];
    sp6[42] = sp6[41] * sp6[30];
    sp6[43] = w0_d0_c1 * sp6[12];
    sp6[44] = w0_d1_c1 * sp6[15];
    sp6[45] = sp6[43] + sp6[44];
    sp6[46] = sp6[45] * w[4][0];
    sp6[47] = sp6[42] + sp6[46];
    sp6[48] = sp6[47] * sp6[15];
    sp6[49] = sp6[47] * sp6[12];
    sp6[50] = sp6[37] + sp6[48];
    sp6[51] = sp6[49] + sp6[38];
    sp6[52] = sp6[50] * w[3][0];
    sp6[53] = sp6[51] * w[3][0];
    sp6[54] = std::abs(sp6[3]);
    for (int iq6 = 0; iq6 < 6; ++iq6)
    {
        // Quadrature loop body setup (num_points=6)
        // Unstructured varying computations
        double w0_c0 = 0.0;
        for (int ic = 0; ic < 3; ++ic)
        {
            w0_c0 += w[0][ic] * FE19_C0_Q6[0][iq6][ic - 0];
        }
        double w0_c1 = 0.0;
        for (int ic = 3; ic < 6; ++ic)
        {
            w0_c1 += w[0][ic] * FE19_C0_Q6[0][iq6][ic - 3];
        }
        double w1_c0 = 0.0;
        for (int ic = 0; ic < 3; ++ic)
        {
            w1_c0 += w[1][ic] * FE19_C0_Q6[0][iq6][ic - 0];
        }
        alignas(32) double sv6[22];
        sv6[0] = -1 * w1_c0;
        sv6[1] = w0_c0 + sv6[0];
        sv6[2] = -1 * w0_c0;
        sv6[3] = 1 + sv6[2];
        sv6[4] = -2.0 * sv6[3];
        sv6[5] = std::pow(w0_c0, 2);
        sv6[6] = 100 * sv6[5];
        sv6[7] = sv6[4] * sv6[6];
        sv6[8] = 2.0 * w0_c0;
        sv6[9] = 100 * sv6[8];
        sv6[10] = std::pow(sv6[3], 2);
        sv6[11] = sv6[9] * sv6[10];
        sv6[12] = sv6[7] + sv6[11];
        sv6[13] = -1 * sv6[12];
        sv6[14] = w0_c1 + sv6[13];
        sv6[15] = weights6[iq6] * sp6[54];
        sv6[16] = sv6[1] * sv6[15];
        sv6[17] = sv6[14] * sv6[15];
        sv6[18] = sp6[24] * sv6[15];
        sv6[19] = sp6[25] * sv6[15];
        sv6[20] = sv6[15] * sp6[52];
        sv6[21] = sv6[15] * sp6[53];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            A[ia0] += sv6[21] * FE19_C0_D10_Q6[0][0][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv6[16] * FE19_C0_Q6[0][iq6][ia0 - 0];
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            A[ia0] += sv6[20] * FE19_C0_D01_Q6[0][0][ia0 - 0];
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            A[ia0] += sv6[19] * FE19_C0_D10_Q6[0][0][ia0 - 3];
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            A[ia0] += sv6[17] * FE19_C0_Q6[0][iq6][ia0 - 3];
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            A[ia0] += sv6[18] * FE19_C0_D01_Q6[0][0][ia0 - 3];
        }
    }
}


cahnhilliard2d_cell_integral_1_otherwise::cahnhilliard2d_cell_integral_1_otherwise() : ufc::cell_integral()
{

}

cahnhilliard2d_cell_integral_1_otherwise::~cahnhilliard2d_cell_integral_1_otherwise()
{

}

const std::vector<bool> & cahnhilliard2d_cell_integral_1_otherwise::enabled_coefficients() const
{
static const std::vector<bool> enabled({true, true, true, true});
return enabled;
}

void cahnhilliard2d_cell_integral_1_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'uflacs' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 4
    //   quadrature_rule:   'default'
    //   representation:    'uflacs'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 4
    //   quadrature_degree:           4
    //   quadrature_rule:             'default'
    //   representation:              'uflacs'
    
    // Section for quadrature weights and points
    alignas(32) static const double weights6[6] = { 0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005 };
    // Section for precomputed element basis function values
    // Table dimensions: num_entities, num_points, num_dofs
    // Definitions of 3 tables for 6 quadrature points
    alignas(32) static const double FE17_C0_D01_Q6[1][1][3] = { { { -1.0, 0.0, 1.0 } } };
    alignas(32) static const double FE17_C0_D10_Q6[1][1][2] = { { { -1.0, 1.0 } } };
    alignas(32) static const double FE17_C0_Q6[1][6][3] =
        { { { 0.09157621350977, 0.816847572980459, 0.091576213509771 },
            { 0.0915762135097701, 0.0915762135097711, 0.816847572980459 },
            { 0.816847572980458, 0.091576213509771, 0.091576213509771 },
            { 0.445948490915965, 0.10810301816807, 0.445948490915965 },
            { 0.445948490915965, 0.445948490915965, 0.10810301816807 },
            { 0.10810301816807, 0.445948490915965, 0.445948490915965 } } };
    // Reset element tensor
    memset(A, 0, 36 * sizeof(*A));
    // Unstructured piecewise computations
    const double J_c0 = coordinate_dofs[0] * FE17_C0_D10_Q6[0][0][0] + coordinate_dofs[2] * FE17_C0_D10_Q6[0][0][1];
    const double J_c3 = coordinate_dofs[1] * FE17_C0_D01_Q6[0][0][0] + coordinate_dofs[3] * FE17_C0_D01_Q6[0][0][1] + coordinate_dofs[5] * FE17_C0_D01_Q6[0][0][2];
    const double J_c1 = coordinate_dofs[0] * FE17_C0_D01_Q6[0][0][0] + coordinate_dofs[2] * FE17_C0_D01_Q6[0][0][1] + coordinate_dofs[4] * FE17_C0_D01_Q6[0][0][2];
    const double J_c2 = coordinate_dofs[1] * FE17_C0_D10_Q6[0][0][0] + coordinate_dofs[3] * FE17_C0_D10_Q6[0][0][1];
    alignas(32) double sp6[46];
    sp6[0] = J_c0 * J_c3;
    sp6[1] = J_c1 * J_c2;
    sp6[2] = -1 * sp6[1];
    sp6[3] = sp6[0] + sp6[2];
    sp6[4] = J_c0 / sp6[3];
    sp6[5] = -1 * J_c1;
    sp6[6] = sp6[5] / sp6[3];
    sp6[7] = sp6[4] * sp6[4];
    sp6[8] = sp6[4] * sp6[6];
    sp6[9] = sp6[6] * sp6[6];
    sp6[10] = J_c3 / sp6[3];
    sp6[11] = -1 * J_c2;
    sp6[12] = sp6[11] / sp6[3];
    sp6[13] = sp6[12] * sp6[12];
    sp6[14] = sp6[10] * sp6[12];
    sp6[15] = sp6[10] * sp6[10];
    sp6[16] = sp6[7] + sp6[13];
    sp6[17] = sp6[8] + sp6[14];
    sp6[18] = sp6[15] + sp6[9];
    sp6[19] = sp6[16] * w[1][0];
    sp6[20] = sp6[17] * w[1][0];
    sp6[21] = sp6[18] * w[1][0];
    sp6[22] = -1 * sp6[19];
    sp6[23] = -1 * sp6[20];
    sp6[24] = -1 * sp6[21];
    sp6[25] = sp6[4] * w[3][0];
    sp6[26] = sp6[6] * w[3][0];
    sp6[27] = sp6[25] * sp6[4];
    sp6[28] = sp6[26] * sp6[4];
    sp6[29] = sp6[25] * sp6[6];
    sp6[30] = sp6[26] * sp6[6];
    sp6[31] = sp6[12] * w[3][0];
    sp6[32] = sp6[10] * w[3][0];
    sp6[33] = sp6[31] * sp6[12];
    sp6[34] = sp6[32] * sp6[12];
    sp6[35] = sp6[31] * sp6[10];
    sp6[36] = sp6[32] * sp6[10];
    sp6[37] = sp6[27] + sp6[33];
    sp6[38] = sp6[28] + sp6[34];
    sp6[39] = sp6[35] + sp6[29];
    sp6[40] = sp6[36] + sp6[30];
    sp6[41] = sp6[37] * w[2][0];
    sp6[42] = sp6[38] * w[2][0];
    sp6[43] = sp6[39] * w[2][0];
    sp6[44] = sp6[40] * w[2][0];
    sp6[45] = std::abs(sp6[3]);
    for (int iq6 = 0; iq6 < 6; ++iq6)
    {
        // Quadrature loop body setup (num_points=6)
        // Unstructured varying computations
        double w0_c0 = 0.0;
        for (int ic = 0; ic < 3; ++ic)
        {
            w0_c0 += w[0][ic] * FE17_C0_Q6[0][iq6][ic - 0];
        }
        alignas(32) double sv6[24];
        sv6[0] = -1 * w0_c0;
        sv6[1] = 1 + sv6[0];
        sv6[2] = -2.0 * sv6[1];
        sv6[3] = 2.0 * w0_c0;
        sv6[4] = 100 * sv6[3];
        sv6[5] = sv6[2] * sv6[4];
        sv6[6] = std::pow(w0_c0, 2);
        sv6[7] = 100 * sv6[6];
        sv6[8] = 2.0 * sv6[7];
        sv6[9] = sv6[5] + sv6[8];
        sv6[10] = std::pow(sv6[1], 2);
        sv6[11] = 200.0 * sv6[10];
        sv6[12] = sv6[5] + sv6[11];
        sv6[13] = sv6[9] + sv6[12];
        sv6[14] = -1 * sv6[13];
        sv6[15] = weights6[iq6] * sp6[45];
        sv6[16] = sv6[14] * sv6[15];
        sv6[17] = sp6[22] * sv6[15];
        sv6[18] = sp6[23] * sv6[15];
        sv6[19] = sp6[24] * sv6[15];
        sv6[20] = sv6[15] * sp6[41];
        sv6[21] = sv6[15] * sp6[42];
        sv6[22] = sv6[15] * sp6[43];
        sv6[23] = sv6[15] * sp6[44];
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[23] * FE17_C0_D10_Q6[0][0][ia0 - 0] * FE17_C0_D10_Q6[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 2; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[22] * FE17_C0_D10_Q6[0][0][ia0 - 0] * FE17_C0_D01_Q6[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[15] * FE17_C0_Q6[0][iq6][ia0 - 0] * FE17_C0_Q6[0][iq6][ia1 - 0];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 3; ia1 < 5; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[21] * FE17_C0_D01_Q6[0][0][ia0 - 0] * FE17_C0_D10_Q6[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 0; ia0 < 3; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[20] * FE17_C0_D01_Q6[0][0][ia0 - 0] * FE17_C0_D01_Q6[0][0][ia1 - 3];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[19] * FE17_C0_D10_Q6[0][0][ia0 - 3] * FE17_C0_D10_Q6[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 5; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[18] * FE17_C0_D10_Q6[0][0][ia0 - 3] * FE17_C0_D01_Q6[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 2; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[18] * FE17_C0_D01_Q6[0][0][ia0 - 3] * FE17_C0_D10_Q6[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[16] * FE17_C0_Q6[0][iq6][ia0 - 3] * FE17_C0_Q6[0][iq6][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 0; ia1 < 3; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[17] * FE17_C0_D01_Q6[0][0][ia0 - 3] * FE17_C0_D01_Q6[0][0][ia1 - 0];
            }
        }
        for (int ia0 = 3; ia0 < 6; ++ia0)
        {
            for (int ia1 = 3; ia1 < 6; ++ia1)
            {
                A[6 * ia0 + ia1] += sv6[15] * FE17_C0_Q6[0][iq6][ia0 - 3] * FE17_C0_Q6[0][iq6][ia1 - 3];
            }
        }
    }
}


cahnhilliard2d_form_0::cahnhilliard2d_form_0() : ufc::form()
{
    // Do nothing
}

cahnhilliard2d_form_0::~cahnhilliard2d_form_0()
{
    // Do nothing
}

const char * cahnhilliard2d_form_0::signature() const
{
    return "03ecafe51ceecb55e45bc10591368c600282bb005383c7aaeba30e140d0b1e11c455194608ebc5d3548488baaaf5640d11f53f65364ffcd9e109c19390bde656";
}

std::size_t cahnhilliard2d_form_0::rank() const
{
    return 1;
}

std::size_t cahnhilliard2d_form_0::num_coefficients() const
{
    return 5;
}

std::size_t cahnhilliard2d_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard2d_form_0::create_coordinate_finite_element() const
{
    return new cahnhilliard2d_finite_element_1();
}

ufc::dofmap * cahnhilliard2d_form_0::create_coordinate_dofmap() const
{
    return new cahnhilliard2d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard2d_form_0::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard2d_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard2d_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_0::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard2d_form_0::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard2d_form_0::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_0::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard2d_form_0::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard2d_form_0::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard2d_form_0::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard2d_form_0::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard2d_form_0::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard2d_form_0::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard2d_form_0::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard2d_form_0::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard2d_form_0::create_default_cell_integral() const
{
    return new cahnhilliard2d_cell_integral_0_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard2d_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard2d_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard2d_form_0::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard2d_form_0::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard2d_form_0::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard2d_form_0::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard2d_form_0::create_default_overlap_integral() const
{
    return 0;
}


cahnhilliard2d_form_1::cahnhilliard2d_form_1() : ufc::form()
{
    // Do nothing
}

cahnhilliard2d_form_1::~cahnhilliard2d_form_1()
{
    // Do nothing
}

const char * cahnhilliard2d_form_1::signature() const
{
    return "3aedd8e5fe0170c54f18eac8519eb71f691d8ad55d46c1b57748bf366f9d8357d821fcea1e008b0bb49a25a6cc59fda47de42978354754b999ca55059536b5b9";
}

std::size_t cahnhilliard2d_form_1::rank() const
{
    return 2;
}

std::size_t cahnhilliard2d_form_1::num_coefficients() const
{
    return 4;
}

std::size_t cahnhilliard2d_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard2d_form_1::create_coordinate_finite_element() const
{
    return new cahnhilliard2d_finite_element_1();
}

ufc::dofmap * cahnhilliard2d_form_1::create_coordinate_dofmap() const
{
    return new cahnhilliard2d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard2d_form_1::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard2d_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard2d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard2d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard2d_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard2d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard2d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard2d_form_1::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard2d_form_1::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard2d_form_1::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard2d_form_1::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard2d_form_1::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard2d_form_1::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard2d_form_1::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard2d_form_1::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard2d_form_1::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard2d_form_1::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard2d_form_1::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard2d_form_1::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard2d_form_1::create_default_cell_integral() const
{
    return new cahnhilliard2d_cell_integral_1_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard2d_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard2d_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard2d_form_1::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard2d_form_1::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard2d_form_1::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard2d_form_1::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard2d_form_1::create_default_overlap_integral() const
{
    return 0;
}

