import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin

class AstronomyPOTD(BasicComicModule, BounceMixin):
    baseUrl = 'http://antwrp.gsfc.nasa.gov/apod/astropix.html'
    imageUrl = 'http://antwrp.gsfc.nasa.gov/apod/ap%s.html'
    imageSearch = re.compile(r'<a href="(image/\d{4}/.+\..+?)">')
    prevSearch = re.compile(r'<a href="(ap\d{6}\.html)">&lt</a>')
    nextSearch = re.compile(r'<a href="(ap\d{6}\.html)">&gt</a>')
    help = 'Index format: yymmdd'

    def getFilename(self, imageUrl, pageUrl):
        return '%s-%s' % (pageUrl.split('/')[-1].split('.')[0][2:], imageUrl.split('/')[-1].split('.')[0])
