import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class ChasingTheSunset(BasicComicModule):
    imageSearch = re.compile(r'<img src="((?:../)?comics/[^"]*)"[^>]*id="comic"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]*)"><img[^>]*alt="previous"', re.IGNORECASE)
    help = 'Index format: n'

    submodules = {
        'normal': '',
        'big': '_1024',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = 'http://www.fantasycomic.com/'
        self.latestUrl = baseUrl + 'index%s.php' % self.submodules[submodule]
        self.imageUrl = baseUrl + 'comic%s.php?id=%%s' % self.submodules[submodule]
        self.name = 'ChasingTheSunset/' + submodule
