import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, IndirectLatestMixin

class FantasyRealms(BasicComicModule, IndirectLatestMixin):
    '''This module may not get the latest comic, since the front page
    references to the first page of the last update. If an update consists of
    multiple pages, only the first one is fetched, the others are fetched on
    the next update...'''
    baseUrl = 'http://www.fantasyrealmsonline.com/'
    imageUrl = 'http://www.fantasyrealmsonline.com/manga/%s.html'
    imageSearch = re.compile(r'<div align="center"><a href="[^"]+\.html"><img src="(\w+\.jpg)"')
    prevSearch = re.compile(r'<a href="([^"]+\.html)"><img src="\.\./\.\./images/nav-back\.jpg"')
    latestSearch = re.compile(r'<a href="(manga/\d+/\w+\.html)"><img src="latest\.jpg"')
    help = 'Index format: ii/pp (issue/page)'

    def getFilename(self, imageUrl, pageUrl):
        name = imageUrl.split('.')[-2].split('/')
        return name[-2] + '_' + name[-1]
