from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, bounceStarter, queryNamer


class PartiallyClips(BasicScraper):
    latestUrl = 'http://www.partiallyclips.com/'
    imageUrl = 'http://www.partiallyclips.com/index.php?id=%s'
    imageSearch = compile(r'"(http://www.partiallyclips.com/storage/.+?)"')
    prevSearch = compile(r'"(index.php\?id=.+?)".+?prev')
    help = 'Index format: nnnn'


class PastelDefender(BasicScraper):
    latestUrl = 'http://www.pasteldefender.com/'
    imageUrl = 'http://www.pasteldefender.com/%s.html'
    imageSearch = compile(r'<IMG SRC="(images/[^"]+)" WIDTH="742" HEIGHT="990"')
    prevSearch = compile(r'<A HREF="([^"]+)"><IMG SRC="images/back\.gif"')
    help = 'Index format: nnn'


class PebbleVersion(BasicScraper):
    latestUrl = 'http://www.pebbleversion.com/'
    imageUrl = 'http://www.pebbleversion.com/Archives/Strip%s.html'
    imageSearch = compile(r'<img src="(ComicStrips/.+?|../ComicStrips/.+?)"')
    prevSearch = compile(r'<a href="((?!.+?">First Comic)Archives/Strip.+?|(?=.+?">Previous Comic)(?!.+?">First Comic)Strip.+?)"')
    help = 'Index format: n (unpadded)'


class PennyAndAggie(BasicScraper):
    latestUrl = 'http://www.pennyandaggie.com/index.php'
    imageUrl = 'http://www.pennyandaggie.com/index.php\?p=%s'
    imageSearch = compile(r'src=".+?(/comics/.+?)"')
    prevSearch = compile(r"</a><a href='(index.php\?p=.+?)'.+?prev")
    help = 'Index format: n (unpadded)'


class PennyArcade(BasicScraper):
    latestUrl = 'http://www.penny-arcade.com/comic/'
    imageUrl = 'http://www.penny-arcade.com/comic/%s/'
    imageSearch = compile(r'(?<!<!--)<img src="(/images/\d{4}/\d{8}..+?)"')
    prevSearch = compile(r'<a href="(/comic/\d{1,4}/\d{1,2}/\d{1,2})/"><img alt="Back"')
    help = 'Index format: yyyy/mm/dd'


class PerkiGoth(BasicScraper):
    latestUrl = 'http://mutt.purrsia.com/main.php'
    imageUrl = 'http://mutt.purrsia.com/main.php?date=%s'
    imageSearch = compile(r'<img.+?src="(comics/.+?)"')
    prevSearch = compile(r'<a.+?href="(\?date=\d+/\d+/\d+)">Prev</a>')
    help = 'Index format: mm/dd/yyyy'


class Pixel(BasicScraper):
    latestUrl = 'http://www.chrisdlugosz.net/pixel/'
    imageUrl = 'http://www.chrisdlugosz.net/pixel/%s.shtml'
    imageSearch = compile(r'<IMG SRC="(\d+\.png)" ALT=""><BR><BR>')
    prevSearch = compile(r'<A HREF="(\d+\.shtml)"><IMG SRC="_prev.png" BORDER=0 ALT=""></A>')
    help = 'Index format: nnn'


class PockyBot(BasicScraper):
    latestUrl = 'http://www.pockybot.com/home/index.php'
    imageUrl = 'http://www.pockybot.com/home/archive.php?did=%s'
    imageSearch = compile(r'<img src="(\.\./strips/comic\d+\..+?)">')
    prevSearch = compile(r'<a href="(\.\./home/archive\.php\?bdid=\d+)">')
    help = 'Index format: n (unpadded)'


class PiledHigherAndDeeper(BasicScraper):
    starter = bounceStarter('http://www.phdcomics.com/comics/archive.php', compile(r'<a href=(archive\.php\?comicid=\d+)><img height=52 width=49 src=images/next_button\.gif border=0 align=middle>'))
    imageUrl = 'http://www.phdcomics.com/comics/archive.php?comicid=%s'
    imageSearch = compile(r'<img src=(http://www\.phdcomics\.com/comics/archive/phd\d+s?\.gif)')
    prevSearch = compile(r'<a href=(archive\.php\?comicid=\d+)><img height=52 width=49 src=images/prev_button\.gif border=0 align=middle>')
    help = 'Index format: n (unpadded)'
    namer = queryNamer('comicid', usePageUrl=True)


class PvPonline(BasicScraper):
    latestUrl = 'http://www.pvponline.com/'
    imageUrl = None
    imageSearch = compile(r"<img src='(http://www.pvponline.com/comics/pvp\d{8}\..+?)'", IGNORECASE)
    prevSearch = compile(r'<a href="(http://www.pvponline.com/[^"]+)"[^>]*><img src="http://www.pvponline.com/newsite/images/(?:yesterday|left)_curl.jpg"', IGNORECASE)
    help = 'Index format: yyyymmdd'


def pensAndTales(name, baseUrl):
    return BasicScraper.make(
        'PensAndTales/' + name,
        latestUrl=baseUrl,
        imageUrl=baseUrl + '?date=',
        imageSearch=compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', IGNORECASE),
        prevSearch=compile(r'<a href="([^"]*?\?date=\d+)">(:?<img[^>]+?alt=")?Previous Comic', IGNORECASE),
        help='Index format: yyyymmdd')


# XXX: using custom Wordpress layout
# th = pensAndTales('TreasureHunters', 'http://th.pensandtales.com/')
# XXX: comic broken, no content
# strangekith = pensAndTales('Strangekith', 'http://strangekith.pensandtales.com/')
# XXX: comic broken
# fireflycross = pensAndTales('FireflyCross', 'http://fireflycross.pensandtales.com/')
thosedestined = pensAndTales('ThoseDestined', 'http://thosedestined.pensandtales.com/')
evilish = pensAndTales('Evilish', 'http://evilish.pensandtales.com/')
redallover = pensAndTales('RedAllOver', 'http://redallover.pensandtales.com/')
stickyevil = pensAndTales('StickyEvil', 'http://stickyevil.pensandtales.com/')
# XXX: moved / layout changed
#ynt = pensAndTales('YamiNoTainai', 'http://ynt.pensandtales.com/')
earthbound = pensAndTales('Earthbound', 'http://earthbound.pensandtales.com/')
