/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_HELP_H
#define SETTINGS_HELP_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>
#include <vector>

#include <gtk--/window.h>
#include <gtk--/label.h>
#include <gtk--/table.h>
#include <gtk--/button.h>

#include "prog_defs.h"



class SettingsMessagesBase {

protected:
  // so some people don't like protected data -- tough, this
  // is a convenient implementation
  std::vector<std::string> captions;
  std::vector<std::string> messages;
public:
  std::string get_caption(std::vector<std::string>::size_type);
  std::string get_message(std::vector<std::string>::size_type);
  SettingsMessagesBase(std::vector<std::string>::size_type size): captions(size), messages(size) {}
};

class IdentityMessages: public SettingsMessagesBase {
public:
  enum {name = 0, number};
  IdentityMessages(void);
};

class ModemMessages: public SettingsMessagesBase {
public:
  enum {device = 0, lock, modem_class, dialmode, capabilities, rings};
  ModemMessages(void);
};

class ParmsMessages: public SettingsMessagesBase {
public:
  enum {init = 0, reset, extra_parms};
  ParmsMessages(void);
};

class PrintMessages: public SettingsMessagesBase {
public:
  enum {command = 0, shrink};
  PrintMessages(void);
};

class ViewMessages: public SettingsMessagesBase {
public:
  enum {command = 0, res};
  ViewMessages(void);
};

class LoggingMessages: public SettingsMessagesBase {
public:
  enum {logfile = 0};
  LoggingMessages(void);
};

class PageMessages: public SettingsMessagesBase {
public:
  enum {page = 0, res};
  PageMessages(void);
};

class SettingsHelpDialog: public Gtk::Window {
  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void kill_dialog(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  void run(void);
  SettingsHelpDialog(const int standard_size, const string& text, const string& caption, Gtk::Window&);
};

#endif
